/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.contacts;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.contacts.Contact;
import com.flickr4java.flickr.contacts.ContactList;
import com.flickr4java.flickr.contacts.OnlineStatus;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ContactsInterface {
    private static final String METHOD_GET_LIST = "flickr.contacts.getList";
    private static final String METHOD_GET_LIST_RECENTLY_UPLOADED = "flickr.contacts.getListRecentlyUploaded";
    private static final String METHOD_GET_PUBLIC_LIST = "flickr.contacts.getPublicList";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transportAPI;

    public ContactsInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public Collection<Contact> getList() throws FlickrException {
        ContactList<Contact> contacts = new ContactList<Contact>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LIST);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element contactsElement = response.getPayload();
        contacts.setPage(contactsElement.getAttribute("page"));
        contacts.setPages(contactsElement.getAttribute("pages"));
        contacts.setPerPage(contactsElement.getAttribute("perpage"));
        contacts.setTotal(contactsElement.getAttribute("total"));
        NodeList contactNodes = contactsElement.getElementsByTagName("contact");
        for (int i = 0; i < contactNodes.getLength(); ++i) {
            Element contactElement = (Element)contactNodes.item(i);
            Contact contact = new Contact();
            contact.setId(contactElement.getAttribute("nsid"));
            contact.setUsername(contactElement.getAttribute("username"));
            contact.setRealName(contactElement.getAttribute("realname"));
            contact.setFriend("1".equals(contactElement.getAttribute("friend")));
            contact.setFamily("1".equals(contactElement.getAttribute("family")));
            contact.setIgnored("1".equals(contactElement.getAttribute("ignored")));
            String lPathAlias = contactElement.getAttribute("path_alias");
            contact.setPathAlias(lPathAlias == null || "".equals(lPathAlias) ? null : lPathAlias);
            contact.setOnline(OnlineStatus.fromType(contactElement.getAttribute("online")));
            contact.setIconFarm(contactElement.getAttribute("iconfarm"));
            contact.setIconServer(contactElement.getAttribute("iconserver"));
            if (contact.getOnline() == OnlineStatus.AWAY) {
                contactElement.normalize();
                contact.setAwayMessage(XMLUtilities.getValue(contactElement));
            }
            contacts.add(contact);
        }
        return contacts;
    }

    public Collection<Contact> getListRecentlyUploaded(Date lastUpload, String filter2) throws FlickrException {
        Response response;
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LIST_RECENTLY_UPLOADED);
        if (lastUpload != null) {
            parameters.put("date_lastupload", String.valueOf(lastUpload.getTime() / 1000L));
        }
        if (filter2 != null) {
            parameters.put("filter", filter2);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element contactsElement = response.getPayload();
        NodeList contactNodes = contactsElement.getElementsByTagName("contact");
        for (int i = 0; i < contactNodes.getLength(); ++i) {
            Element contactElement = (Element)contactNodes.item(i);
            Contact contact = new Contact();
            contact.setId(contactElement.getAttribute("nsid"));
            contact.setUsername(contactElement.getAttribute("username"));
            contact.setRealName(contactElement.getAttribute("realname"));
            contact.setFriend("1".equals(contactElement.getAttribute("friend")));
            contact.setFamily("1".equals(contactElement.getAttribute("family")));
            contact.setIgnored("1".equals(contactElement.getAttribute("ignored")));
            contact.setOnline(OnlineStatus.fromType(contactElement.getAttribute("online")));
            contact.setIconFarm(contactElement.getAttribute("iconfarm"));
            contact.setIconServer(contactElement.getAttribute("iconserver"));
            if (contact.getOnline() == OnlineStatus.AWAY) {
                contactElement.normalize();
                contact.setAwayMessage(XMLUtilities.getValue(contactElement));
            }
            contacts.add(contact);
        }
        return contacts;
    }

    public Collection<Contact> getPublicList(String userId) throws FlickrException {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_PUBLIC_LIST);
        parameters.put("user_id", userId);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element contactsElement = response.getPayload();
        NodeList contactNodes = contactsElement.getElementsByTagName("contact");
        for (int i = 0; i < contactNodes.getLength(); ++i) {
            Element contactElement = (Element)contactNodes.item(i);
            Contact contact = new Contact();
            contact.setId(contactElement.getAttribute("nsid"));
            contact.setUsername(contactElement.getAttribute("username"));
            contact.setIgnored("1".equals(contactElement.getAttribute("ignored")));
            contact.setOnline(OnlineStatus.fromType(contactElement.getAttribute("online")));
            contact.setIconFarm(contactElement.getAttribute("iconfarm"));
            contact.setIconServer(contactElement.getAttribute("iconserver"));
            if (contact.getOnline() == OnlineStatus.AWAY) {
                contactElement.normalize();
                contact.setAwayMessage(XMLUtilities.getValue(contactElement));
            }
            contacts.add(contact);
        }
        return contacts;
    }
}

