/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.photos;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.REST;
import com.flickr4java.flickr.RequestContext;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.people.User;
import com.flickr4java.flickr.photos.Exif;
import com.flickr4java.flickr.photos.Extras;
import com.flickr4java.flickr.photos.Permissions;
import com.flickr4java.flickr.photos.Photo;
import com.flickr4java.flickr.photos.PhotoAllContext;
import com.flickr4java.flickr.photos.PhotoContext;
import com.flickr4java.flickr.photos.PhotoList;
import com.flickr4java.flickr.photos.PhotoSet;
import com.flickr4java.flickr.photos.PhotoSetList;
import com.flickr4java.flickr.photos.PhotoUtils;
import com.flickr4java.flickr.photos.Photocount;
import com.flickr4java.flickr.photos.Pool;
import com.flickr4java.flickr.photos.PoolList;
import com.flickr4java.flickr.photos.SearchParameters;
import com.flickr4java.flickr.photos.Size;
import com.flickr4java.flickr.photos.SizeList;
import com.flickr4java.flickr.photos.geo.GeoInterface;
import com.flickr4java.flickr.util.IOUtilities;
import com.flickr4java.flickr.util.StringUtilities;
import com.flickr4java.flickr.util.XMLUtilities;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PhotosInterface {
    public static final String METHOD_ADD_TAGS = "flickr.photos.addTags";
    public static final String METHOD_DELETE = "flickr.photos.delete";
    public static final String METHOD_GET_ALL_CONTEXTS = "flickr.photos.getAllContexts";
    public static final String METHOD_GET_CONTACTS_PHOTOS = "flickr.photos.getContactsPhotos";
    public static final String METHOD_GET_CONTACTS_PUBLIC_PHOTOS = "flickr.photos.getContactsPublicPhotos";
    public static final String METHOD_GET_CONTEXT = "flickr.photos.getContext";
    public static final String METHOD_GET_COUNTS = "flickr.photos.getCounts";
    public static final String METHOD_GET_EXIF = "flickr.photos.getExif";
    public static final String METHOD_GET_FAVORITES = "flickr.photos.getFavorites";
    public static final String METHOD_GET_INFO = "flickr.photos.getInfo";
    public static final String METHOD_GET_NOT_IN_SET = "flickr.photos.getNotInSet";
    public static final String METHOD_GET_PERMS = "flickr.photos.getPerms";
    public static final String METHOD_GET_RECENT = "flickr.photos.getRecent";
    public static final String METHOD_GET_SIZES = "flickr.photos.getSizes";
    public static final String METHOD_GET_UNTAGGED = "flickr.photos.getUntagged";
    public static final String METHOD_GET_WITH_GEO_DATA = "flickr.photos.getWithGeoData";
    public static final String METHOD_GET_WITHOUT_GEO_DATA = "flickr.photos.getWithoutGeoData";
    public static final String METHOD_RECENTLY_UPDATED = "flickr.photos.recentlyUpdated";
    public static final String METHOD_REMOVE_TAG = "flickr.photos.removeTag";
    public static final String METHOD_SEARCH = "flickr.photos.search";
    public static final String METHOD_SET_CONTENTTYPE = "flickr.photos.setContentType";
    public static final String METHOD_SET_DATES = "flickr.photos.setDates";
    public static final String METHOD_SET_META = "flickr.photos.setMeta";
    public static final String METHOD_SET_PERMS = "flickr.photos.setPerms";
    public static final String METHOD_SET_SAFETYLEVEL = "flickr.photos.setSafetyLevel";
    public static final String METHOD_SET_TAGS = "flickr.photos.setTags";
    public static final String METHOD_GET_INTERESTINGNESS = "flickr.interestingness.getList";
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATS = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private GeoInterface geoInterface = null;
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transport;

    public PhotosInterface(String apiKey, String sharedSecret, Transport transport) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transport = transport;
    }

    public synchronized GeoInterface getGeoInterface() {
        if (this.geoInterface == null) {
            this.geoInterface = new GeoInterface(this.apiKey, this.sharedSecret, this.transport);
        }
        return this.geoInterface;
    }

    public void addTags(String photoId, String[] tags) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_ADD_TAGS);
        parameters.put("photo_id", photoId);
        parameters.put("tags", StringUtilities.join(tags, " ", true));
        Response response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void delete(String photoId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_DELETE);
        parameters.put("photo_id", photoId);
        Response response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public PhotoAllContext getAllContexts(String photoId) throws FlickrException {
        PhotoSetList<PhotoSet> setList = new PhotoSetList<PhotoSet>();
        PoolList<Pool> poolList = new PoolList<Pool>();
        PhotoAllContext allContext = new PhotoAllContext();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_ALL_CONTEXTS);
        parameters.put("photo_id", photoId);
        Response response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Collection<Element> photosElement = response.getPayloadCollection();
        for (Element setElement : photosElement) {
            if (setElement.getTagName().equals("set")) {
                PhotoSet pset = new PhotoSet();
                pset.setTitle(setElement.getAttribute("title"));
                pset.setSecret(setElement.getAttribute("secret"));
                pset.setId(setElement.getAttribute("id"));
                pset.setFarm(setElement.getAttribute("farm"));
                pset.setPrimary(setElement.getAttribute("primary"));
                pset.setServer(setElement.getAttribute("server"));
                pset.setViewCount(Integer.parseInt(setElement.getAttribute("view_count")));
                pset.setCommentCount(Integer.parseInt(setElement.getAttribute("comment_count")));
                pset.setCountPhoto(Integer.parseInt(setElement.getAttribute("count_photo")));
                pset.setCountVideo(Integer.parseInt(setElement.getAttribute("count_video")));
                setList.add(pset);
                allContext.setPhotoSetList(setList);
                continue;
            }
            if (!setElement.getTagName().equals("pool")) continue;
            Pool pool = new Pool();
            pool.setTitle(setElement.getAttribute("title"));
            pool.setId(setElement.getAttribute("id"));
            pool.setUrl(setElement.getAttribute("url"));
            pool.setIconServer(setElement.getAttribute("iconserver"));
            pool.setIconFarm(setElement.getAttribute("iconfarm"));
            pool.setMemberCount(Integer.parseInt(setElement.getAttribute("members")));
            pool.setPoolCount(Integer.parseInt(setElement.getAttribute("pool_count")));
            poolList.add(pool);
            allContext.setPoolList(poolList);
        }
        return allContext;
    }

    public PhotoList<Photo> getContactsPhotos(int count, boolean justFriends, boolean singlePhoto, boolean includeSelf) throws FlickrException {
        Response response;
        PhotoList<Photo> photos = new PhotoList<Photo>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_CONTACTS_PHOTOS);
        if (count > 0) {
            parameters.put("count", Integer.toString(count));
        }
        if (justFriends) {
            parameters.put("just_friends", "1");
        }
        if (singlePhoto) {
            parameters.put("single_photo", "1");
        }
        if (includeSelf) {
            parameters.put("include_self", "1");
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        NodeList photoNodes = photosElement.getElementsByTagName("photo");
        photos.setPage("1");
        photos.setPages("1");
        photos.setPerPage("" + photoNodes.getLength());
        photos.setTotal("" + photoNodes.getLength());
        for (int i = 0; i < photoNodes.getLength(); ++i) {
            Element photoElement = (Element)photoNodes.item(i);
            photos.add(PhotoUtils.createPhoto(photoElement));
        }
        return photos;
    }

    public PhotoList<Photo> getContactsPublicPhotos(String userId, int count, boolean justFriends, boolean singlePhoto, boolean includeSelf) throws FlickrException {
        return this.getContactsPublicPhotos(userId, Extras.MIN_EXTRAS, count, justFriends, singlePhoto, includeSelf);
    }

    public PhotoList<Photo> getContactsPublicPhotos(String userId, Set<String> extras, int count, boolean justFriends, boolean singlePhoto, boolean includeSelf) throws FlickrException {
        Response response;
        PhotoList<Photo> photos = new PhotoList<Photo>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_CONTACTS_PUBLIC_PHOTOS);
        parameters.put("user_id", userId);
        if (count > 0) {
            parameters.put("count", Integer.toString(count));
        }
        if (justFriends) {
            parameters.put("just_friends", "1");
        }
        if (singlePhoto) {
            parameters.put("single_photo", "1");
        }
        if (includeSelf) {
            parameters.put("include_self", "1");
        }
        if (extras != null) {
            StringBuffer sb = new StringBuffer();
            Iterator<String> it = extras.iterator();
            int i = 0;
            while (it.hasNext()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(it.next());
                ++i;
            }
            parameters.put("extras", sb.toString());
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        NodeList photoNodes = photosElement.getElementsByTagName("photo");
        photos.setPage("1");
        photos.setPages("1");
        photos.setPerPage("" + photoNodes.getLength());
        photos.setTotal("" + photoNodes.getLength());
        for (int i = 0; i < photoNodes.getLength(); ++i) {
            Element photoElement = (Element)photoNodes.item(i);
            photos.add(PhotoUtils.createPhoto(photoElement));
        }
        return photos;
    }

    public PhotoContext getContext(String photoId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_CONTEXT);
        parameters.put("photo_id", photoId);
        Response response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        PhotoContext photoContext = new PhotoContext();
        Collection<Element> payload = response.getPayloadCollection();
        for (Element payloadElement : payload) {
            Photo photo;
            String tagName = payloadElement.getTagName();
            if (tagName.equals("prevphoto")) {
                photo = new Photo();
                photo.setId(payloadElement.getAttribute("id"));
                photo.setSecret(payloadElement.getAttribute("secret"));
                photo.setTitle(payloadElement.getAttribute("title"));
                photo.setFarm(payloadElement.getAttribute("farm"));
                photo.setUrl(payloadElement.getAttribute("url"));
                photoContext.setPreviousPhoto(photo);
                continue;
            }
            if (!tagName.equals("nextphoto")) continue;
            photo = new Photo();
            photo.setId(payloadElement.getAttribute("id"));
            photo.setSecret(payloadElement.getAttribute("secret"));
            photo.setTitle(payloadElement.getAttribute("title"));
            photo.setFarm(payloadElement.getAttribute("farm"));
            photo.setUrl(payloadElement.getAttribute("url"));
            photoContext.setNextPhoto(photo);
        }
        return photoContext;
    }

    public Collection<Photocount> getCounts(Date[] dates, Date[] takenDates) throws FlickrException {
        Response response;
        int i;
        ArrayList<Photocount> photocounts = new ArrayList<Photocount>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_COUNTS);
        if (dates == null && takenDates == null) {
            throw new IllegalArgumentException("You must provide a value for either dates or takenDates");
        }
        if (dates != null) {
            ArrayList<String> dateList = new ArrayList<String>();
            for (i = 0; i < dates.length; ++i) {
                dateList.add(String.valueOf(dates[i].getTime() / 1000L));
            }
            parameters.put("dates", StringUtilities.join(dateList, ","));
        }
        if (takenDates != null) {
            ArrayList<String> takenDateList = new ArrayList<String>();
            for (i = 0; i < takenDates.length; ++i) {
                takenDateList.add(String.valueOf(takenDates[i].getTime() / 1000L));
            }
            parameters.put("taken_dates", StringUtilities.join(takenDateList, ","));
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photocountsElement = response.getPayload();
        NodeList photocountNodes = photocountsElement.getElementsByTagName("photocount");
        for (int i2 = 0; i2 < photocountNodes.getLength(); ++i2) {
            Element photocountElement = (Element)photocountNodes.item(i2);
            Photocount photocount = new Photocount();
            photocount.setCount(photocountElement.getAttribute("count"));
            photocount.setFromDate(photocountElement.getAttribute("fromdate"));
            photocount.setToDate(photocountElement.getAttribute("todate"));
            photocounts.add(photocount);
        }
        return photocounts;
    }

    public Collection<Exif> getExif(String photoId, String secret) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_EXIF);
        parameters.put("photo_id", photoId);
        if (secret != null) {
            parameters.put("secret", secret);
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        ArrayList<Exif> exifs = new ArrayList<Exif>();
        Element photoElement = response.getPayload();
        NodeList exifElements = photoElement.getElementsByTagName("exif");
        for (int i = 0; i < exifElements.getLength(); ++i) {
            Element exifElement = (Element)exifElements.item(i);
            Exif exif = new Exif();
            exif.setTagspace(exifElement.getAttribute("tagspace"));
            exif.setTagspaceId(exifElement.getAttribute("tagspaceid"));
            exif.setTag(exifElement.getAttribute("tag"));
            exif.setLabel(exifElement.getAttribute("label"));
            exif.setRaw(XMLUtilities.getChildValue(exifElement, "raw"));
            exif.setClean(XMLUtilities.getChildValue(exifElement, "clean"));
            exifs.add(exif);
        }
        return exifs;
    }

    public Collection<User> getFavorites(String photoId, int perPage, int page) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_FAVORITES);
        parameters.put("photo_id", photoId);
        if (perPage > 0) {
            parameters.put("per_page", Integer.toString(perPage));
        }
        if (page > 0) {
            parameters.put("page", Integer.toString(page));
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        ArrayList<User> users = new ArrayList<User>();
        Element userRoot = response.getPayload();
        NodeList userNodes = userRoot.getElementsByTagName("person");
        for (int i = 0; i < userNodes.getLength(); ++i) {
            Element userElement = (Element)userNodes.item(i);
            User user = new User();
            user.setId(userElement.getAttribute("nsid"));
            user.setUsername(userElement.getAttribute("username"));
            user.setFaveDate(userElement.getAttribute("favedate"));
            users.add(user);
        }
        return users;
    }

    public Photo getInfo(String photoId, String secret) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_INFO);
        parameters.put("photo_id", photoId);
        if (secret != null) {
            parameters.put("secret", secret);
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photoElement = response.getPayload();
        return PhotoUtils.createPhoto(photoElement);
    }

    public PhotoList<Photo> getNotInSet(int perPage, int page) throws FlickrException {
        Response response;
        PhotoList<Photo> photos = new PhotoList<Photo>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_NOT_IN_SET);
        RequestContext requestContext = RequestContext.getRequestContext();
        List<String> extras = requestContext.getExtras();
        if (extras.size() > 0) {
            parameters.put("extras", StringUtilities.join(extras, ","));
        }
        if (perPage > 0) {
            parameters.put("per_page", Integer.toString(perPage));
        }
        if (page > 0) {
            parameters.put("page", Integer.toString(page));
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        photos.setPage(photosElement.getAttribute("page"));
        photos.setPages(photosElement.getAttribute("pages"));
        photos.setPerPage(photosElement.getAttribute("perpage"));
        photos.setTotal(photosElement.getAttribute("total"));
        NodeList photoElements = photosElement.getElementsByTagName("photo");
        for (int i = 0; i < photoElements.getLength(); ++i) {
            Element photoElement = (Element)photoElements.item(i);
            photos.add(PhotoUtils.createPhoto(photoElement));
        }
        return photos;
    }

    public Permissions getPerms(String photoId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_PERMS);
        parameters.put("photo_id", photoId);
        Response response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element permissionsElement = response.getPayload();
        Permissions permissions = new Permissions();
        permissions.setId(permissionsElement.getAttribute("id"));
        permissions.setPublicFlag("1".equals(permissionsElement.getAttribute("ispublic")));
        permissions.setFamilyFlag("1".equals(permissionsElement.getAttribute("isfamily")));
        permissions.setFriendFlag("1".equals(permissionsElement.getAttribute("isfriend")));
        permissions.setComment(permissionsElement.getAttribute("permcomment"));
        permissions.setAddmeta(permissionsElement.getAttribute("permaddmeta"));
        return permissions;
    }

    public PhotoList<Photo> getRecent(Set<String> extras, int perPage, int page) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_RECENT);
        if (extras != null && !extras.isEmpty()) {
            parameters.put("extras", StringUtilities.join(extras, ","));
        }
        if (perPage > 0) {
            parameters.put("per_page", Integer.toString(perPage));
        }
        if (page > 0) {
            parameters.put("page", Integer.toString(page));
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        PhotoList<Photo> photos = PhotoUtils.createPhotoList(photosElement);
        return photos;
    }

    public Collection<Size> getSizes(String photoId) throws FlickrException {
        return this.getSizes(photoId, false);
    }

    public Collection<Size> getSizes(String photoId, boolean sign) throws FlickrException {
        SizeList<Size> sizes = new SizeList<Size>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_SIZES);
        parameters.put("photo_id", photoId);
        Response response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element sizesElement = response.getPayload();
        sizes.setIsCanBlog("1".equals(sizesElement.getAttribute("canblog")));
        sizes.setIsCanDownload("1".equals(sizesElement.getAttribute("candownload")));
        sizes.setIsCanPrint("1".equals(sizesElement.getAttribute("canprint")));
        NodeList sizeNodes = sizesElement.getElementsByTagName("size");
        for (int i = 0; i < sizeNodes.getLength(); ++i) {
            Element sizeElement = (Element)sizeNodes.item(i);
            Size size = new Size();
            size.setLabel(sizeElement.getAttribute("label"));
            size.setWidth(sizeElement.getAttribute("width"));
            size.setHeight(sizeElement.getAttribute("height"));
            size.setSource(sizeElement.getAttribute("source"));
            size.setUrl(sizeElement.getAttribute("url"));
            size.setMedia(sizeElement.getAttribute("media"));
            sizes.add(size);
        }
        return sizes;
    }

    public PhotoList<Photo> getUntagged(int perPage, int page) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_UNTAGGED);
        if (perPage > 0) {
            parameters.put("per_page", Integer.toString(perPage));
        }
        if (page > 0) {
            parameters.put("page", Integer.toString(page));
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        PhotoList<Photo> photos = PhotoUtils.createPhotoList(photosElement);
        return photos;
    }

    public PhotoList<Photo> getWithGeoData(Date minUploadDate, Date maxUploadDate, Date minTakenDate, Date maxTakenDate, int privacyFilter, String sort, Set<String> extras, int perPage, int page) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_WITH_GEO_DATA);
        if (minUploadDate != null) {
            parameters.put("min_upload_date", Long.toString(minUploadDate.getTime() / 1000L));
        }
        if (maxUploadDate != null) {
            parameters.put("max_upload_date", Long.toString(maxUploadDate.getTime() / 1000L));
        }
        if (minTakenDate != null) {
            parameters.put("min_taken_date", Long.toString(minTakenDate.getTime() / 1000L));
        }
        if (maxTakenDate != null) {
            parameters.put("max_taken_date", Long.toString(maxTakenDate.getTime() / 1000L));
        }
        if (privacyFilter > 0) {
            parameters.put("privacy_filter", Integer.toString(privacyFilter));
        }
        if (sort != null) {
            parameters.put("sort", sort);
        }
        if (extras != null && !extras.isEmpty()) {
            parameters.put("extras", StringUtilities.join(extras, ","));
        }
        if (perPage > 0) {
            parameters.put("per_page", Integer.toString(perPage));
        }
        if (page > 0) {
            parameters.put("page", Integer.toString(page));
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        PhotoList<Photo> photos = PhotoUtils.createPhotoList(photosElement);
        return photos;
    }

    public PhotoList<Photo> getWithoutGeoData(Date minUploadDate, Date maxUploadDate, Date minTakenDate, Date maxTakenDate, int privacyFilter, String sort, Set<String> extras, int perPage, int page) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_WITHOUT_GEO_DATA);
        if (minUploadDate != null) {
            parameters.put("min_upload_date", Long.toString(minUploadDate.getTime() / 1000L));
        }
        if (maxUploadDate != null) {
            parameters.put("max_upload_date", Long.toString(maxUploadDate.getTime() / 1000L));
        }
        if (minTakenDate != null) {
            parameters.put("min_taken_date", Long.toString(minTakenDate.getTime() / 1000L));
        }
        if (maxTakenDate != null) {
            parameters.put("max_taken_date", Long.toString(maxTakenDate.getTime() / 1000L));
        }
        if (privacyFilter > 0) {
            parameters.put("privacy_filter", Long.toString(privacyFilter));
        }
        if (sort != null) {
            parameters.put("sort", sort);
        }
        if (extras != null && !extras.isEmpty()) {
            parameters.put("extras", StringUtilities.join(extras, ","));
        }
        if (perPage > 0) {
            parameters.put("per_page", Integer.toString(perPage));
        }
        if (page > 0) {
            parameters.put("page", Integer.toString(page));
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        PhotoList<Photo> photos = PhotoUtils.createPhotoList(photosElement);
        return photos;
    }

    public PhotoList<Photo> recentlyUpdated(Date minDate, Set<String> extras, int perPage, int page) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_RECENTLY_UPDATED);
        parameters.put("min_date", Long.toString(minDate.getTime() / 1000L));
        if (extras != null && !extras.isEmpty()) {
            parameters.put("extras", StringUtilities.join(extras, ","));
        }
        if (perPage > 0) {
            parameters.put("per_page", Integer.toString(perPage));
        }
        if (page > 0) {
            parameters.put("page", Integer.toString(page));
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        PhotoList<Photo> photos = PhotoUtils.createPhotoList(photosElement);
        return photos;
    }

    public void removeTag(String tagId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_REMOVE_TAG);
        parameters.put("tag_id", tagId);
        Response response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public PhotoList<Photo> search(SearchParameters params, int perPage, int page) throws FlickrException {
        Response response;
        PhotoList<Photo> photos = new PhotoList<Photo>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SEARCH);
        parameters.putAll(params.getAsParameters());
        if (perPage > 0) {
            parameters.put("per_page", "" + perPage);
        }
        if (page > 0) {
            parameters.put("page", "" + page);
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        photos.setPage(photosElement.getAttribute("page"));
        photos.setPages(photosElement.getAttribute("pages"));
        photos.setPerPage(photosElement.getAttribute("perpage"));
        photos.setTotal(photosElement.getAttribute("total"));
        NodeList photoNodes = photosElement.getElementsByTagName("photo");
        for (int i = 0; i < photoNodes.getLength(); ++i) {
            Element photoElement = (Element)photoNodes.item(i);
            photos.add(PhotoUtils.createPhoto(photoElement));
        }
        return photos;
    }

    public PhotoList<Photo> searchInterestingness(SearchParameters params, int perPage, int page) throws FlickrException {
        Response response;
        PhotoList<Photo> photos = new PhotoList<Photo>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_INTERESTINGNESS);
        parameters.putAll(params.getAsParameters());
        if (perPage > 0) {
            parameters.put("per_page", Integer.toString(perPage));
        }
        if (page > 0) {
            parameters.put("page", Integer.toString(page));
        }
        if ((response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        photos.setPage(photosElement.getAttribute("page"));
        photos.setPages(photosElement.getAttribute("pages"));
        photos.setPerPage(photosElement.getAttribute("perpage"));
        photos.setTotal(photosElement.getAttribute("total"));
        NodeList photoNodes = photosElement.getElementsByTagName("photo");
        for (int i = 0; i < photoNodes.getLength(); ++i) {
            Element photoElement = (Element)photoNodes.item(i);
            Photo photo = new Photo();
            photo.setId(photoElement.getAttribute("id"));
            User owner = new User();
            owner.setId(photoElement.getAttribute("owner"));
            photo.setOwner(owner);
            photo.setSecret(photoElement.getAttribute("secret"));
            photo.setServer(photoElement.getAttribute("server"));
            photo.setFarm(photoElement.getAttribute("farm"));
            photo.setTitle(photoElement.getAttribute("title"));
            photo.setPublicFlag("1".equals(photoElement.getAttribute("ispublic")));
            photo.setFriendFlag("1".equals(photoElement.getAttribute("isfriend")));
            photo.setFamilyFlag("1".equals(photoElement.getAttribute("isfamily")));
            photos.add(photo);
        }
        return photos;
    }

    public void setContentType(String photoId, String contentType) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SET_CONTENTTYPE);
        parameters.put("photo_id", photoId);
        parameters.put("content_type", contentType);
        Response response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void setDates(String photoId, Date datePosted, Date dateTaken, String dateTakenGranularity) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SET_DATES);
        parameters.put("photo_id", photoId);
        if (datePosted != null) {
            parameters.put("date_posted", Long.toString(datePosted.getTime() / 1000L));
        }
        if (dateTaken != null) {
            parameters.put("date_taken", ((DateFormat)DATE_FORMATS.get()).format(dateTaken));
        }
        if (dateTakenGranularity != null) {
            parameters.put("date_taken_granularity", dateTakenGranularity);
        }
        if ((response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void setMeta(String photoId, String title, String description) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SET_META);
        parameters.put("photo_id", photoId);
        parameters.put("title", title);
        parameters.put("description", description);
        Response response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void setPerms(String photoId, Permissions permissions) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SET_PERMS);
        parameters.put("photo_id", photoId);
        parameters.put("is_public", permissions.isPublicFlag() ? "1" : "0");
        parameters.put("is_friend", permissions.isFriendFlag() ? "1" : "0");
        parameters.put("is_family", permissions.isFamilyFlag() ? "1" : "0");
        parameters.put("perm_comment", Integer.toString(permissions.getComment()));
        parameters.put("perm_addmeta", Integer.toString(permissions.getAddmeta()));
        Response response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void setSafetyLevel(String photoId, String safetyLevel, Boolean hidden) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SET_SAFETYLEVEL);
        parameters.put("photo_id", photoId);
        if (safetyLevel != null) {
            parameters.put("safety_level", safetyLevel);
        }
        if (hidden != null) {
            parameters.put("hidden", hidden != false ? "1" : "0");
        }
        if ((response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void setTags(String photoId, String[] tags) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SET_TAGS);
        parameters.put("photo_id", photoId);
        parameters.put("tags", StringUtilities.join(tags, " ", true));
        Response response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public Photo getPhoto(String id) throws FlickrException {
        return this.getPhoto(id, null);
    }

    public Photo getPhoto(String id, String secret) throws FlickrException {
        return this.getInfo(id, secret);
    }

    public InputStream getImageAsStream(Photo photo, int size) throws FlickrException {
        try {
            String urlStr = "";
            if (size == 1) {
                urlStr = photo.getSmallSquareUrl();
            } else if (size == 0) {
                urlStr = photo.getThumbnailUrl();
            } else if (size == 2) {
                urlStr = photo.getSmallUrl();
            } else if (size == 3) {
                urlStr = photo.getMediumUrl();
            } else if (size == 4) {
                urlStr = photo.getLargeUrl();
            } else if (size == 10) {
                urlStr = photo.getLarge1600Url();
            } else if (size == 11) {
                urlStr = photo.getLarge2048Url();
            } else if (size == 5) {
                urlStr = photo.getOriginalUrl();
            } else if (size == 6) {
                urlStr = photo.getSquareLargeUrl();
            } else if (size == 7) {
                urlStr = photo.getSmall320Url();
            } else if (size == 8) {
                urlStr = photo.getMedium640Url();
            } else if (size == 9) {
                urlStr = photo.getMedium800Url();
            } else if (size == 14) {
                urlStr = photo.getVideoOriginalUrl();
            } else if (size == 13) {
                urlStr = photo.getVideoPlayerUrl();
            } else if (size == 12) {
                urlStr = photo.getSiteMP4Url();
            } else if (size == 15) {
                urlStr = photo.getMobileMp4Url();
            } else if (size == 16) {
                urlStr = photo.getHdMp4Url();
            } else {
                throw new FlickrException("0", "Unknown Photo-size");
            }
            URL url = new URL(urlStr);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            if (this.transport instanceof REST && ((REST)this.transport).isProxyAuth()) {
                conn.setRequestProperty("Proxy-Authorization", "Basic " + ((REST)this.transport).getProxyCredentials());
            }
            conn.connect();
            return conn.getInputStream();
        }
        catch (IOException e) {
            throw new FlickrException(e.getMessage(), e.getCause());
        }
    }

    public BufferedImage getImage(Photo photo, int size) throws FlickrException {
        try {
            return ImageIO.read(this.getImageAsStream(photo, size));
        }
        catch (IOException e) {
            throw new FlickrException(e.getMessage(), e.getCause());
        }
    }

    public BufferedImage getImage(String urlStr) throws FlickrException {
        BufferedImage bufferedImage;
        InputStream in = null;
        try {
            URL url = new URL(urlStr);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            if (this.transport instanceof REST && ((REST)this.transport).isProxyAuth()) {
                conn.setRequestProperty("Proxy-Authorization", "Basic " + ((REST)this.transport).getProxyCredentials());
            }
            conn.connect();
            in = conn.getInputStream();
            bufferedImage = ImageIO.read(in);
        }
        catch (IOException e) {
            try {
                throw new FlickrException(e.getMessage(), e.getCause());
            }
            catch (Throwable throwable) {
                IOUtilities.close(in);
                throw throwable;
            }
        }
        IOUtilities.close(in);
        return bufferedImage;
    }
}

