/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.tags;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.photos.Photo;
import com.flickr4java.flickr.photos.PhotoList;
import com.flickr4java.flickr.photos.PhotoUtils;
import com.flickr4java.flickr.tags.Cluster;
import com.flickr4java.flickr.tags.ClusterList;
import com.flickr4java.flickr.tags.HotlistTag;
import com.flickr4java.flickr.tags.RelatedTagsList;
import com.flickr4java.flickr.tags.Tag;
import com.flickr4java.flickr.tags.TagRaw;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TagsInterface {
    public static final String METHOD_GET_CLUSTERS = "flickr.tags.getClusters";
    public static final String METHOD_GET_HOT_LIST = "flickr.tags.getHotList";
    public static final String METHOD_GET_LIST_PHOTO = "flickr.tags.getListPhoto";
    public static final String METHOD_GET_LIST_USER = "flickr.tags.getListUser";
    public static final String METHOD_GET_LIST_USER_POPULAR = "flickr.tags.getListUserPopular";
    public static final String METHOD_GET_LIST_USER_RAW = "flickr.tags.getListUserRaw";
    public static final String METHOD_GET_RELATED = "flickr.tags.getRelated";
    public static final String METHOD_GET_CLUSTER_PHOTOS = "flickr.tags.getClusterPhotos";
    public static final String PERIOD_WEEK = "week";
    public static final String PERIOD_DAY = "day";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transportAPI;

    public TagsInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public ClusterList getClusters(String searchTag) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_CLUSTERS);
        parameters.put("tag", searchTag);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        ClusterList clusters = new ClusterList();
        Element clustersElement = response.getPayload();
        NodeList clusterElements = clustersElement.getElementsByTagName("cluster");
        for (int i = 0; i < clusterElements.getLength(); ++i) {
            Cluster cluster = new Cluster();
            NodeList tagElements = ((Element)clusterElements.item(i)).getElementsByTagName("tag");
            for (int j = 0; j < tagElements.getLength(); ++j) {
                Tag tag = new Tag();
                tag.setValue(((Text)tagElements.item(j).getFirstChild()).getData());
                cluster.addTag(tag);
            }
            clusters.addCluster(cluster);
        }
        return clusters;
    }

    public PhotoList<Photo> getClusterPhotos(String tag, String clusterId) throws FlickrException {
        PhotoList<Photo> photos = new PhotoList<Photo>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_CLUSTER_PHOTOS);
        parameters.put("tag", tag);
        parameters.put("cluster_id", clusterId);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        NodeList photoNodes = photosElement.getElementsByTagName("photo");
        photos.setPage("1");
        photos.setPages("1");
        photos.setPerPage("" + photoNodes.getLength());
        photos.setTotal("" + photoNodes.getLength());
        for (int i = 0; i < photoNodes.getLength(); ++i) {
            Element photoElement = (Element)photoNodes.item(i);
            photos.add(PhotoUtils.createPhoto(photoElement));
        }
        return photos;
    }

    public Collection<HotlistTag> getHotList(String period, int count) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_HOT_LIST);
        parameters.put("period", period);
        parameters.put("count", "" + count);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Collection<Element> payloadCollection = response.getPayloadCollection();
        Optional<Element> element = payloadCollection.stream().filter(payload -> payload.getTagName().equals("hottags")).findFirst();
        ArrayList<HotlistTag> tags = new ArrayList<HotlistTag>();
        if (element.isPresent()) {
            NodeList tagElements = element.get().getElementsByTagName("tag");
            for (int i = 0; i < tagElements.getLength(); ++i) {
                Element tagElement = (Element)tagElements.item(i);
                HotlistTag tag = new HotlistTag();
                tag.setValue(((Text)tagElement.getFirstChild()).getData());
                tags.add(tag);
            }
        }
        return tags;
    }

    public Photo getListPhoto(String photoId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LIST_PHOTO);
        parameters.put("photo_id", photoId);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photoElement = response.getPayload();
        Photo photo = new Photo();
        photo.setId(photoElement.getAttribute("id"));
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Element tagsElement = (Element)photoElement.getElementsByTagName("tags").item(0);
        NodeList tagElements = tagsElement.getElementsByTagName("tag");
        for (int i = 0; i < tagElements.getLength(); ++i) {
            Element tagElement = (Element)tagElements.item(i);
            Tag tag = new Tag();
            tag.setId(tagElement.getAttribute("id"));
            tag.setAuthor(tagElement.getAttribute("author"));
            tag.setAuthorName(tagElement.getAttribute("authorname"));
            tag.setRaw(tagElement.getAttribute("raw"));
            tag.setValue(((Text)tagElement.getFirstChild()).getData());
            tags.add(tag);
        }
        photo.setTags(tags);
        return photo;
    }

    public Collection<Tag> getListUser(String userId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LIST_USER);
        parameters.put("user_id", userId);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element whoElement = response.getPayload();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Element tagsElement = (Element)whoElement.getElementsByTagName("tags").item(0);
        NodeList tagElements = tagsElement.getElementsByTagName("tag");
        for (int i = 0; i < tagElements.getLength(); ++i) {
            Element tagElement = (Element)tagElements.item(i);
            Tag tag = new Tag();
            tag.setValue(((Text)tagElement.getFirstChild()).getData());
            tags.add(tag);
        }
        return tags;
    }

    public Collection<Tag> getListUserPopular(String userId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LIST_USER_POPULAR);
        parameters.put("user_id", userId);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element whoElement = response.getPayload();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Element tagsElement = (Element)whoElement.getElementsByTagName("tags").item(0);
        NodeList tagElements = tagsElement.getElementsByTagName("tag");
        for (int i = 0; i < tagElements.getLength(); ++i) {
            Element tagElement = (Element)tagElements.item(i);
            Tag tag = new Tag();
            tag.setCount(tagElement.getAttribute("count"));
            tag.setValue(((Text)tagElement.getFirstChild()).getData());
            tags.add(tag);
        }
        return tags;
    }

    public Collection<TagRaw> getListUserRaw() throws FlickrException {
        return this.getListUserRaw(null);
    }

    public Collection<TagRaw> getListUserRaw(String tagVal) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LIST_USER_RAW);
        if (tagVal != null) {
            parameters.put("tag", tagVal);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element whoElement = response.getPayload();
        ArrayList<TagRaw> tags = new ArrayList<TagRaw>();
        Element tagsElement = (Element)whoElement.getElementsByTagName("tags").item(0);
        NodeList tagElements = tagsElement.getElementsByTagName("tag");
        for (int i = 0; i < tagElements.getLength(); ++i) {
            Element tagElement = (Element)tagElements.item(i);
            TagRaw tag = new TagRaw();
            tag.setClean(tagElement.getAttribute("clean"));
            NodeList rawElements = tagElement.getElementsByTagName("raw");
            for (int j = 0; j < rawElements.getLength(); ++j) {
                Element rawElement = (Element)rawElements.item(j);
                tag.addRaw(((Text)rawElement.getFirstChild()).getData());
            }
            tags.add(tag);
        }
        return tags;
    }

    public RelatedTagsList getRelated(String tag) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_RELATED);
        parameters.put("tag", tag);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element tagsElement = response.getPayload();
        RelatedTagsList tags = new RelatedTagsList();
        tags.setSource(tagsElement.getAttribute("source"));
        NodeList tagElements = tagsElement.getElementsByTagName("tag");
        for (int i = 0; i < tagElements.getLength(); ++i) {
            Element tagElement = (Element)tagElements.item(i);
            Tag t = new Tag();
            t.setValue(XMLUtilities.getValue(tagElement));
            tags.add(t);
        }
        return tags;
    }
}

