/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.uploader;

import com.flickr4java.flickr.util.StringUtilities;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class UploadMetaData {
    private String filename = "image.jpg";
    private String fileMimeType = "image/jpeg";
    private String title;
    private String description;
    private Collection<String> tags;
    private boolean publicFlag;
    private boolean friendFlag;
    private boolean familyFlag;
    private boolean async;
    private Boolean hidden;
    private String safetyLevel;
    private String contentType;
    private String photoId;

    public String getTitle() {
        return this.title;
    }

    public UploadMetaData setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public UploadMetaData setDescription(String description) {
        this.description = description;
        return this;
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public UploadMetaData setTags(Collection<String> tags) {
        this.tags = tags;
        return this;
    }

    public boolean isPublicFlag() {
        return this.publicFlag;
    }

    public UploadMetaData setPublicFlag(boolean publicFlag) {
        this.publicFlag = publicFlag;
        return this;
    }

    public boolean isFriendFlag() {
        return this.friendFlag;
    }

    public UploadMetaData setFriendFlag(boolean friendFlag) {
        this.friendFlag = friendFlag;
        return this;
    }

    public boolean isFamilyFlag() {
        return this.familyFlag;
    }

    public UploadMetaData setFamilyFlag(boolean familyFlag) {
        this.familyFlag = familyFlag;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public UploadMetaData setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public UploadMetaData setHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public String getSafetyLevel() {
        return this.safetyLevel;
    }

    public UploadMetaData setSafetyLevel(String safetyLevel) {
        this.safetyLevel = safetyLevel;
        return this;
    }

    public String getFilename() {
        return this.filename;
    }

    public UploadMetaData setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public String getFilemimetype() {
        return this.fileMimeType;
    }

    public void setFilemimetype(String fileMimeType) {
        this.fileMimeType = fileMimeType;
    }

    public boolean isAsync() {
        return this.async;
    }

    public UploadMetaData setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public String getPhotoId() {
        return this.photoId;
    }

    public void setPhotoId(String photoId) {
        this.photoId = photoId;
    }

    public Map<String, String> getUploadParameters() {
        Collection<String> tags;
        String description;
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        String title = this.getTitle();
        if (title != null) {
            parameters.put("title", title);
        }
        if ((description = this.getDescription()) != null) {
            parameters.put("description", description);
        }
        if ((tags = this.getTags()) != null) {
            parameters.put("tags", StringUtilities.join(tags, " "));
        }
        if (this.isHidden() != null) {
            parameters.put("hidden", this.isHidden() != false ? "1" : "0");
        }
        if (this.getSafetyLevel() != null) {
            parameters.put("safety_level", this.getSafetyLevel());
        }
        if (this.getContentType() != null) {
            parameters.put("content_type", this.getContentType());
        }
        if (this.getPhotoId() != null) {
            parameters.put("photo_id", this.getPhotoId());
        }
        parameters.put("is_public", this.isPublicFlag() ? "1" : "0");
        parameters.put("is_family", this.isFamilyFlag() ? "1" : "0");
        parameters.put("is_friend", this.isFriendFlag() ? "1" : "0");
        parameters.put("async", this.isAsync() ? "1" : "0");
        return parameters;
    }

    public static UploadMetaData replace(boolean async, String photoId) {
        UploadMetaData metaData = new UploadMetaData();
        metaData.async = async;
        metaData.photoId = photoId;
        return metaData;
    }
}

