/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.uploader;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.REST;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.uploader.IUploader;
import com.flickr4java.flickr.uploader.Payload;
import com.flickr4java.flickr.uploader.UploadMetaData;
import com.flickr4java.flickr.uploader.UploaderResponse;
import java.io.File;
import java.io.InputStream;

public class Uploader
implements IUploader {
    private static final String SERVICES_REPLACE_PATH = "/services/replace/";
    private static final String SERVICES_UPLOAD_PATH = "/services/upload/";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transport;

    public Uploader(String apiKey, String sharedSecret) {
        this(apiKey, sharedSecret, new REST("up.flickr.com"));
        this.transport.setResponseClass(UploaderResponse.class);
    }

    public Uploader(String apiKey, String sharedSecret, Transport transport) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transport = transport;
    }

    @Override
    public String upload(byte[] data, UploadMetaData metaData) throws FlickrException {
        Payload payload = new Payload(data);
        return this.sendUploadRequest(metaData, payload);
    }

    @Override
    public String upload(File file, UploadMetaData metaData) throws FlickrException {
        Payload payload = new Payload(file);
        return this.sendUploadRequest(metaData, payload);
    }

    @Override
    public String upload(InputStream in, UploadMetaData metaData) throws FlickrException {
        Payload payload = new Payload(in);
        return this.sendUploadRequest(metaData, payload);
    }

    @Override
    public String replace(InputStream in, String flickrId, boolean async) throws FlickrException {
        Payload payload = new Payload(in, flickrId);
        return this.sendReplaceRequest(async, payload);
    }

    @Override
    public String replace(byte[] data, String flickrId, boolean async) throws FlickrException {
        Payload payload = new Payload(data, flickrId);
        return this.sendReplaceRequest(async, payload);
    }

    @Override
    public String replace(File file, String flickrId, boolean async) throws FlickrException {
        Payload payload = new Payload(file, flickrId);
        return this.sendReplaceRequest(async, payload);
    }

    private String sendUploadRequest(UploadMetaData metaData, Payload payload) throws FlickrException {
        UploaderResponse response = (UploaderResponse)this.transport.postMultiPart(SERVICES_UPLOAD_PATH, metaData, payload, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        return this.getResponseString(metaData.isAsync(), response);
    }

    private String sendReplaceRequest(boolean async, Payload payload) throws FlickrException {
        UploaderResponse response = (UploaderResponse)this.transport.postMultiPart(SERVICES_REPLACE_PATH, UploadMetaData.replace(async, payload.getPhotoId()), payload, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        return this.getResponseString(async, response);
    }

    private String getResponseString(boolean async, UploaderResponse response) {
        return async ? response.getTicketId() : response.getPhotoId();
    }

    public REST getTransport() {
        return (REST)this.transport;
    }
}

