/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.util;

import com.flickr4java.flickr.Flickr;
import com.flickr4java.flickr.RequestContext;
import com.flickr4java.flickr.auth.Auth;
import com.github.scribejava.apis.FlickrApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OAuthUtilities {
    private static final Logger logger = LoggerFactory.getLogger(OAuthUtilities.class);

    private OAuthUtilities() {
    }

    public static OAuth10aService createOAuthService(String apiKey, String sharedSecret, Integer connectTimeoutMs, Integer readTimeoutMs) {
        JDKHttpClientConfig config = JDKHttpClientConfig.defaultConfig();
        if (connectTimeoutMs != null) {
            config.setConnectTimeout(connectTimeoutMs);
        }
        if (readTimeoutMs != null) {
            config.setReadTimeout(readTimeoutMs);
        }
        ServiceBuilder serviceBuilder = new ServiceBuilder(apiKey).apiSecret(sharedSecret).httpClientConfig(config);
        if (Flickr.debugRequest) {
            serviceBuilder = serviceBuilder.debug();
        }
        return serviceBuilder.build(FlickrApi.instance());
    }

    public static void signRequest(OAuth10aService service, OAuthRequest request, String proxyCredentials) {
        Auth auth = RequestContext.getRequestContext().getAuth();
        if (auth != null) {
            service.signRequest(new OAuth1AccessToken(auth.getToken(), auth.getTokenSecret()), request);
        }
        if (proxyCredentials != null) {
            request.addHeader("Proxy-Authorization", "Basic " + proxyCredentials);
        }
        if (Flickr.debugRequest) {
            logger.debug("POST: {}", (Object)request.getCompleteUrl());
        }
    }

    public static OAuthRequest buildNormalPostRequest(Map<String, ?> parameters, String url) {
        OAuthRequest request = new OAuthRequest(Verb.POST, url);
        parameters.entrySet().forEach(e -> request.addBodyParameter((String)e.getKey(), String.valueOf(e.getValue())));
        return request;
    }

    public static OAuthRequest buildMultipartRequest(Map<String, String> parameters, String url) {
        OAuthRequest request = new OAuthRequest(Verb.POST, url);
        String multipartBoundary = OAuthUtilities.getMultipartBoundary();
        request.initMultipartPayload(multipartBoundary);
        request.addHeader("Content-Type", "multipart/form-data; boundary=" + multipartBoundary);
        parameters.entrySet().forEach(e -> request.addQuerystringParameter((String)e.getKey(), (String)e.getValue()));
        return request;
    }

    private static String getMultipartBoundary() {
        return "---------------------------" + UUID.randomUUID();
    }
}

