/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;

public class MediaWikiApi
extends DefaultApi10a {
    private final String indexUrl;
    private final String niceUrlBase;

    public MediaWikiApi(String indexUrl, String niceUrlBase) {
        this.indexUrl = indexUrl;
        this.niceUrlBase = niceUrlBase;
    }

    public static MediaWikiApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static MediaWikiApi instanceBeta() {
        return BetaInstanceHolder.BETA_INSTANCE;
    }

    @Override
    public String getRequestTokenEndpoint() {
        return this.indexUrl + "?title=Special:OAuth/initiate";
    }

    @Override
    public String getAuthorizationBaseUrl() {
        return this.niceUrlBase + "Special:OAuth/authorize";
    }

    @Override
    public String getAccessTokenEndpoint() {
        return this.indexUrl + "?title=Special:OAuth/token";
    }

    private static class InstanceHolder {
        private static final MediaWikiApi INSTANCE = new MediaWikiApi("https://meta.wikimedia.org/w/index.php", "https://meta.wikimedia.org/wiki/");

        private InstanceHolder() {
        }
    }

    private static class BetaInstanceHolder {
        private static final MediaWikiApi BETA_INSTANCE = new MediaWikiApi("https://meta.wikimedia.beta.wmflabs.org/w/index.php", "https://meta.wikimedia.beta.wmflabs.org/wiki/");

        private BetaInstanceHolder() {
        }
    }
}

