/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.instagram;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.apis.facebook.FacebookAccessTokenJsonExtractor;
import com.github.scribejava.apis.instagram.InstagramAccessTokenErrorResponse;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.Response;
import java.io.IOException;

public class InstagramAccessTokenJsonExtractor
extends OAuth2AccessTokenJsonExtractor {
    protected InstagramAccessTokenJsonExtractor() {
    }

    public static InstagramAccessTokenJsonExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public void generateError(Response response) throws IOException {
        JsonNode errorNode = OAuth2AccessTokenJsonExtractor.OBJECT_MAPPER.readTree(response.getBody());
        JsonNode error = errorNode.get("error");
        if (error == null) {
            throw new InstagramAccessTokenErrorResponse(errorNode.get("error_type").asText(), errorNode.get("code").asInt(), errorNode.get("error_message").asText(), response);
        }
        FacebookAccessTokenJsonExtractor.instance().generateError(response);
    }

    private static class InstanceHolder {
        private static final InstagramAccessTokenJsonExtractor INSTANCE = new InstagramAccessTokenJsonExtractor();

        private InstanceHolder() {
        }
    }
}

