/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth1Token;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.utils.Preconditions;
import java.io.IOException;

public abstract class AbstractOAuth1JSONTokenExtractor<T extends OAuth1Token>
implements TokenExtractor<T> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Override
    public T extract(Response response) throws IOException {
        String rawBody = response.getBody();
        Preconditions.checkEmptyString(rawBody, "Response body is incorrect. Can't extract a token from an empty string");
        JsonNode body2 = OBJECT_MAPPER.readTree(rawBody);
        JsonNode token = body2.get("oauth_token");
        JsonNode secret = body2.get("oauth_token_secret");
        if (token == null || secret == null) {
            throw new OAuthException("Response body is incorrect. Can't extract token and secret from this: '" + rawBody + '\'', null);
        }
        return this.createToken(token.asText(), secret.asText(), rawBody);
    }

    protected abstract T createToken(String var1, String var2, String var3);
}

