/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.extractors;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OAuth2AccessTokenExtractor
implements TokenExtractor<OAuth2AccessToken> {
    private static final Pattern ACCESS_TOKEN_REGEX_PATTERN = Pattern.compile("access_token=([^&]+)");
    private static final Pattern TOKEN_TYPE_REGEX_PATTERN = Pattern.compile("token_type=([^&]+)");
    private static final Pattern EXPIRES_IN_REGEX_PATTERN = Pattern.compile("expires_in=([^&]+)");
    private static final Pattern REFRESH_TOKEN_REGEX_PATTERN = Pattern.compile("refresh_token=([^&]+)");
    private static final Pattern SCOPE_REGEX_PATTERN = Pattern.compile("scope=([^&]+)");

    protected OAuth2AccessTokenExtractor() {
    }

    public static OAuth2AccessTokenExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public OAuth2AccessToken extract(Response response) throws IOException {
        Integer expiresIn;
        if (response.getCode() != 200) {
            throw new OAuthException("Response code is not 200 but '" + response.getCode() + '\'');
        }
        String body2 = response.getBody();
        Preconditions.checkEmptyString(body2, "Response body is incorrect. Can't extract a token from an empty string");
        String accessToken = OAuth2AccessTokenExtractor.extractParameter(body2, ACCESS_TOKEN_REGEX_PATTERN, true);
        String tokenType = OAuth2AccessTokenExtractor.extractParameter(body2, TOKEN_TYPE_REGEX_PATTERN, false);
        String expiresInString = OAuth2AccessTokenExtractor.extractParameter(body2, EXPIRES_IN_REGEX_PATTERN, false);
        try {
            expiresIn = expiresInString == null ? null : Integer.valueOf(expiresInString);
        }
        catch (NumberFormatException nfe) {
            expiresIn = null;
        }
        String refreshToken = OAuth2AccessTokenExtractor.extractParameter(body2, REFRESH_TOKEN_REGEX_PATTERN, false);
        String scope = OAuth2AccessTokenExtractor.extractParameter(body2, SCOPE_REGEX_PATTERN, false);
        return new OAuth2AccessToken(accessToken, tokenType, expiresIn, refreshToken, scope, body2);
    }

    private static String extractParameter(String response, Pattern regexPattern, boolean required) throws OAuthException {
        Matcher matcher = regexPattern.matcher(response);
        if (matcher.find()) {
            return OAuthEncoder.decode(matcher.group(1));
        }
        if (required) {
            throw new OAuthException("Response body is incorrect. Can't extract a '" + regexPattern.pattern() + "' from this: '" + response + "'", null);
        }
        return null;
    }

    private static class InstanceHolder {
        private static final OAuth2AccessTokenExtractor INSTANCE = new OAuth2AccessTokenExtractor();

        private InstanceHolder() {
        }
    }
}

