/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import io.github.classgraph.ClassGraph;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;

public final class ClassPathUtils {
    public static Set<Class<?>> scanPackage(ClassLoader classLoader, Package pkg) throws IOException {
        return ClassPathUtils.scanPackage(classLoader, pkg.getName());
    }

    public static Set<Class<?>> scanPackage(ClassLoader classLoader, String pkg) throws IOException {
        return new ClassGraph().enableClassInfo().acceptPackages(pkg).rejectPackages("com.sun", "com.apple").overrideClassLoaders(classLoader).scan().getAllClasses().stream().map(info -> ClassPathUtils.safeClassForName(classLoader, info.getName())).collect(Collectors.toSet());
    }

    public static Class<?> safeClassForName(ClassLoader classLoader, String className) {
        try {
            if (className.startsWith("com.sun.") || className.startsWith("com.apple.")) {
                return null;
            }
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    private ClassPathUtils() {
    }
}

