/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.AnnotationHelper;
import com.querydsl.codegen.ClassPathUtils;
import com.querydsl.codegen.CodegenModule;
import com.querydsl.codegen.EmbeddableSerializer;
import com.querydsl.codegen.EntitySerializer;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.GeneratedAnnotationResolver;
import com.querydsl.codegen.ProjectionSerializer;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.PropertyHandling;
import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.Serializer;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.SimpleSerializerConfig;
import com.querydsl.codegen.Supertype;
import com.querydsl.codegen.SupertypeSerializer;
import com.querydsl.codegen.TypeFactory;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.codegen.utils.AbstractCodeWriter;
import com.querydsl.codegen.utils.JavaWriter;
import com.querydsl.codegen.utils.ScalaWriter;
import com.querydsl.codegen.utils.model.Constructor;
import com.querydsl.codegen.utils.model.Parameter;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.codegen.utils.support.ClassUtils;
import com.querydsl.core.QueryException;
import com.querydsl.core.annotations.Config;
import com.querydsl.core.annotations.PropertyType;
import com.querydsl.core.annotations.QueryEmbeddable;
import com.querydsl.core.annotations.QueryEmbedded;
import com.querydsl.core.annotations.QueryEntity;
import com.querydsl.core.annotations.QueryExclude;
import com.querydsl.core.annotations.QueryInit;
import com.querydsl.core.annotations.QueryProjection;
import com.querydsl.core.annotations.QuerySupertype;
import com.querydsl.core.annotations.QueryTransient;
import com.querydsl.core.annotations.QueryType;
import com.querydsl.core.util.Annotations;
import com.querydsl.core.util.BeanUtils;
import com.querydsl.core.util.ReflectionUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class GenericExporter {
    private Class<? extends Annotation> entityAnnotation = QueryEntity.class;
    private Class<? extends Annotation> supertypeAnnotation = QuerySupertype.class;
    private Class<? extends Annotation> embeddableAnnotation = QueryEmbeddable.class;
    private Class<? extends Annotation> embeddedAnnotation = QueryEmbedded.class;
    private Class<? extends Annotation> skipAnnotation = QueryTransient.class;
    private boolean createScalaSources = false;
    private final Set<Class<?>> stopClasses = new HashSet();
    private final Map<String, EntityType> allTypes = new HashMap<String, EntityType>();
    private final Map<Class<?>, EntityType> entityTypes = new HashMap();
    private final Map<Class<?>, EntityType> superTypes = new HashMap();
    private final Map<Class<?>, EntityType> embeddableTypes = new HashMap();
    private final Map<Class<?>, EntityType> projectionTypes = new HashMap();
    private final CodegenModule codegenModule = new CodegenModule();
    private SerializerConfig serializerConfig = SimpleSerializerConfig.DEFAULT;
    @Deprecated
    private boolean handleFields = true;
    @Deprecated
    private boolean handleMethods = true;
    private PropertyHandling propertyHandling = PropertyHandling.ALL;
    private boolean useFieldTypes = false;
    @Nullable
    private File targetFolder;
    @Nullable
    private TypeFactory typeFactory;
    private final List<AnnotationHelper> annotationHelpers = new ArrayList<AnnotationHelper>();
    @Nullable
    private TypeMappings typeMappings;
    @Nullable
    private QueryTypeFactory queryTypeFactory;
    @Nullable
    private Class<? extends Serializer> serializerClass;
    private final Charset charset;
    private final ClassLoader classLoader;
    private Set<File> generatedFiles = new HashSet<File>();
    private boolean strictMode;

    public GenericExporter(ClassLoader classLoader, Charset charset) {
        this.classLoader = classLoader;
        this.charset = charset;
        this.stopClasses.add(Object.class);
        this.stopClasses.add(Enum.class);
    }

    public GenericExporter(ClassLoader classLoader) {
        this(classLoader, Charset.defaultCharset());
    }

    public GenericExporter(Charset charset) {
        this(Thread.currentThread().getContextClassLoader(), charset);
    }

    public GenericExporter() {
        this(Thread.currentThread().getContextClassLoader(), Charset.defaultCharset());
    }

    public void export(Package ... packages) {
        String[] pkgs = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            pkgs[i] = packages[i].getName();
        }
        this.export(pkgs);
    }

    public void export(String ... packages) {
        this.scanPackages(packages);
        this.innerExport();
    }

    public void export(Class<?> ... classes) {
        for (Class<?> cl : classes) {
            this.handleClass(cl);
        }
        this.innerExport();
    }

    /*
     * WARNING - void declaration
     */
    private void innerExport() {
        this.typeMappings = this.codegenModule.get(TypeMappings.class);
        this.queryTypeFactory = this.codegenModule.get(QueryTypeFactory.class);
        this.typeFactory = new TypeFactory(Arrays.asList(this.entityAnnotation, this.supertypeAnnotation, this.embeddableAnnotation), this.codegenModule.get(Function.class, "variableNameFunction"));
        for (AnnotationHelper annotationHelper : this.annotationHelpers) {
            this.typeFactory.addAnnotationHelper(annotationHelper);
        }
        for (Class clazz : this.superTypes.keySet()) {
            this.createEntityType(clazz, this.superTypes);
        }
        for (Class clazz : this.embeddableTypes.keySet()) {
            this.createEntityType(clazz, this.embeddableTypes);
        }
        for (Class clazz : this.entityTypes.keySet()) {
            this.createEntityType(clazz, this.entityTypes);
        }
        for (Class clazz : this.projectionTypes.keySet()) {
            this.createEntityType(clazz, this.projectionTypes);
        }
        for (Map map : Arrays.asList(this.superTypes, this.embeddableTypes, this.entityTypes, this.projectionTypes)) {
            for (Map.Entry entry : new HashSet(map.entrySet())) {
                this.addConstructors((Class)entry.getKey(), (EntityType)entry.getValue());
                this.addProperties((Class)entry.getKey(), (EntityType)entry.getValue());
            }
        }
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType type : this.superTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.entityTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        for (EntityType type : this.embeddableTypes.values()) {
            this.addSupertypeFields(type, this.allTypes, handled);
        }
        this.typeFactory.extendTypes();
        try {
            void var2_18;
            Serializer projectionSerializer;
            Serializer embeddableSerializer;
            Serializer entitySerializer;
            if (this.serializerClass != null) {
                Serializer serializer;
                Serializer serializer2 = serializer = this.codegenModule.get(this.serializerClass);
                entitySerializer = serializer;
                embeddableSerializer = serializer;
                projectionSerializer = serializer;
            } else {
                Serializer serializer = this.codegenModule.get(SupertypeSerializer.class);
                entitySerializer = this.codegenModule.get(EntitySerializer.class);
                embeddableSerializer = this.codegenModule.get(EmbeddableSerializer.class);
                projectionSerializer = this.codegenModule.get(ProjectionSerializer.class);
            }
            this.serialize((Serializer)var2_18, this.superTypes);
            this.serialize(entitySerializer, this.entityTypes);
            this.serialize(embeddableSerializer, this.embeddableTypes);
            this.serialize(projectionSerializer, this.projectionTypes);
        }
        catch (IOException iOException) {
            throw new QueryException(iOException);
        }
    }

    private void addSupertypeFields(EntityType model, Map<String, EntityType> superTypes, Set<EntityType> handled) {
        if (handled.add(model)) {
            for (Supertype supertype : model.getSuperTypes()) {
                EntityType entityType = superTypes.get(supertype.getType().getFullName());
                if (entityType == null) {
                    if (supertype.getType().getPackageName().startsWith("java.")) continue;
                    Class<?> cl = supertype.getType().getJavaClass();
                    this.typeFactory.addEmbeddableType(cl);
                    entityType = this.createEntityType(cl, new HashMap());
                    this.addProperties(cl, entityType);
                }
                this.addSupertypeFields(entityType, superTypes, handled);
                supertype.setEntityType(entityType);
                model.include(supertype);
            }
        }
    }

    private boolean containsAny(Class<?> clazz, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annType : annotations) {
            if (!clazz.isAnnotationPresent(annType)) continue;
            return true;
        }
        return false;
    }

    private EntityType createEntityType(Class<?> cl, Map<Class<?>, EntityType> types) {
        if (types.get(cl) != null) {
            return types.get(cl);
        }
        EntityType type = this.allTypes.get(ClassUtils.getFullName(cl));
        if (type == null) {
            type = this.typeFactory.getEntityType(cl);
        }
        types.put(cl, type);
        String fullName = ClassUtils.getFullName(cl);
        if (!this.allTypes.containsKey(fullName)) {
            this.allTypes.put(fullName, type);
        }
        this.typeMappings.register(type, this.queryTypeFactory.create(type));
        if (this.strictMode && cl.getSuperclass() != null) {
            Class[] annotations = new Class[]{this.entityAnnotation, this.supertypeAnnotation, this.embeddableAnnotation};
            if (!this.containsAny(cl.getSuperclass(), annotations)) {
                return type;
            }
        }
        if (cl.getSuperclass() != null && !this.stopClasses.contains(cl.getSuperclass()) && !cl.getSuperclass().isAnnotationPresent(QueryExclude.class)) {
            type.addSupertype(new Supertype(this.typeFactory.get(cl.getSuperclass(), cl.getGenericSuperclass())));
        }
        if (cl.isInterface()) {
            for (Class<?> iface : cl.getInterfaces()) {
                if (this.stopClasses.contains(iface) || iface.isAnnotationPresent(QueryExclude.class)) continue;
                type.addSupertype(new Supertype(this.typeFactory.get(iface)));
            }
        }
        return type;
    }

    private void addConstructors(Class<?> cl, EntityType type) {
        for (java.lang.reflect.Constructor<?> constructor : cl.getConstructors()) {
            if (!constructor.isAnnotationPresent(QueryProjection.class)) continue;
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                Type parameterType = this.typeFactory.get(constructor.getParameterTypes()[i], constructor.getGenericParameterTypes()[i]);
                for (Annotation annotation : constructor.getParameterAnnotations()[i]) {
                    if (!annotation.annotationType().equals(QueryType.class)) continue;
                    QueryType queryType = (QueryType)annotation;
                    parameterType = parameterType.as(TypeCategory.valueOf(queryType.value().name()));
                }
                parameters.add(new Parameter("param" + i, parameterType));
            }
            type.addConstructor(new Constructor(parameters));
        }
    }

    private void addProperties(Class<?> cl, EntityType type) {
        HashMap<String, Type> types = new HashMap<String, Type>();
        HashMap<String, Annotations> annotations = new HashMap<String, Annotations>();
        PropertyHandling.Config config = this.propertyHandling.getConfig(cl);
        if (config.isFields()) {
            for (Field field : cl.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) && !field.isAnnotationPresent(QueryType.class)) continue;
                AnnotatedElement annotated = ReflectionUtils.getAnnotatedElement(cl, field.getName(), field.getType());
                Type propertyType = this.getPropertyType(cl, annotated, field.getType(), field.getGenericType());
                Annotations ann = new Annotations(field);
                types.put(field.getName(), propertyType);
                annotations.put(field.getName(), ann);
            }
        }
        if (config.isMethods()) {
            for (Method method : cl.getDeclaredMethods()) {
                Annotations ann;
                String name = method.getName();
                if (method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.isBridge() || (!name.startsWith("get") || name.length() <= 3) && (!name.startsWith("is") || name.length() <= 2)) continue;
                String propertyName = name.startsWith("get") ? BeanUtils.uncapitalize(name.substring(3)) : BeanUtils.uncapitalize(name.substring(2));
                Type propertyType = this.getPropertyType(cl, method, method.getReturnType(), method.getGenericReturnType());
                if (!types.containsKey(propertyName) || !this.useFieldTypes) {
                    types.put(propertyName, propertyType);
                }
                if ((ann = (Annotations)annotations.get(propertyName)) == null) {
                    ann = new Annotations(new AnnotatedElement[0]);
                    annotations.put(propertyName, ann);
                }
                ann.addAnnotations(method);
            }
        }
        for (Map.Entry entry : types.entrySet()) {
            Annotations ann = (Annotations)annotations.get(entry.getKey());
            Property property = this.createProperty(type, (String)entry.getKey(), (Type)entry.getValue(), ann);
            if (property == null) continue;
            type.addProperty(property);
        }
    }

    private Type getPropertyType(Class<?> cl, AnnotatedElement annotated, Class<?> type, java.lang.reflect.Type genericType) {
        String fullName;
        Type propertyType = null;
        if (annotated.isAnnotationPresent(this.embeddedAnnotation)) {
            Class<?> embeddableType = type;
            if (Collection.class.isAssignableFrom(type)) {
                embeddableType = ReflectionUtils.getTypeParameterAsClass(genericType, 0);
            } else if (Map.class.isAssignableFrom(type)) {
                embeddableType = ReflectionUtils.getTypeParameterAsClass(genericType, 1);
            }
            if (!embeddableType.getName().startsWith("java.")) {
                this.typeFactory.addEmbeddableType(embeddableType);
                if (!(this.embeddableTypes.containsKey(embeddableType) || this.entityTypes.containsKey(embeddableType) || this.superTypes.containsKey(embeddableType))) {
                    EntityType entityType = this.createEntityType(embeddableType, this.embeddableTypes);
                    this.addProperties(embeddableType, entityType);
                    if (embeddableType == type) {
                        propertyType = entityType;
                    }
                }
            }
        }
        if (propertyType == null && (propertyType = this.typeFactory.get(type, annotated, genericType)) instanceof EntityType && !this.allTypes.containsKey(ClassUtils.getFullName(type)) && !this.allTypes.containsKey(fullName = ClassUtils.getFullName(type))) {
            this.allTypes.put(fullName, (EntityType)propertyType);
        }
        return propertyType;
    }

    @Nullable
    private Property createProperty(EntityType entityType, String propertyName, Type propertyType, AnnotatedElement annotated) {
        List<String> inits = Collections.emptyList();
        if (annotated.isAnnotationPresent(this.skipAnnotation) && !annotated.isAnnotationPresent(QueryType.class)) {
            return null;
        }
        if (annotated.isAnnotationPresent(QueryInit.class)) {
            inits = Arrays.asList(annotated.getAnnotation(QueryInit.class).value());
        }
        if (annotated.isAnnotationPresent(QueryType.class)) {
            QueryType queryType = annotated.getAnnotation(QueryType.class);
            if (queryType.value().equals((Object)PropertyType.NONE)) {
                return null;
            }
            propertyType = propertyType.as(TypeCategory.valueOf(queryType.value().name()));
        }
        return new Property(entityType, propertyName, propertyType, inits);
    }

    private void scanPackages(String ... packages) {
        if (packages == null) {
            return;
        }
        for (String pkg : packages) {
            try {
                for (Class<?> cl : ClassPathUtils.scanPackage(this.classLoader, pkg)) {
                    this.handleClass(cl);
                }
            }
            catch (IOException e) {
                throw new QueryException(e);
            }
        }
    }

    private void handleClass(Class<?> cl) {
        if (this.stopClasses.contains(cl) || cl.isAnnotationPresent(QueryExclude.class)) {
            return;
        }
        if (cl.isAnnotationPresent(this.entityAnnotation)) {
            this.entityTypes.put(cl, null);
        } else if (cl.isAnnotationPresent(this.embeddableAnnotation)) {
            this.embeddableTypes.put(cl, null);
        } else if (cl.isAnnotationPresent(this.supertypeAnnotation)) {
            this.superTypes.put(cl, null);
        } else {
            for (java.lang.reflect.Constructor<?> constructor : cl.getConstructors()) {
                if (!constructor.isAnnotationPresent(QueryProjection.class)) continue;
                this.projectionTypes.put(cl, null);
                break;
            }
        }
    }

    private void serialize(Serializer serializer, Map<Class<?>, EntityType> types) throws IOException {
        for (Map.Entry<Class<?>, EntityType> entityType : types.entrySet()) {
            Type type = this.typeMappings.getPathType(entityType.getValue(), entityType.getValue(), true);
            String packageName = type.getPackageName();
            String className = packageName.length() > 0 ? packageName + "." + type.getSimpleName() : type.getSimpleName();
            SerializerConfig config = this.serializerConfig;
            if (entityType.getKey().isAnnotationPresent(Config.class)) {
                config = SimpleSerializerConfig.getConfig(entityType.getKey().getAnnotation(Config.class));
            }
            String fileSuffix = this.createScalaSources ? ".scala" : ".java";
            this.write(serializer, className.replace('.', '/') + fileSuffix, config, entityType.getValue());
        }
    }

    private void write(Serializer serializer, String path, SerializerConfig serializerConfig, EntityType type) throws IOException {
        File targetFile = new File(this.targetFolder, path);
        this.generatedFiles.add(targetFile);
        try (Writer w = this.writerFor(targetFile);){
            AbstractCodeWriter writer = this.createScalaSources ? new ScalaWriter(w) : new JavaWriter(w);
            serializer.serialize(type, serializerConfig, writer);
        }
    }

    private Writer writerFor(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            System.err.println("Folder " + file.getParent() + " could not be created");
        }
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Set<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public void setEntityAnnotation(Class<? extends Annotation> entityAnnotation) {
        this.entityAnnotation = entityAnnotation;
    }

    public void setSupertypeAnnotation(Class<? extends Annotation> supertypeAnnotation) {
        this.supertypeAnnotation = supertypeAnnotation;
    }

    public void setEmbeddableAnnotation(Class<? extends Annotation> embeddableAnnotation) {
        this.embeddableAnnotation = embeddableAnnotation;
    }

    public void setEmbeddedAnnotation(Class<? extends Annotation> embeddedAnnotation) {
        this.embeddedAnnotation = embeddedAnnotation;
    }

    public void setSkipAnnotation(Class<? extends Annotation> skipAnnotation) {
        this.skipAnnotation = skipAnnotation;
    }

    public void setTargetFolder(File targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setSerializerClass(Class<? extends Serializer> serializerClass) {
        this.codegenModule.bind(serializerClass);
        this.serializerClass = serializerClass;
    }

    public void setTypeMappingsClass(Class<? extends TypeMappings> typeMappingsClass) {
        this.codegenModule.bind(TypeMappings.class, typeMappingsClass);
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public void setKeywords(Collection<String> keywords) {
        this.codegenModule.bind("keywords", keywords);
    }

    public void setNamePrefix(String prefix) {
        this.codegenModule.bind("prefix", prefix);
    }

    public void setNameSuffix(String suffix) {
        this.codegenModule.bind("suffix", suffix);
    }

    public void setPackageSuffix(String suffix) {
        this.codegenModule.bind("packageSuffix", suffix);
    }

    @Deprecated
    public void setHandleFields(boolean b) {
        this.handleFields = b;
        this.setPropertyHandling();
    }

    @Deprecated
    public void setHandleMethods(boolean b) {
        this.handleMethods = b;
        this.setPropertyHandling();
    }

    private void setPropertyHandling() {
        this.propertyHandling = this.handleFields ? (this.handleMethods ? PropertyHandling.ALL : PropertyHandling.FIELDS) : (this.handleMethods ? PropertyHandling.METHODS : PropertyHandling.NONE);
    }

    public void setPropertyHandling(PropertyHandling propertyHandling) {
        this.propertyHandling = propertyHandling;
    }

    public void setUseFieldTypes(boolean b) {
        this.useFieldTypes = b;
    }

    public void addStopClass(Class<?> cl) {
        this.stopClasses.add(cl);
    }

    public void setStrictMode(boolean s) {
        this.strictMode = s;
    }

    public void setSerializerConfig(SerializerConfig serializerConfig) {
        this.serializerConfig = serializerConfig;
    }

    public void addAnnotationHelper(AnnotationHelper annotationHelper) {
        this.annotationHelpers.add(annotationHelper);
    }

    public void setGeneratedAnnotationClass(@Nullable String generatedAnnotationClass) {
        this.codegenModule.bindInstance("generatedAnnotationClass", GeneratedAnnotationResolver.resolve(generatedAnnotationClass));
    }
}

