/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.TypeResolver;
import com.querydsl.codegen.utils.model.Type;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.SourceVersion;

public final class Property
implements Comparable<Property> {
    private final EntityType declaringType;
    private final boolean inherited;
    private final List<String> inits;
    private final String name;
    private final String escapedName;
    private final Map<Class<?>, Annotation> annotations = new HashMap();
    private final Map<Object, Object> data = new HashMap<Object, Object>();
    private final Type type;

    public Property(EntityType declaringType, String name, Type type) {
        this(declaringType, name, type, Collections.emptyList(), false);
    }

    public Property(EntityType declaringType, String name, Type type, List<String> inits) {
        this(declaringType, name, type, inits, false);
    }

    public Property(EntityType declaringType, String name, Type type, List<String> inits, boolean inherited) {
        this(declaringType, name, Property.escapeName(name), type, inits, inherited);
    }

    public Property(EntityType declaringType, String name, String escapedName, Type type, List<String> inits, boolean inherited) {
        this.declaringType = declaringType;
        this.name = name;
        this.escapedName = escapedName;
        this.type = type;
        this.inits = inits;
        this.inherited = inherited;
    }

    private static String escapeName(String name) {
        if (SourceVersion.isKeyword((CharSequence)name)) {
            name = (String)name + "$";
        } else if (!Character.isJavaIdentifierStart(((String)name).charAt(0))) {
            name = "_" + (String)name;
        }
        return name;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.put(annotation.annotationType(), annotation);
    }

    @Override
    public int compareTo(Property o) {
        int rv = this.name.compareToIgnoreCase(o.getName());
        if (rv == 0) {
            return this.name.compareTo(o.getName());
        }
        return rv;
    }

    public Property createCopy(EntityType targetModel) {
        if (!this.declaringType.getParameters().isEmpty()) {
            Type newType = TypeResolver.resolve(this.type, this.declaringType, targetModel);
            if (!newType.equals(this.type) || !newType.getClass().equals(this.type.getClass())) {
                return new Property(targetModel, this.name, newType, this.inits, false);
            }
            return new Property(targetModel, this.name, this.type, this.inits, targetModel.getSuperType() != null);
        }
        return new Property(targetModel, this.name, this.type, this.inits, targetModel.getSuperType() != null);
    }

    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return (T)this.annotations.get(type);
    }

    public Collection<Annotation> getAnnotations() {
        return Collections.unmodifiableCollection(this.annotations.values());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Property) {
            Property p = (Property)o;
            return p.name.equals(this.name) && p.type.equals(this.type);
        }
        return false;
    }

    public EntityType getDeclaringType() {
        return this.declaringType;
    }

    public String getEscapedName() {
        return this.escapedName;
    }

    public List<String> getInits() {
        return this.inits;
    }

    public String getName() {
        return this.name;
    }

    public Type getParameter(int i) {
        return this.type.getParameters().get(i);
    }

    public Map<Object, Object> getData() {
        return this.data;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public String toString() {
        return this.declaringType.getFullName() + "." + this.name;
    }
}

