/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.codegen.utils.model.TypeExtends;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.TemplateExpression;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class TypeMappings {
    private final Map<Type, Type> genericQueryTypes = new HashMap<Type, Type>();
    private final Map<String, Type> queryTypes = new HashMap<String, Type>();
    private final Map<TypeCategory, Type> exprTypes = new EnumMap<TypeCategory, Type>(TypeCategory.class);
    private final Map<TypeCategory, Type> pathTypes = new EnumMap<TypeCategory, Type>(TypeCategory.class);
    private final Map<TypeCategory, Type> templateTypes = new EnumMap<TypeCategory, Type>(TypeCategory.class);

    public Type getTemplateType(Type type, EntityType model, boolean raw) {
        return this.getTemplateType(type, model, raw, false, false);
    }

    public Type getTemplateType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        return this.getQueryType(this.templateTypes, type, model, raw, rawParameters, extend);
    }

    public Type getExprType(Type type, EntityType model, boolean raw) {
        return this.getExprType(type, model, raw, false, false);
    }

    public Type getExprType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        if (this.genericQueryTypes.containsKey(type)) {
            return this.genericQueryTypes.get(type);
        }
        if (this.queryTypes.containsKey(type.getFullName())) {
            return this.queryTypes.get(type.getFullName());
        }
        return this.getQueryType(this.exprTypes, type, model, raw, rawParameters, extend);
    }

    public Type getPathType(Type type, EntityType model, boolean raw) {
        return this.getPathType(type, model, raw, false, false);
    }

    public Type getPathType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        if (this.genericQueryTypes.containsKey(type)) {
            return this.genericQueryTypes.get(type);
        }
        if (this.queryTypes.containsKey(type.getFullName())) {
            return this.queryTypes.get(type.getFullName());
        }
        return this.getQueryType(this.pathTypes, type, model, raw, rawParameters, extend);
    }

    private Type getQueryType(Map<TypeCategory, Type> types, Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        Type exprType = types.get((Object)type.getCategory());
        return this.getQueryType(type, model, exprType, raw, rawParameters, extend);
    }

    public Type getQueryType(Type type, EntityType model, Type exprType, boolean raw, boolean rawParameters, boolean extend) {
        TypeCategory category = type.getCategory();
        if (raw && category != TypeCategory.ENTITY && category != TypeCategory.CUSTOM) {
            return exprType;
        }
        if (category == TypeCategory.STRING || category == TypeCategory.BOOLEAN) {
            return exprType;
        }
        if (rawParameters) {
            type = new SimpleType(type, new Type[0]);
        }
        if (!type.isFinal() && extend) {
            type = new TypeExtends(type);
        }
        return new SimpleType(exprType, type);
    }

    public void register(TypeCategory category, @Nullable Class<? extends Expression> expr, @Nullable Class<? extends Path> path, @Nullable Class<? extends TemplateExpression> template) {
        if (expr != null) {
            this.exprTypes.put(category, new ClassType(expr, new Type[0]));
        }
        if (path != null) {
            this.pathTypes.put(category, new ClassType(path, new Type[0]));
        }
        if (template != null) {
            this.templateTypes.put(category, new ClassType(template, new Type[0]));
        }
    }

    public void register(Type type, Type queryType) {
        this.queryTypes.put(type.getFullName(), queryType);
        this.genericQueryTypes.put(type, queryType);
    }

    public boolean isRegistered(Type type) {
        return this.queryTypes.containsKey(type.getFullName());
    }
}

