/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.BeanSerializer;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.model.Parameter;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.sql.Column;
import com.querydsl.sql.codegen.support.PrimaryKeyData;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;

public class ExtendedBeanSerializer
extends BeanSerializer {
    private static final Parameter o = new Parameter("o", Types.OBJECT);

    public ExtendedBeanSerializer() {
    }

    @Inject
    public ExtendedBeanSerializer(@Named(value="javadocSuffix") String javadocSuffix, @Named(value="generatedAnnotationClass") Class<? extends Annotation> generatedAnnotationClass) {
        super(javadocSuffix, generatedAnnotationClass);
    }

    @Override
    protected void bodyEnd(EntityType model, CodeWriter writer) throws IOException {
        Collection primaryKeys = (Collection)model.getData().get(PrimaryKeyData.class);
        if (primaryKeys == null || primaryKeys.isEmpty()) {
            return;
        }
        HashMap<String, Property> columnToProperty = new HashMap<String, Property>();
        for (Property property : model.getProperties()) {
            columnToProperty.put(property.getAnnotation(Column.class).value(), property);
        }
        StringBuilder anyColumnIsNull = new StringBuilder();
        StringBuilder columnEquals = new StringBuilder();
        ArrayList<String> properties = new ArrayList<String>();
        for (PrimaryKeyData pk : primaryKeys) {
            for (String column : pk.getColumns()) {
                Property property = (Property)columnToProperty.get(column);
                String propName = property.getEscapedName();
                if (anyColumnIsNull.length() > 0) {
                    anyColumnIsNull.append(" || ");
                    columnEquals.append(" && ");
                }
                anyColumnIsNull.append(propName).append(" == null");
                columnEquals.append(propName).append(".equals(obj.").append(propName).append(")");
                properties.add(propName);
            }
        }
        writer.annotation(Override.class);
        writer.beginPublicMethod((Type)Types.BOOLEAN_P, "equals", o);
        writer.line("if (", anyColumnIsNull + ") {");
        writer.line("    return super.equals(o);");
        writer.line("}");
        writer.line("if (!(o instanceof ", model.getSimpleName(), ")) {");
        writer.line("    return false;");
        writer.line("}");
        writer.line(model.getSimpleName(), " obj = (", model.getSimpleName(), ") o;");
        writer.line("return ", columnEquals + ";");
        writer.end();
        writer.annotation(Override.class);
        writer.beginPublicMethod((Type)Types.INT, "hashCode", new Parameter[0]);
        writer.line("if (", anyColumnIsNull + ") {");
        writer.line("    return super.hashCode();");
        writer.line("}");
        writer.line("final int prime = 31;");
        writer.line("int result = 1;");
        for (String property : properties) {
            writer.line("result = prime * result + ", property, ".hashCode();");
        }
        writer.line("return result;");
        writer.end();
    }

    @Override
    protected void addToString(EntityType model, CodeWriter writer) throws IOException {
        Collection primaryKeys = (Collection)model.getData().get(PrimaryKeyData.class);
        if (primaryKeys == null || primaryKeys.isEmpty()) {
            super.addToString(model, writer);
            return;
        }
        StringBuilder toString = new StringBuilder();
        HashMap<String, Property> columnToProperty = new HashMap<String, Property>();
        for (Property property : model.getProperties()) {
            columnToProperty.put(property.getAnnotation(Column.class).value(), property);
        }
        for (PrimaryKeyData pk : primaryKeys) {
            for (String column : pk.getColumns()) {
                Property property = (Property)columnToProperty.get(column);
                String propName = property.getEscapedName();
                if (toString.length() > 0) {
                    toString.append("+ \";\" + ");
                } else {
                    toString.append("\"" + model.getSimpleName() + "#\" + ");
                }
                toString.append(propName);
            }
        }
        writer.annotation(Override.class);
        writer.beginPublicMethod((Type)Types.STRING, "toString", new Parameter[0]);
        writer.line("return ", toString + ";");
        writer.end();
    }
}

