/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.formeln;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.formeln.IHabitateZone;
import de.planetensuche.datamodel.formeln.Konstanten;

public final class HabitateZoneSimpleStarMass
extends Konstanten
implements IHabitateZone {
    private double innereCHZ;
    private double aeussereCHZ;

    public void berechne(double d) {
        double d2 = d / 1.0;
        this.innereCHZ = d < 1.1 ? 0.958 * Math.pow(d2, 2.61) : 0.927 * Math.pow(d2, 3.05);
        this.aeussereCHZ = 1.004 * Math.pow(d2, 2.87);
        if (this.innereCHZ > this.aeussereCHZ) {
            this.innereCHZ = 0.0;
            this.aeussereCHZ = 0.0;
        }
    }

    @Override
    public boolean berechne(IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (iPlanetensucheObjekt.isMasseUnbekannt()) {
            return false;
        }
        this.berechne(iPlanetensucheObjekt.getMasse());
        return this.innereCHZ > 0.0 && this.aeussereCHZ > 0.0;
    }

    @Override
    public double getAeussereHZ() {
        return this.aeussereCHZ;
    }

    @Override
    public double getInnereHZ() {
        return this.innereCHZ;
    }
}

