/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.impl;

import de.planetensuche.datamodel.api.ISternbild;
import java.util.ArrayList;
import java.util.List;

public final class Sternbild
implements ISternbild {
    private Integer id;
    private String dtbezeichnung;
    private String engbezeichnung;
    private String latbezeichnung;
    private String sternbildCode;
    private String latgenitiv;
    private double vonRA = 0.0;
    private double bisRA = 0.0;
    private double vonDECL = 0.0;
    private double bisDECL = 0.0;
    private List<String> bilder;
    private List<String> objekteImSternbild;

    @Override
    public void setSternbildDTBezeichnung(String string) {
        this.dtbezeichnung = string;
    }

    @Override
    public String getSternbildDTBezeichnung() {
        if (this.dtbezeichnung == null) {
            return "unbekannt";
        }
        return this.dtbezeichnung;
    }

    @Override
    public void setSternbildENGBezeichnung(String string) {
        this.engbezeichnung = string;
    }

    @Override
    public String getSternbildENGBezeichnung() {
        if (this.engbezeichnung == null) {
            return "unknown";
        }
        return this.engbezeichnung;
    }

    @Override
    public void setSternbildLATBezeichnung(String string) {
        this.latbezeichnung = string;
    }

    @Override
    public String getSternbildLATBezeichnung() {
        if (this.latbezeichnung == null) {
            return "unbekannt";
        }
        return this.latbezeichnung;
    }

    @Override
    public void setSternbildCode(String string) {
        if (string.length() != 3) {
            throw new IllegalArgumentException("Sternbild-Abkuertzung '" + string + "' ist falsch!");
        }
        this.sternbildCode = string;
    }

    @Override
    public String getSternbildCode() {
        if (this.sternbildCode == null) {
            return "";
        }
        return this.sternbildCode;
    }

    @Override
    public void setSternbildGenitiv(String string) {
        this.latgenitiv = string;
    }

    @Override
    public String getSternbildGenitiv() {
        return this.latgenitiv;
    }

    @Override
    public void setObjekteImSternbild(List<String> list) {
        this.objekteImSternbild = list;
    }

    @Override
    public List<String> getObjekteImSternbild() {
        if (this.objekteImSternbild == null) {
            return new ArrayList<String>();
        }
        return this.objekteImSternbild;
    }

    @Override
    public List<String> getObjekteImSternbild(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.objekteImSternbild == null) {
            return arrayList;
        }
        int n2 = n;
        if (n2 == 0) {
            n2 = 400;
        }
        n2 /= 5;
        Object object = "";
        for (int i = 0; i < this.objekteImSternbild.size(); ++i) {
            if (((String)object).length() >= n2) {
                arrayList.add((String)object);
                object = "";
            }
            object = (String)object + this.objekteImSternbild.get(i);
            if (i >= this.objekteImSternbild.size() - 1) continue;
            object = (String)object + ", ";
        }
        arrayList.add((String)object);
        return arrayList;
    }

    @Override
    public void setSternbildVonRA(double d) {
        if (d >= 0.0 && d < 24.0) {
            this.vonRA = d;
        }
    }

    @Override
    public double getSternbildVonRA() {
        return this.vonRA;
    }

    @Override
    public void setSternbildBisRA(double d) {
        if (d >= 0.0 && d < 24.0) {
            this.bisRA = d;
        }
    }

    @Override
    public double getSternbildBisRA() {
        return this.bisRA;
    }

    @Override
    public void setSternbildVonDECL(double d) {
        if (d > -90.0 && d < 90.0) {
            this.vonDECL = d;
        }
    }

    @Override
    public double getSternbildVonDECL() {
        return this.vonDECL;
    }

    @Override
    public void setSternbildBisDECL(double d) {
        if (d > -90.0 && d < 90.0) {
            this.bisDECL = d;
        }
    }

    @Override
    public double getSternbildBisDECL() {
        return this.bisDECL;
    }

    @Override
    public void setBilder(List<String> list) {
        this.bilder = list;
    }

    @Override
    public List<String> getBilder() {
        if (this.bilder == null) {
            return new ArrayList<String>();
        }
        return this.bilder;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer n) {
        this.id = n;
    }
}

