/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.dateihelfer;

import de.planetensuche.core.JavaVersionHelperUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ScriptWriter {
    public void writeScripts(int n, String string) throws IOException {
        File file;
        File file2 = new File("linux-aarch64-start.sh");
        if (file2.exists() && file2.canWrite()) {
            file2.delete();
        }
        if ((file = new File("linux-aarch64-schema.sh")).exists() && file.canWrite()) {
            file.delete();
        }
        String string2 = "java -Xms256m -Xmx" + n + "m -XX:+UseStringDeduplication -jar planetensuche.jar";
        if (JavaVersionHelperUtil.isLocalJreAvailable()) {
            this.writeRunScriptsWithCommand(List.of("windows-start.bat"), JavaVersionHelperUtil.getWinJrePath() + string2);
            this.writeRunScriptsWithCommand(List.of("linux-start.sh"), JavaVersionHelperUtil.getLinuxJrePath() + string2);
            this.writeRunScriptsWithCommand(List.of("mac-start.sh"), JavaVersionHelperUtil.getMacOsJrePath() + string2);
            this.writeRunScriptsWithCommand(List.of("windows-schema.bat"), JavaVersionHelperUtil.getWinJrePath() + string2 + " -s");
            this.writeRunScriptsWithCommand(List.of("linux-schema.sh"), JavaVersionHelperUtil.getLinuxJrePath() + string2 + " -s");
            this.writeRunScriptsWithCommand(List.of("mac-schema.sh"), JavaVersionHelperUtil.getMacOsJrePath() + string2 + " -s");
        } else {
            List<String> list = List.of("windows-start.bat", "linux-start.sh", "mac-start.sh");
            this.writeRunScriptsWithCommand(list, string2);
            list = List.of("windows-schema.bat", "linux-schema.sh", "mac-schema.sh");
            string2 = string2 + " -s";
            this.writeRunScriptsWithCommand(list, string2);
        }
        if (string != null) {
            this.writeUpdateScripts(n, string);
        }
    }

    public void writeUpdateScripts(int n, String string) throws IOException {
        File file = new File("linux-aarch64-update.sh");
        if (file.exists() && file.canWrite()) {
            file.delete();
        }
        String string2 = "java -Xms256m -Xmx" + n + "m -XX:+UseStringDeduplication -jar updater.jar " + string;
        if (JavaVersionHelperUtil.isLocalJreAvailable()) {
            this.writeRunScriptsWithCommand(Arrays.asList("windows-update.bat"), JavaVersionHelperUtil.getWinJrePath() + string2);
            this.writeRunScriptsWithCommand(Arrays.asList("linux-update.sh"), JavaVersionHelperUtil.getLinuxJrePath() + string2);
            this.writeRunScriptsWithCommand(Arrays.asList("mac-update.sh"), JavaVersionHelperUtil.getMacOsJrePath() + string2);
        } else {
            List<String> list = List.of("windows-update.bat", "linux-update.sh", "mac-update.sh");
            this.writeRunScriptsWithCommand(list, string2);
        }
    }

    private void writeRunScriptsWithCommand(List<String> list, String string) throws IOException {
        for (String string2 : list) {
            try {
                File file = new File(string2);
                file.setWritable(true, false);
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2, false));){
                    bufferedWriter.write(string);
                    if (string2.endsWith(".sh")) {
                        bufferedWriter.write("\n");
                    } else {
                        bufferedWriter.write("\r\n");
                    }
                }
                if (file.setExecutable(true, false)) continue;
                file.setExecutable(true, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("file '" + string2 + "' needs to be updated but is not writable!");
                this.writeRunScriptsWithCommand(List.of(string2.replace(".", "2.")), string);
            }
        }
    }
}

