/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import com.google.inject.Injector;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datamodel.impl.ILeuchtkraftklassenService;
import de.planetensuche.datenbank.DatenbankZeigeObjekt;
import de.planetensuche.datenbank.ObjectNamesFinderService;
import de.planetensuche.datenbank.PlanetTypeDetectorService;
import de.planetensuche.datenbank.dbmodel.api.IBerechnungDurchschnittDAO;
import de.planetensuche.datenbank.dbmodel.notizen.api.INotizenService;
import de.planetensuche.datenbank.reorganisieren.Aufraeumthread;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IHabitableZoneRepository;
import de.planetensuche.datenbankkern.api.repos.IObjekttypenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;

public class BackgroundServiceFactory {
    private final Injector injector;

    public BackgroundServiceFactory(Injector injector) {
        this.injector = injector;
    }

    public Aufraeumthread createAufraeumthread(boolean bl) {
        return new Aufraeumthread(bl, false, this.injector.getInstance(IDatenbankverbinder.class));
    }

    public ObjectNamesFinderService createObjectNamesFinder() {
        return new ObjectNamesFinderService(this.injector);
    }

    public DatenbankZeigeObjekt createShowObjectHelper(KoordinatenFormat koordinatenFormat, SternbildSprache sternbildSprache) {
        return new DatenbankZeigeObjekt(SprachcontainerFabrik.getI18nContainer(), koordinatenFormat, sternbildSprache, this.injector.getInstance(IBerechnungDurchschnittDAO.class), this.injector.getInstance(INotizenService.class), this.injector.getInstance(IObjekttypenRepository.class), this.injector.getInstance(ILeuchtkraftklassenService.class), this.injector.getInstance(IDatenbankService.class), this.injector.getInstance(IPlanetensucheObjektRepository.class), this.injector.getInstance(IHabitableZoneRepository.class), this.injector.getInstance(PlanetTypeDetectorService.class), this.injector.getInstance(ISternbilderRepository.class));
    }
}

