/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ISternbild;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datamodel.impl.SternbildFinder;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import java.io.IOException;
import java.sql.SQLException;

public class ConstellationForObjectService {
    private final SternbildSprache constellationLanguage;
    private final IPlanetensucheObjektRepository planetensucheRepo;
    private final ISternbilderRepository constellationRepo;

    public ConstellationForObjectService(SternbildSprache sternbildSprache, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, ISternbilderRepository iSternbilderRepository) {
        this.constellationLanguage = sternbildSprache;
        this.planetensucheRepo = iPlanetensucheObjektRepository;
        this.constellationRepo = iSternbilderRepository;
    }

    String getSternbildbezeichnung(IPlanetensucheObjekt iPlanetensucheObjekt) throws IOException, SQLException {
        Object object;
        IPlanetensucheObjekt iPlanetensucheObjekt2 = iPlanetensucheObjekt;
        if (iPlanetensucheObjekt.isSternbildUnbekannt() && iPlanetensucheObjekt.isKoordinatenUnbekannt() && Check.isFilled(iPlanetensucheObjekt.getUmkreistObjekt())) {
            iPlanetensucheObjekt2 = this.planetensucheRepo.read(iPlanetensucheObjekt.getUmkreistObjekt());
        }
        if (iPlanetensucheObjekt2.isSternbildUnbekannt() && !iPlanetensucheObjekt2.isKoordinatenUnbekannt()) {
            object = this.getSternbildVonKoordinaten(iPlanetensucheObjekt2.getRA(), iPlanetensucheObjekt2.getDECL());
            iPlanetensucheObjekt2.setSternbildCode(object.getSternbildCode());
            iPlanetensucheObjekt2.setSternbildDTBezeichnung(object.getSternbildDTBezeichnung());
            iPlanetensucheObjekt2.setSternbildENGBezeichnung(object.getSternbildENGBezeichnung());
            iPlanetensucheObjekt2.setSternbildLATBezeichnung(object.getSternbildLATBezeichnung());
        }
        if (null == this.constellationLanguage) {
            object = iPlanetensucheObjekt2.getSternbildLATBezeichnung();
        } else {
            object = switch (this.constellationLanguage) {
                case SternbildSprache.DEUTSCH -> iPlanetensucheObjekt2.getSternbildDTBezeichnung();
                case SternbildSprache.ENGLISCH -> iPlanetensucheObjekt2.getSternbildENGBezeichnung();
                case SternbildSprache.LATEINISCH_ABK -> iPlanetensucheObjekt2.getSternbildCode();
                default -> iPlanetensucheObjekt2.getSternbildLATBezeichnung();
            };
        }
        return object;
    }

    ISternbild getSternbildVonKoordinaten(double d, double d2) throws IOException, SQLException {
        SternbildFinder sternbildFinder = new SternbildFinder();
        String string = sternbildFinder.getSternbildCodeFuerKoordinate(d, d2);
        if (string == null) {
            throw new IllegalArgumentException("could not found the constellation for RA " + d + " and DECL " + d2);
        }
        ISternbild iSternbild = this.constellationRepo.getSternbildOnlyBasicData(string);
        if (iSternbild == null) {
            throw new IllegalStateException("could not load data for constellation code '" + string + "'");
        }
        return iSternbild;
    }
}

