/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ISternbild;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.DatenbankDialogKontextmenu;
import de.planetensuche.datenbank.DatenbankZeigeObjekt;
import de.planetensuche.datenbank.DoubleStarDetectorService;
import de.planetensuche.datenbank.KatalogService;
import de.planetensuche.datenbank.Lesenthread;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.flickr.FlickrPictureDataSource;
import de.planetensuche.datenbank.voting.VotingCategoryMouseListener;
import de.planetensuche.datenbank.voting.VotingPictureMouseListener;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.JComboBoxExtended;
import de.planetensuche.guidesigner.components.LocalPicturesDataSource;
import de.planetensuche.guidesigner.components.PictureViewer;
import de.planetensuche.guidesigner.components.PictureViewerDataSource;
import de.planetensuche.guidesigner.components.search.JComboBoxWithSearch;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public final class DatenbankDialog
extends Basisdialog {
    private final KonfigurationDTO globalConfig;
    private final ParameterDto parameter;
    private final DatenbankZeigeObjekt datenbankZeigeObjekt;
    private final DatenbankDialogKontextmenu kontextmenu;
    private PictureViewer pictureViewer;
    private final DoubleStarDetectorService datenbankHelfer;
    private boolean semaphorLooked;
    private boolean zeigeStatusfensterBeimObjektLaden;
    private String letztesObjekt;
    private IPlanetensucheObjekt aktuellAngezeigtesObjekt;
    private final IObjektnamenRepository objektnamenRepository;
    private final InjectionDto injectionDto;
    private VotingCategoryMouseListener votingMouseListner;
    private VotingPictureMouseListener votingPictureListener;
    private JMenuItem alphabet;
    private JMenuItem bildDruckenMenu;
    private JCheckBox exakteSucheChooser;
    private JButton filterButton;
    private JMenuItem info;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem9;
    private JMenuItem jMenuItemEsi;
    private JMenuItem jMenuPhtScan;
    private JMenuItem jMenuPlanetenTyp;
    private JMenuItem jMenuPrediction;
    private JMenuItem jMenuSternRadiusMasse;
    private JMenuItem jMenueGaiaStellar;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JMenuItem jmenuPlanetennamen;
    private JMenuItem jmenueAufraeumen;
    private JMenuItem jmenueDoubleStarCheck;
    private JMenuItem jmenueEingabeformular;
    private JMenuItem jmenueEntdecker;
    private JMenuItem jmenueEntdeckungsmethode;
    private JMenuItem jmenueExportieren;
    private JMenuItem jmenueFilter;
    private JMenuItem jmenueGalaxiennamen;
    private JMenuItem jmenueHistorie;
    private JMenuItem jmenueImportieren;
    private JMenuItem jmenueKataloge;
    private JMenuItem jmenueKoords;
    private JMenuItem jmenueLeuchtkraftklasse;
    private JMenuItem jmenueOnlineUpdate;
    private JMenuItem jmenueOnlineUpdateKandidaten;
    private JMenuItem jmenueRekorde;
    private JMenuItem jmenueReparatur;
    private JMenuItem jmenueSternbild;
    private JMenuItem jmenueSternnamen;
    private JCheckBox katalogeAnzeigen;
    private JComboBoxExtended kategorieCombobox;
    private JMenuItem lexi;
    private JMenuItem morehelp;
    private JMenuItem nebelklassen;
    private JTextArea objektbeschreibungTextArea;
    private JComboBox objekteCombobox;
    private JMenuItem spektraltypenue;
    private JButton suchenButton;
    private JComboBoxWithSearch suchenTextfeld;
    private JComboBox suchoptionenComboBox;
    private JMenuItem textDruckenMenu;

    DatenbankDialog(ParameterDto parameterDto, KonfigurationDTO konfigurationDTO, DatenbankDialogKontextmenu datenbankDialogKontextmenu, DatenbankZeigeObjekt datenbankZeigeObjekt, InjectionDto injectionDto) throws IOException {
        super(BasisdialogId.DATENBANK_HAUPTFENSTER);
        this.parameter = parameterDto;
        this.globalConfig = konfigurationDTO;
        this.kontextmenu = datenbankDialogKontextmenu;
        this.datenbankZeigeObjekt = datenbankZeigeObjekt;
        this.objektnamenRepository = injectionDto.getObjektnamenRepository();
        this.injectionDto = injectionDto;
        this.datenbankHelfer = new DoubleStarDetectorService(this.objektnamenRepository, injectionDto.getKatalogerkenner());
        this.semaphorLooked = true;
        this.zeigeStatusfensterBeimObjektLaden = true;
        this.setCursor(new Cursor(3));
        this.setExtendedState(6);
        this.initComponents();
        this.jToolBar1.setFloatable(false);
        this.jToolBar2.setFloatable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.showMessageBar(gridBagConstraints);
        this.suchenTextfeld.setSize(120, 30);
        this.suchenButton.setText(null);
        this.suchenButton.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.suchenButton.setSize(24, 24);
        this.beschrifteGui();
        for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
        }
        this.getGuiDesigner().addComponent(this.objektbeschreibungTextArea, false);
        if (this.globalConfig.isVotingActive()) {
            this.votingMouseListner = new VotingCategoryMouseListener(this.objektbeschreibungTextArea, this, this.globalConfig.getHomepageHostname(), this.globalConfig.getPort());
            this.objektbeschreibungTextArea.addMouseListener(this.votingMouseListner);
        }
        this.viewMenue();
        this.setCursor(new Cursor(0));
        this.semaphorLooked = false;
    }

    public JMenuItem getjMenueGaiaStellar() {
        return this.jMenueGaiaStellar;
    }

    public boolean isSemaphorLooked() {
        return this.semaphorLooked;
    }

    public void setSemaphorLooked(boolean bl) {
        this.semaphorLooked = bl;
    }

    public JTextArea getObjektbeschreibungTextArea() {
        return this.objektbeschreibungTextArea;
    }

    public String getLetztesObjekt() {
        return this.letztesObjekt;
    }

    public PictureViewer getPictureViewer() {
        return this.pictureViewer;
    }

    private void beschrifteGui() {
        this.objektbeschreibungTextArea.setToolTipText(this.i18n.getString("db_m447"));
        this.jMenu2.setText(this.i18n.getString("db_menu_1"));
        this.textDruckenMenu.setText(this.i18n.getString("db_menu_2"));
        this.textDruckenMenu.setIcon(IconPoolDefault.PRINT.getImageIcon());
        this.bildDruckenMenu.setText(this.i18n.getString("db_menu_3"));
        this.bildDruckenMenu.setIcon(IconPoolDefault.PRINT.getImageIcon());
        this.jMenu1.setText(this.i18n.getString("db_menu_4"));
        this.jmenueEingabeformular.setText(this.i18n.getString("db_menu_5"));
        this.jmenueEingabeformular.setIcon(IconPoolDefault.EDIT.getImageIcon());
        this.jmenueEntdecker.setText(this.i18n.getString("db_menu_6"));
        this.jmenueEntdecker.setIcon(IconPoolDefault.EDIT.getImageIcon());
        this.jmenueEntdeckungsmethode.setText(this.i18n.getString("db_gui106"));
        this.jmenueEntdeckungsmethode.setIcon(IconPoolDefault.EDIT.getImageIcon());
        this.jmenueFilter.setText(this.i18n.getString("db_menu_7"));
        this.jmenueFilter.setIcon(IconPoolDefault.PROPERTIES.getImageIcon());
        this.jmenueKoords.setText(this.i18n.getString("db_menu_8"));
        this.jmenueKoords.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.jmenueImportieren.setText(this.i18n.getString("db_menu_10"));
        this.jmenueImportieren.setIcon(IconPoolDefault.IMPORT.getImageIcon());
        this.jmenueExportieren.setText(this.i18n.getString("db_menu_11"));
        this.jmenueExportieren.setIcon(IconPoolDefault.EXPORT.getImageIcon());
        this.jmenueReparatur.setText(this.i18n.getString("db_menu_13"));
        this.jmenueReparatur.setIcon(IconPoolDefault.DELETE.getImageIcon());
        this.jmenueAufraeumen.setText(this.i18n.getString("db_menu_12"));
        this.jmenueAufraeumen.setIcon(IconPoolDefault.DELETE.getImageIcon());
        this.jmenueHistorie.setText(this.i18n.getString("db_menu_14"));
        this.jmenueHistorie.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.jmenueOnlineUpdate.setText(this.i18n.getString("db_gui119"));
        this.jmenueOnlineUpdate.setIcon(IconPoolDefault.IMPORT.getImageIcon());
        this.jmenueOnlineUpdateKandidaten.setText(this.i18n.getString("db_gui134"));
        this.jmenueOnlineUpdateKandidaten.setIcon(IconPoolDefault.IMPORT.getImageIcon());
        this.jMenu3.setText(this.i18n.getString("db_menu_15"));
        this.jmenueSternnamen.setText(this.i18n.getString("db_m153"));
        this.jmenueSternnamen.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.jMenuItem7.setText(this.i18n.getString("db_m154"));
        this.jMenuItem7.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.jmenueGalaxiennamen.setText(this.i18n.getString("db_m155"));
        this.jmenueGalaxiennamen.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.jmenuPlanetennamen.setText(this.i18n.getString("db_menu_36"));
        this.jmenuPlanetennamen.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.jMenuItem4.setText(this.i18n.getString("db_menu_16"));
        this.jMenuItem4.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.jMenuItem9.setText(this.i18n.getString("db_gui113"));
        this.jMenuItem9.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.jMenuItemEsi.setText(this.i18n.getString("db_m507"));
        this.jMenuItemEsi.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.jmenueKataloge.setText(this.i18n.getString("db_menu_17"));
        this.jmenueKataloge.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.jmenueRekorde.setText(this.i18n.getString("db_menu_18"));
        this.jmenueRekorde.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.jmenueSternbild.setText(this.i18n.getString("db_menu_9"));
        this.jmenueSternbild.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.jmenueLeuchtkraftklasse.setText(this.i18n.getString("db_fenster18"));
        this.jmenueLeuchtkraftklasse.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.jMenuSternRadiusMasse.setText(this.i18n.getString("db_gui122"));
        this.jMenuSternRadiusMasse.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.jMenuPlanetenTyp.setText(this.i18n.getString("db_gui129"));
        this.jMenuPlanetenTyp.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.jMenuPrediction.setText(this.i18n.getString("db_menu_37"));
        this.jMenuPrediction.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.jmenueDoubleStarCheck.setText(this.i18n.getString("db_gui155"));
        this.jmenueDoubleStarCheck.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.jMenueGaiaStellar.setText(this.i18n.getString("db_gui190"));
        this.jMenueGaiaStellar.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.jMenu4.setText(this.i18n.getString("db_menu_19"));
        this.alphabet.setText(this.i18n.getString("db_menu_20"));
        this.spektraltypenue.setText(this.i18n.getString("db_menu_21"));
        this.jMenuItem6.setText(this.i18n.getString("db_menu_22"));
        this.nebelklassen.setText(this.i18n.getString("db_menu_23"));
        this.lexi.setText(this.i18n.getString("db_menu_24"));
        this.info.setText(this.i18n.getString("db_menu_25"));
        this.info.setIcon(IconPoolDefault.INFO.getImageIcon());
        this.morehelp.setText(this.i18n.getString("db_menu_26"));
        this.morehelp.setIcon(IconPoolDefault.HELP.getImageIcon());
        this.jLabel1.setText(this.i18n.getString("db_gui1"));
        this.jLabel2.setText(this.i18n.getString("db_gui2"));
        this.katalogeAnzeigen.setText(this.i18n.getString("db_gui3"));
        this.filterButton.setIcon(IconPoolDefault.PROPERTIES.getImageIcon());
        this.filterButton.setText(this.i18n.getString("db_menu_7"));
        this.suchenButton.setToolTipText(this.i18n.getString("db_gui4"));
        this.exakteSucheChooser.setText(this.i18n.getString("db_gui5"));
        this.jMenuPhtScan.setText(this.i18n.getString("db_gui137"));
        this.jMenuPhtScan.setIcon(IconPoolDefault.FIND.getImageIcon());
        this.suchoptionenComboBox.addItem(this.i18n.getString("db_m142"));
        this.suchoptionenComboBox.addItem(this.i18n.getString("db_m143"));
        this.suchoptionenComboBox.addItem(this.i18n.getString("db_m144"));
        this.setTitle(this.i18n.getString("db_fenster1"));
    }

    private void createPictureViewerComponent(Collection<String> collection, Collection<String> collection2, ObjektKategorie objektKategorie) {
        PictureViewerDataSource pictureViewerDataSource;
        boolean bl = false;
        if (Check.isEmpty(collection) && this.globalConfig.isUseFlickr()) {
            pictureViewerDataSource = new FlickrPictureDataSource(collection2, objektKategorie);
            bl = true;
        } else {
            pictureViewerDataSource = new LocalPicturesDataSource(collection);
        }
        if (this.pictureViewer != null) {
            if (bl) {
                this.pictureViewer.setListener(null);
            } else {
                this.pictureViewer.setListener(this.votingPictureListener);
            }
            this.pictureViewer.changePictures(pictureViewerDataSource);
            this.pictureViewer.showCurrentPicture();
        } else {
            this.pictureViewer = new PictureViewer(BasisdialogId.DATENBANK_PICTURE_VIEWER, this.globalConfig.getBildZoomAlgorithmus(), pictureViewerDataSource);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 4.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.getContentPane().add((Component)this.pictureViewer, gridBagConstraints);
            this.pictureViewer.showCurrentPicture();
            if (this.globalConfig.isVotingActive()) {
                this.votingPictureListener = new VotingPictureMouseListener(this.pictureViewer, this, this.globalConfig.getHomepageHostname(), this.globalConfig.getPort());
                JLabel jLabel = this.pictureViewer.getPictureLabel();
                jLabel.addMouseListener(this.votingPictureListener);
                this.pictureViewer.setListener(this.votingPictureListener);
            }
        }
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.objektbeschreibungTextArea = new JTextArea();
        this.jToolBar1 = new JToolBar();
        this.jLabel1 = new JLabel();
        this.kategorieCombobox = new JComboBoxExtended();
        this.katalogeAnzeigen = new JCheckBox();
        this.filterButton = new JButton();
        this.objekteCombobox = new JComboBox();
        this.jToolBar2 = new JToolBar();
        this.jLabel2 = new JLabel();
        this.suchenTextfeld = new JComboBoxWithSearch();
        this.exakteSucheChooser = new JCheckBox();
        this.suchoptionenComboBox = new JComboBox();
        this.suchenButton = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu2 = new JMenu();
        this.textDruckenMenu = new JMenuItem();
        this.bildDruckenMenu = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jmenueEingabeformular = new JMenuItem();
        this.jmenueEntdecker = new JMenuItem();
        this.jmenueEntdeckungsmethode = new JMenuItem();
        this.jmenueFilter = new JMenuItem();
        this.jmenueKoords = new JMenuItem();
        this.jmenueImportieren = new JMenuItem();
        this.jmenueExportieren = new JMenuItem();
        this.jmenueReparatur = new JMenuItem();
        this.jmenueAufraeumen = new JMenuItem();
        this.jmenueHistorie = new JMenuItem();
        this.jmenueOnlineUpdate = new JMenuItem();
        this.jmenueOnlineUpdateKandidaten = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jmenuPlanetennamen = new JMenuItem();
        this.jmenueSternnamen = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jmenueGalaxiennamen = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.jMenuItemEsi = new JMenuItem();
        this.jmenueKataloge = new JMenuItem();
        this.jmenueRekorde = new JMenuItem();
        this.jmenueSternbild = new JMenuItem();
        this.jmenueLeuchtkraftklasse = new JMenuItem();
        this.jMenuSternRadiusMasse = new JMenuItem();
        this.jMenuPlanetenTyp = new JMenuItem();
        this.jMenuPrediction = new JMenuItem();
        this.jMenuPhtScan = new JMenuItem();
        this.jmenueDoubleStarCheck = new JMenuItem();
        this.jMenueGaiaStellar = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.alphabet = new JMenuItem();
        this.spektraltypenue = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.nebelklassen = new JMenuItem();
        this.lexi = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.info = new JMenuItem();
        this.morehelp = new JMenuItem();
        this.setTitle("Planetensuche Datenbank");
        this.setCursor(new Cursor(0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setMinimumSize(new Dimension(400, 500));
        this.jScrollPane2.setPreferredSize(new Dimension(400, 500));
        this.objektbeschreibungTextArea.setEditable(false);
        this.objektbeschreibungTextArea.setLineWrap(true);
        this.objektbeschreibungTextArea.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.objektbeschreibungTextArea);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.jToolBar1.setRollover(true);
        this.jLabel1.setText("Kategorie/Katalog auswaehlen:");
        this.jToolBar1.add(this.jLabel1);
        this.jToolBar1.add(this.kategorieCombobox);
        this.katalogeAnzeigen.setText("Kataloge anzeigen");
        this.katalogeAnzeigen.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.katalogeAnzeigen.setFocusable(false);
        this.katalogeAnzeigen.setHorizontalTextPosition(4);
        this.katalogeAnzeigen.setVerticalTextPosition(3);
        this.katalogeAnzeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatenbankDialog.this.katalogeAnzeigenActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.katalogeAnzeigen);
        this.filterButton.setText("filter");
        this.filterButton.setFocusable(false);
        this.filterButton.setHorizontalTextPosition(4);
        this.filterButton.setVerticalTextPosition(3);
        this.jToolBar1.add(this.filterButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jToolBar1, gridBagConstraints);
        this.objekteCombobox.setMinimumSize(new Dimension(400, 27));
        this.objekteCombobox.setPreferredSize(new Dimension(400, 27));
        this.objekteCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatenbankDialog.this.objekteComboboxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.objekteCombobox, gridBagConstraints);
        this.jToolBar2.setRollover(true);
        this.jLabel2.setText("Datenbank nach Objekt durchsuchen:");
        this.jToolBar2.add(this.jLabel2);
        this.jToolBar2.add(this.suchenTextfeld);
        this.exakteSucheChooser.setSelected(true);
        this.exakteSucheChooser.setText("exakt dieses Wort");
        this.exakteSucheChooser.setToolTipText("Wenn aktiviert, wird nicht nach aehnlichen Begriffen gesucht.");
        this.exakteSucheChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.exakteSucheChooser.setFocusable(false);
        this.exakteSucheChooser.setHorizontalTextPosition(4);
        this.exakteSucheChooser.setVerticalTextPosition(3);
        this.jToolBar2.add(this.exakteSucheChooser);
        this.jToolBar2.add(this.suchoptionenComboBox);
        this.suchenButton.setText("suchen");
        this.suchenButton.setFocusable(false);
        this.suchenButton.setHorizontalTextPosition(0);
        this.suchenButton.setVerticalTextPosition(3);
        this.jToolBar2.add(this.suchenButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jToolBar2, gridBagConstraints);
        this.jMenu2.setText("Objekt");
        this.textDruckenMenu.setText("Text drucken");
        this.jMenu2.add(this.textDruckenMenu);
        this.bildDruckenMenu.setText("Bild drucken");
        this.jMenu2.add(this.bildDruckenMenu);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu1.setText("Datenbank");
        this.jmenueEingabeformular.setText("Neuer Eintrag/Eintrag aendern");
        this.jMenu1.add(this.jmenueEingabeformular);
        this.jmenueEntdecker.setText("Entdecker bearbeiten");
        this.jmenueEntdecker.setToolTipText("Entdecker hinzufuegen, bearbeiten und loeschen");
        this.jMenu1.add(this.jmenueEntdecker);
        this.jmenueEntdeckungsmethode.setText("Entdeckungsmethode bearbeiten");
        this.jMenu1.add(this.jmenueEntdeckungsmethode);
        this.jmenueFilter.setText("Filter");
        this.jMenu1.add(this.jmenueFilter);
        this.jmenueKoords.setText("Koordinaten-Abfrage");
        this.jMenu1.add(this.jmenueKoords);
        this.jmenueImportieren.setText("Importieren");
        this.jMenu1.add(this.jmenueImportieren);
        this.jmenueExportieren.setText("Exportieren");
        this.jMenu1.add(this.jmenueExportieren);
        this.jmenueReparatur.setText("Reparatur");
        this.jMenu1.add(this.jmenueReparatur);
        this.jmenueAufraeumen.setText("Datenbank aufraeumen");
        this.jMenu1.add(this.jmenueAufraeumen);
        this.jmenueHistorie.setText("Objekt-Historie");
        this.jMenu1.add(this.jmenueHistorie);
        this.jmenueOnlineUpdate.setText("online update");
        this.jMenu1.add(this.jmenueOnlineUpdate);
        this.jmenueOnlineUpdateKandidaten.setText("online update kandidaten");
        this.jMenu1.add(this.jmenueOnlineUpdateKandidaten);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu3.setText("Extras");
        this.jmenuPlanetennamen.setText("Eigennamen von Planeten");
        this.jMenu3.add(this.jmenuPlanetennamen);
        this.jmenueSternnamen.setText("Eigennamen von Sternen");
        this.jMenu3.add(this.jmenueSternnamen);
        this.jMenuItem7.setText("Eigennamen von Sternhaufen");
        this.jMenu3.add(this.jMenuItem7);
        this.jmenueGalaxiennamen.setText("Eigennamen von Nebeln&Galaxien");
        this.jMenu3.add(this.jmenueGalaxiennamen);
        this.jMenuItem4.setText("Entdeckungsjahr von Exo-Planeten");
        this.jMenu3.add(this.jMenuItem4);
        this.jMenuItem9.setText("sterne in 33 ly");
        this.jMenu3.add(this.jMenuItem9);
        this.jMenuItemEsi.setText("ESI Exoplaneten");
        this.jMenu3.add(this.jMenuItemEsi);
        this.jmenueKataloge.setText("Ubersicht von Katalogen");
        this.jMenu3.add(this.jmenueKataloge);
        this.jmenueRekorde.setText("Uebersicht von Rekorden");
        this.jMenu3.add(this.jmenueRekorde);
        this.jmenueSternbild.setText("Sternbild ermitteln");
        this.jMenu3.add(this.jmenueSternbild);
        this.jmenueLeuchtkraftklasse.setText("Leuchtkraftklasse ermitteln");
        this.jMenu3.add(this.jmenueLeuchtkraftklasse);
        this.jMenuSternRadiusMasse.setText("stern radius und masse ermitteln");
        this.jMenu3.add(this.jMenuSternRadiusMasse);
        this.jMenuPlanetenTyp.setText("planeten typ ermitteln");
        this.jMenu3.add(this.jMenuPlanetenTyp);
        this.jMenuPrediction.setText("Prognosen Entdeckungen");
        this.jMenu3.add(this.jMenuPrediction);
        this.jMenuPhtScan.setText("pht user discoveries");
        this.jMenu3.add(this.jMenuPhtScan);
        this.jmenueDoubleStarCheck.setText("double star check");
        this.jMenu3.add(this.jmenueDoubleStarCheck);
        this.jMenueGaiaStellar.setText("gaia stellar data");
        this.jMenu3.add(this.jMenueGaiaStellar);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu4.setText("Hilfe");
        this.alphabet.setText("Griechisches Alphabet");
        this.jMenu4.add(this.alphabet);
        this.spektraltypenue.setText("Eigenschaften von Spektraltypen");
        this.jMenu4.add(this.spektraltypenue);
        this.jMenuItem6.setText("Klassifikation von Veraenderlichen Sternen");
        this.jMenuItem6.setActionCommand("Uebersicht Veraenderliche Sterne");
        this.jMenu4.add(this.jMenuItem6);
        this.nebelklassen.setText("Klassifikation von Nebeln&Galaxien");
        this.jMenu4.add(this.nebelklassen);
        this.lexi.setText("Lexikon");
        this.jMenu4.add(this.lexi);
        this.jMenu4.add(this.jSeparator1);
        this.info.setText("Info");
        this.jMenu4.add(this.info);
        this.morehelp.setText("die Hilfe anzeigen");
        this.jMenu4.add(this.morehelp);
        this.jMenuBar1.add(this.jMenu4);
        this.setJMenuBar(this.jMenuBar1);
        this.setSize(new Dimension(800, 700));
        this.setLocationRelativeTo(null);
    }

    public JCheckBox getKatalogeAnzeigen() {
        return this.katalogeAnzeigen;
    }

    public JComboBox<String> getObjekteCombobox() {
        return this.objekteCombobox;
    }

    public void setZeigeStatusfensterBeimObjektLaden(boolean bl) {
        this.zeigeStatusfensterBeimObjektLaden = bl;
    }

    public boolean isZeigeStatusfensterBeimObjektLaden() {
        return this.zeigeStatusfensterBeimObjektLaden;
    }

    public KonfigurationDTO getDatenbankKonfiguration() {
        return this.globalConfig;
    }

    public synchronized JTextArea getTextarea() {
        return this.objektbeschreibungTextArea;
    }

    public JMenuItem getJmenueSternbild() {
        return this.jmenueSternbild;
    }

    public JMenuItem getJmenueKoords() {
        return this.jmenueKoords;
    }

    public JMenuItem getJmenueExoplaneten() {
        return this.jMenuItem4;
    }

    public JMenuItem getJmenueHistorie() {
        return this.jmenueHistorie;
    }

    public JMenuItem getJmenueSternnamen() {
        return this.jmenueSternnamen;
    }

    public JMenuItem getJmenueGalaxiennamen() {
        return this.jmenueGalaxiennamen;
    }

    public JMenuItem getjMenuSternRadiusMasse() {
        return this.jMenuSternRadiusMasse;
    }

    public JMenuItem getJmenuPlanetennamen() {
        return this.jmenuPlanetennamen;
    }

    public JMenuItem getJmenueOnlineUpdate() {
        return this.jmenueOnlineUpdate;
    }

    public JMenuItem getjMenuPhtScan() {
        return this.jMenuPhtScan;
    }

    private void katalogeAnzeigenActionPerformed(ActionEvent actionEvent) {
        this.viewMenue();
    }

    private void viewMenue() {
        this.kategorieCombobox.removeAllItems();
        if (this.katalogeAnzeigen.isSelected()) {
            this.filterButton.setEnabled(false);
            try {
                KatalogService katalogService = new KatalogService();
                List<String> list = katalogService.ladeKatalogDatei();
                for (String string : list) {
                    String[] stringArray = string.split(",");
                    if (stringArray[0].length() == 1) {
                        this.kategorieCombobox.addItem(stringArray[1], stringArray[0]);
                        continue;
                    }
                    this.kategorieCombobox.addItem(stringArray[0] + " " + this.i18n.getString("db_m8"), stringArray[0]);
                }
            }
            catch (IOException iOException) {
                this.showMessageOnMessageBar(this.i18n.getString("db_f9"), IconPoolDefault.STOP);
                this.getLogger().error(iOException);
            }
        } else {
            this.filterButton.setEnabled(true);
            for (String string : this.i18n.getPlanetensucheObjektKategorien()) {
                this.kategorieCombobox.addItem(string);
            }
        }
    }

    public JMenuItem getJMenueBildDrucken() {
        return this.bildDruckenMenu;
    }

    public JMenuItem getJMenueTextDrucken() {
        return this.textDruckenMenu;
    }

    public JMenuItem getJmenueRekorde() {
        return this.jmenueRekorde;
    }

    public JMenuItem getJmenueHilfe() {
        return this.morehelp;
    }

    public JMenuItem getJmenueLexikon() {
        return this.lexi;
    }

    public JMenuItem getJmenueExport() {
        return this.jmenueExportieren;
    }

    public JMenuItem getJmenueImport() {
        return this.jmenueImportieren;
    }

    public JMenuItem getJmenueNebelklassen() {
        return this.nebelklassen;
    }

    public JMenuItem getJmenueSpektraltypen() {
        return this.spektraltypenue;
    }

    public JMenuItem getJmenueKataloge() {
        return this.jmenueKataloge;
    }

    public JMenuItem getJMenueAlphabet() {
        return this.alphabet;
    }

    public JMenuItem getJmenueReparatur() {
        return this.jmenueReparatur;
    }

    public JMenuItem getJmenueFilter() {
        return this.jmenueFilter;
    }

    public JMenuItem getJmenueInfo() {
        return this.info;
    }

    public void zeigeSternbild(ISternbild iSternbild) {
        List<String> list;
        this.objektbeschreibungTextArea.append(this.i18n.getString("db_m62") + ": " + iSternbild.getSternbildDTBezeichnung() + "\n");
        this.objektbeschreibungTextArea.append(this.i18n.getString("db_m63") + ": " + iSternbild.getSternbildENGBezeichnung() + "\n");
        this.objektbeschreibungTextArea.append(this.i18n.getString("db_m64") + ": " + iSternbild.getSternbildLATBezeichnung() + "\n");
        this.objektbeschreibungTextArea.append(this.i18n.getString("db_m65") + ": " + iSternbild.getSternbildCode() + "\n");
        this.objektbeschreibungTextArea.append(this.i18n.getString("db_m66") + ": " + iSternbild.getSternbildGenitiv() + "\n");
        this.objektbeschreibungTextArea.append("\n" + this.i18n.getString("db_m67") + ":\n");
        this.objektbeschreibungTextArea.append(this.i18n.getString("db_m14") + " RA " + iSternbild.getSternbildVonRA() + "h " + this.i18n.getString("db_m68") + " RA " + iSternbild.getSternbildBisRA() + "h\n");
        this.objektbeschreibungTextArea.append(this.i18n.getString("db_m14") + " DECL " + iSternbild.getSternbildVonDECL() + "\u00b0 " + this.i18n.getString("db_m68") + " DECL " + iSternbild.getSternbildBisDECL() + "\u00b0\n");
        if (!iSternbild.getObjekteImSternbild().isEmpty()) {
            Collections.sort(iSternbild.getObjekteImSternbild());
            this.objektbeschreibungTextArea.append("\n\n" + this.i18n.getString("db_m69") + ":\n");
            list = iSternbild.getObjekteImSternbild(1000000);
            for (String string : list) {
                this.objektbeschreibungTextArea.append(string + "\n");
            }
        }
        this.objektbeschreibungTextArea.setComponentPopupMenu(null);
        list = Arrays.asList(iSternbild.getSternbildENGBezeichnung(), iSternbild.getSternbildDTBezeichnung(), iSternbild.getSternbildLATBezeichnung());
        this.createPictureViewerComponent(iSternbild.getBilder(), list, ObjektKategorie.STERNBILDER);
    }

    public void zeigeInfos(String string) {
        if (!this.semaphorLooked && string != null && !string.isEmpty()) {
            Lesenthread lesenthread = new Lesenthread(string, this, this.parameter, this.zeigeStatusfensterBeimObjektLaden, this.injectionDto);
            lesenthread.start();
        } else {
            this.getLogger().info(this.i18n.getString("db_f21"));
        }
    }

    public void zeigeObjekt(String string, String string2, IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException, IOException {
        this.aktuellAngezeigtesObjekt = iPlanetensucheObjekt;
        String string3 = this.datenbankHelfer.getDoppelSternKomponenten(iPlanetensucheObjekt.getObjektNamen());
        this.datenbankZeigeObjekt.zeigeObjekt(string, string2, iPlanetensucheObjekt, string3, this.objektbeschreibungTextArea);
        this.createPictureViewerComponent(iPlanetensucheObjekt.getBilder(), iPlanetensucheObjekt.getObjektNamen(), ObjektKategorie.parse(iPlanetensucheObjekt.getKategorie()));
        this.objektbeschreibungTextArea.setComponentPopupMenu(this.kontextmenu.erzeugeKontextmenu(this.aktuellAngezeigtesObjekt, string3));
        if (this.votingMouseListner != null) {
            this.votingMouseListner.changeObject(iPlanetensucheObjekt.getCategory(), string);
        }
        if (this.votingPictureListener != null) {
            if (Check.isEmpty(iPlanetensucheObjekt.getBilder())) {
                this.votingPictureListener.changeObject(null, string);
            } else {
                this.votingPictureListener.changeObject(iPlanetensucheObjekt.getBilder().iterator().next(), string);
            }
        }
    }

    private void objekteComboboxActionPerformed(ActionEvent actionEvent) {
        if (this.objekteCombobox.getSelectedIndex() > -1) {
            this.letztesObjekt = this.objekteCombobox.getSelectedItem().toString();
            this.zeigeInfos(this.letztesObjekt);
        }
    }

    public JMenuItem getJmenueDoubleStarCheck() {
        return this.jmenueDoubleStarCheck;
    }

    public JMenuItem getjMenuPlanetenTyp() {
        return this.jMenuPlanetenTyp;
    }

    public JMenuItem getJmenueEingabeformular() {
        return this.jmenueEingabeformular;
    }

    public JComboBoxExtended<String> getKategorieCombobox() {
        return this.kategorieCombobox;
    }

    public JMenuItem getJmenueEntdecker() {
        return this.jmenueEntdecker;
    }

    public JMenuItem getjMenuVeraenderlicheSterne() {
        return this.jMenuItem6;
    }

    public JMenuItem getJmenueEntdeckungsmethode() {
        return this.jmenueEntdeckungsmethode;
    }

    public JMenuItem getjMenuSonnennaheSterne() {
        return this.jMenuItem9;
    }

    public JMenuItem getJmenueAufraeumen() {
        return this.jmenueAufraeumen;
    }

    public JMenuItem getjMenuSternhaufenNamen() {
        return this.jMenuItem7;
    }

    public JMenuItem getjMenuPrediction() {
        return this.jMenuPrediction;
    }

    public JButton getFilterButton() {
        return this.filterButton;
    }

    public JComboBox<String> getSuchoptionenComboBox() {
        return this.suchoptionenComboBox;
    }

    public JButton getSuchenButton() {
        return this.suchenButton;
    }

    public JComboBoxWithSearch getSuchenTextfeld() {
        return this.suchenTextfeld;
    }

    public JCheckBox getExakteSucheChooser() {
        return this.exakteSucheChooser;
    }

    public JMenuItem getJmenueLeuchtkraftklasse() {
        return this.jmenueLeuchtkraftklasse;
    }

    public JMenuItem getJmenueOnlineUpdateKandidaten() {
        return this.jmenueOnlineUpdateKandidaten;
    }

    public JMenuItem getjMenuItemEsi() {
        return this.jMenuItemEsi;
    }
}

