/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import com.google.inject.Injector;
import de.planetensuche.core.db.SearchableDataSource;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.impl.SternbildFinder;
import de.planetensuche.datenbank.BackgroundServiceFactory;
import de.planetensuche.datenbank.DatenbankDialog;
import de.planetensuche.datenbank.DatenbankDialogControlerSuche;
import de.planetensuche.datenbank.DatenbankDialogHelpMenueControler;
import de.planetensuche.datenbank.DatenbankDialogKontextmenu;
import de.planetensuche.datenbank.DatenbankZeigeObjekt;
import de.planetensuche.datenbank.DialogFactory;
import de.planetensuche.datenbank.Druckjob;
import de.planetensuche.datenbank.GrichischesAlphabetDialog;
import de.planetensuche.datenbank.api.IDatenbankDialog;
import de.planetensuche.datenbank.api.IStart;
import de.planetensuche.datenbank.dbmodel.api.FilterkonfigurationDto;
import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dbmodel.basis.DAOhighService;
import de.planetensuche.datenbank.dbmodel.basis.ExoplanetsEsiRepository;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.InjectionDtoFactory;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.exportierer.guis.ExportDialog;
import de.planetensuche.datenbank.filter.FilterService;
import de.planetensuche.datenbank.guis.datenbank.FilteroptionenDialog;
import de.planetensuche.datenbank.guis.datenbank.KoordsqueryDialog;
import de.planetensuche.datenbank.guis.datenbank.LeuchtkraftklassenErmittelnDialog;
import de.planetensuche.datenbank.guis.datenbank.ObjekthistorieControler;
import de.planetensuche.datenbank.guis.datenbank.PlanetentypErmittelnDialog;
import de.planetensuche.datenbank.guis.datenbank.SternRadiusMasseErmittelnDialog;
import de.planetensuche.datenbank.guis.datenbank.SternbildErmittelnDialog;
import de.planetensuche.datenbank.guis.doublestar.DoubleStarCheckDialogController;
import de.planetensuche.datenbank.guis.formulare.EingabeentdeckerDialog;
import de.planetensuche.datenbank.guis.formulare.EingabemethodenDialog;
import de.planetensuche.datenbank.guis.formulare.objektbearbeiten.EingabePlanetensucheObjektDialogControler;
import de.planetensuche.datenbank.guis.gaia.GaiaStellarDataDialogController;
import de.planetensuche.datenbank.guis.menuextras.ExoplanetenEntdeckungsdatumControllerAndDialog;
import de.planetensuche.datenbank.guis.menuextras.ExoplanetsEsiDialog;
import de.planetensuche.datenbank.guis.menuextras.ListeNaherSterneDialog;
import de.planetensuche.datenbank.guis.menuextras.NamenlisteOption;
import de.planetensuche.datenbank.guis.menuextras.NamenslisteThread;
import de.planetensuche.datenbank.guis.menuextras.RekordeDialog;
import de.planetensuche.datenbank.importierer.api.IAllNasaExoplanetOnlineImporter;
import de.planetensuche.datenbank.importierer.api.ImportController;
import de.planetensuche.datenbank.importierer.csv.AllNasaExoplanetOnlineImporter;
import de.planetensuche.datenbank.menuekataloge.KatalogeControler;
import de.planetensuche.datenbank.phtmatches.PhtMatchesDialogControler;
import de.planetensuche.datenbank.reorganisieren.Aufraeumthread;
import de.planetensuche.datenbank.reparatur.ReparaturDialog;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.search.JComboBoxWithSearch;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.neuronalnet.api.ExoplanetPredictionController;
import de.planetensuche.neuronalnet.api.ExoplanetPredictionControllerFactory;
import de.planetensuche.neuronalnet.api.StarDetailDialog;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JOptionPane;

public final class DatenbankDialogControler
implements IDatenbankDialog,
StarDetailDialog {
    private final ILogging logger;
    private final DatenbankDialog datenbankDialog;
    private final ISprachcontainer i18n;
    private final ParameterDto parameter;
    private final KonfigurationDTO globaleKonfig;
    private final KoordinatenFormat koordinatenFormat;
    private final IStart start;
    private final Druckjob druckjob;
    private final IDAOhighService daoHighService;
    private KatalogeControler kataloggui;
    private ExoplanetPredictionController predictionController;
    private FilteroptionenDialog filteroptionen;
    private FilterkonfigurationDto filterkonfiguration;
    private final FilterService filterService;
    private final Injector injector;
    private final InjectionDto injectionDto;
    private SternbildFinder sternbildFinder;
    private final ImportController importDialogController;
    private final PhtMatchesDialogControler phtMatchesDialogControler;
    private final IAllNasaExoplanetOnlineImporter nasaOnlineImporter;
    private final DatenbankDialogControlerSuche suchService;
    private final DialogFactory dialogFactory;
    private final BackgroundServiceFactory backgroundServiceFactory;
    private final AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor;

    public DatenbankDialogControler(boolean bl, IStart iStart, ParameterDto parameterDto, KonfigurationDTO konfigurationDTO, KoordinatenFormat koordinatenFormat, Injector injector) throws IOException {
        Object object;
        this.parameter = parameterDto;
        this.koordinatenFormat = koordinatenFormat;
        this.start = iStart;
        this.globaleKonfig = konfigurationDTO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.druckjob = new Druckjob(konfigurationDTO);
        this.injector = injector;
        this.daoHighService = this.injector.getInstance(IDAOhighService.class);
        this.asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
        this.dialogFactory = new DialogFactory(injector);
        this.backgroundServiceFactory = new BackgroundServiceFactory(injector);
        ((DAOhighService)this.daoHighService).sucheFehlerhafteDaten();
        this.injectionDto = InjectionDtoFactory.createInjectionDto(injector);
        this.importDialogController = this.dialogFactory.createImportDialog(parameterDto, this.start, this.globaleKonfig);
        this.logger.info("Filter laden...");
        this.filterService = new FilterService(this.i18n);
        this.filterkonfiguration = this.filterService.ladeFiltereinstellungen();
        DatenbankZeigeObjekt datenbankZeigeObjekt = this.backgroundServiceFactory.createShowObjectHelper(koordinatenFormat, konfigurationDTO.getSternbildSprache());
        DatenbankDialogKontextmenu datenbankDialogKontextmenu = new DatenbankDialogKontextmenu(this.i18n, this.koordinatenFormat, this);
        this.datenbankDialog = new DatenbankDialog(this.parameter, konfigurationDTO, datenbankDialogKontextmenu, datenbankZeigeObjekt, this.injectionDto);
        this.suchService = new DatenbankDialogControlerSuche(this.datenbankDialog, injector);
        this.phtMatchesDialogControler = this.dialogFactory.createPhtMatches(this.injectionDto.getKatalogerkenner(), this.datenbankDialog);
        this.addActionListeners();
        this.addWindowListeners();
        this.nasaOnlineImporter = new AllNasaExoplanetOnlineImporter(this.datenbankDialog, this.importDialogController, this.injectionDto.getTimestampDAO());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> this.nasaOnlineImporter.updateDatabaseIfNeeded());
        try {
            object = this.daoHighService.getZufallsObjekt();
            if (object != null && !((String)object).isEmpty()) {
                this.datenbankDialog.zeigeInfos((String)object);
            }
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            JOptionPane.showMessageDialog(this.datenbankDialog, this.i18n.getString("db_f4"), this.i18n.getString("db_f4_titel"), 0);
            this.datenbankDialog.zeigeInfos("Merkur");
        }
        if (bl) {
            object = this.dialogFactory.createReparaturDialog(true, this.parameter, this);
            ((Window)object).setVisible(true);
        }
    }

    private ObjektKategorie getSelectedCategory() {
        if (this.datenbankDialog.getKategorieCombobox().getSelectedIndex() == 9) {
            return ObjektKategorie.STERNBILDER;
        }
        if (this.datenbankDialog.getKategorieCombobox().getSelectedIndex() == 10) {
            return ObjektKategorie.STERNE;
        }
        return ObjektKategorie.SONSTIGES;
    }

    private boolean isShowCatalogsSelected() {
        return this.datenbankDialog.getKatalogeAnzeigen().isSelected();
    }

    private String getSelectedCategoryValue() {
        return this.datenbankDialog.getKategorieCombobox().getSelectedInternalValue();
    }

    @Override
    public void showDetails(String string) {
        try {
            this.springeZuObjekt(string);
            this.predictionController.hideDialog();
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
    }

    private void addWindowListeners() {
        this.datenbankDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DatenbankDialogControler.this.updateEnde();
            }
        });
    }

    private void addActionListeners() {
        this.datenbankDialog.getjMenueGaiaStellar().addActionListener(actionEvent -> {
            GaiaStellarDataDialogController gaiaStellarDataDialogController = new GaiaStellarDataDialogController();
            gaiaStellarDataDialogController.showDialog();
        });
        this.datenbankDialog.getJmenueDoubleStarCheck().addActionListener(actionEvent -> {
            DoubleStarCheckDialogController doubleStarCheckDialogController = this.dialogFactory.createDoubleStarCheck(this.injectionDto.getKatalogerkenner(), this.globaleKonfig, this.datenbankDialog);
            doubleStarCheckDialogController.showDialog();
        });
        this.datenbankDialog.getjMenuPhtScan().addActionListener(actionEvent -> this.phtMatchesDialogControler.showDialog());
        this.datenbankDialog.getJmenueSternbild().addActionListener(actionEvent -> {
            try {
                if (this.sternbildFinder == null) {
                    this.sternbildFinder = new SternbildFinder();
                }
                SternbildErmittelnDialog sternbildErmittelnDialog = new SternbildErmittelnDialog(this.sternbildFinder);
                sternbildErmittelnDialog.setVisible(true);
            }
            catch (IOException iOException) {
                this.logger.error(iOException);
            }
        });
        this.datenbankDialog.getJmenueLeuchtkraftklasse().addActionListener(actionEvent -> {
            LeuchtkraftklassenErmittelnDialog leuchtkraftklassenErmittelnDialog = this.dialogFactory.createLk();
            leuchtkraftklassenErmittelnDialog.setVisible(true);
        });
        this.datenbankDialog.getjMenuSternRadiusMasse().addActionListener(actionEvent -> {
            SternRadiusMasseErmittelnDialog sternRadiusMasseErmittelnDialog = this.dialogFactory.createStarRadiusMass();
            sternRadiusMasseErmittelnDialog.setVisible(true);
        });
        this.datenbankDialog.getjMenuPlanetenTyp().addActionListener(actionEvent -> {
            PlanetentypErmittelnDialog planetentypErmittelnDialog = this.dialogFactory.createPlanetTyp();
            planetentypErmittelnDialog.setVisible(true);
        });
        this.datenbankDialog.getJmenueKoords().addActionListener(actionEvent -> {
            KoordsqueryDialog koordsqueryDialog = this.dialogFactory.createKoordsQuery(this.parameter, this.koordinatenFormat);
            koordsqueryDialog.setVisible(true);
        });
        this.datenbankDialog.getJmenueExoplaneten().addActionListener(actionEvent -> this.asyncLoadingScreenCallbackExecutor.execute(this.datenbankDialog, () -> {
            ExoplanetenEntdeckungsdatumControllerAndDialog exoplanetenEntdeckungsdatumControllerAndDialog = this.dialogFactory.createExoDate();
            exoplanetenEntdeckungsdatumControllerAndDialog.showDialog();
        }));
        this.datenbankDialog.getJmenueHistorie().addActionListener(actionEvent -> {
            ObjekthistorieControler objekthistorieControler = new ObjekthistorieControler(this.parameter, this.daoHighService);
            objekthistorieControler.showDialog(this.datenbankDialog);
        });
        this.datenbankDialog.getJmenueExport().addActionListener(actionEvent -> {
            ExportDialog exportDialog = this.dialogFactory.createExportDialog(this.parameter, this.injectionDto, this.globaleKonfig);
            exportDialog.setVisible(true);
        });
        this.datenbankDialog.getJmenueImport().addActionListener(actionEvent -> this.importDialogController.showDialog());
        this.datenbankDialog.getJmenueReparatur().addActionListener(actionEvent -> {
            ReparaturDialog reparaturDialog = this.dialogFactory.createReparaturDialog(false, this.parameter, this);
            reparaturDialog.setVisible(true);
        });
        this.datenbankDialog.getJmenueEingabeformular().addActionListener(actionEvent -> {
            EingabePlanetensucheObjektDialogControler eingabePlanetensucheObjektDialogControler = this.dialogFactory.createMainEditDialog(this.parameter, this.filterkonfiguration, this.injectionDto, this.globaleKonfig);
            eingabePlanetensucheObjektDialogControler.showDialog();
        });
        this.datenbankDialog.getJMenueBildDrucken().addActionListener(actionEvent -> {
            if (this.datenbankDialog.getPictureViewer().getCurrentPictureFilename() != null) {
                this.druckjob.druckeBild(this.datenbankDialog.getPictureViewer().getCurrentPictureFilename(), this.datenbankDialog.getLetztesObjekt());
            }
        });
        this.datenbankDialog.getJMenueTextDrucken().addActionListener(actionEvent -> {
            if (!this.datenbankDialog.getObjektbeschreibungTextArea().getText().isEmpty()) {
                this.druckjob.druckeText(this.datenbankDialog.getObjektbeschreibungTextArea(), this.datenbankDialog.getLetztesObjekt());
            }
        });
        this.datenbankDialog.getJmenueRekorde().addActionListener(actionEvent -> {
            RekordeDialog rekordeDialog = this.dialogFactory.createRekorde(this.datenbankDialog);
            rekordeDialog.starteRekordzusammenstellung(this.datenbankDialog);
        });
        this.datenbankDialog.getJmenueKataloge().addActionListener(actionEvent -> {
            try {
                if (this.kataloggui == null) {
                    this.kataloggui = this.dialogFactory.createCatalogGui(this.parameter, this.injectionDto);
                }
                this.kataloggui.showDialog(this.datenbankDialog);
            }
            catch (Exception exception) {
                this.datenbankDialog.showMessageOnMessageBarByKey("db_f9", IconPoolDefault.STOP);
                this.logger.error(exception);
            }
        });
        this.datenbankDialog.getJMenueAlphabet().addActionListener(actionEvent -> {
            GrichischesAlphabetDialog grichischesAlphabetDialog = new GrichischesAlphabetDialog();
            grichischesAlphabetDialog.zeigeDialog();
        });
        this.datenbankDialog.getKategorieCombobox().addActionListener(actionEvent -> {
            if (!this.datenbankDialog.isSemaphorLooked() && this.datenbankDialog.getKategorieCombobox().getSelectedIndex() > -1) {
                this.datenbankDialog.setSemaphorLooked(true);
                this.datenbankDialog.setZeigeStatusfensterBeimObjektLaden(false);
                this.asyncLoadingScreenCallbackExecutor.execute(this.datenbankDialog, () -> {
                    this.leseObjektnamenFuerKategorieUndFuelleListe();
                    this.datenbankDialog.setSemaphorLooked(false);
                    this.datenbankDialog.getObjektbeschreibungTextArea().setText("");
                    if (this.datenbankDialog.getObjekteCombobox().getItemCount() > 0) {
                        this.datenbankDialog.getObjekteCombobox().setSelectedIndex(0);
                    }
                    this.datenbankDialog.setZeigeStatusfensterBeimObjektLaden(true);
                });
            }
        });
        this.datenbankDialog.getJmenueEntdecker().addActionListener(actionEvent -> {
            EingabeentdeckerDialog eingabeentdeckerDialog = this.dialogFactory.createEntdecker(this.parameter);
            eingabeentdeckerDialog.setVisible(true);
        });
        this.datenbankDialog.getJmenueEntdeckungsmethode().addActionListener(actionEvent -> {
            EingabemethodenDialog eingabemethodenDialog = this.dialogFactory.createEntdeckungsMethoden(this.parameter);
            eingabemethodenDialog.setVisible(true);
        });
        this.datenbankDialog.getjMenuSonnennaheSterne().addActionListener(actionEvent -> {
            ListeNaherSterneDialog listeNaherSterneDialog = this.dialogFactory.createNaheSterne();
            listeNaherSterneDialog.showDialog();
        });
        this.datenbankDialog.getjMenuItemEsi().addActionListener(actionEvent -> {
            ExoplanetsEsiRepository exoplanetsEsiRepository = this.injector.getInstance(ExoplanetsEsiRepository.class);
            ExoplanetsEsiDialog exoplanetsEsiDialog = new ExoplanetsEsiDialog(exoplanetsEsiRepository);
            exoplanetsEsiDialog.showDialog();
        });
        this.datenbankDialog.getJmenueAufraeumen().addActionListener(actionEvent -> {
            int n = JOptionPane.showConfirmDialog(this.datenbankDialog, this.i18n.getString("db_m431"), this.i18n.getString("db_m431_titel"), 0, 3);
            if (n == 0) {
                boolean bl = false;
                if (0 == JOptionPane.showConfirmDialog(this.datenbankDialog, this.i18n.getString("db_m431_sicherheitsabfrage_loeschen"), this.i18n.getString("db_m431_titel"), 0, 3)) {
                    bl = true;
                }
                Aufraeumthread aufraeumthread = this.backgroundServiceFactory.createAufraeumthread(bl);
                aufraeumthread.start();
            }
        });
        this.datenbankDialog.getJmenuPlanetennamen().addActionListener(actionEvent -> this.showNameListDialog(NamenlisteOption.PLANETEN));
        this.datenbankDialog.getJmenueGalaxiennamen().addActionListener(actionEvent -> this.showNameListDialog(NamenlisteOption.DEEP_SKY));
        this.datenbankDialog.getJmenueSternnamen().addActionListener(actionEvent -> this.showNameListDialog(NamenlisteOption.STERNE));
        this.datenbankDialog.getjMenuSternhaufenNamen().addActionListener(actionEvent -> this.showNameListDialog(NamenlisteOption.STERNHAUFEN));
        this.datenbankDialog.getJmenueFilter().addActionListener(this.createActionListenerForFilterButton());
        this.datenbankDialog.getFilterButton().addActionListener(this.createActionListenerForFilterButton());
        this.datenbankDialog.getSuchenButton().addActionListener(actionEvent -> this.suchService.sucheobjekt());
        SearchableDataSource searchableDataSource = this.injector.getInstance(SearchableDataSource.class);
        JComboBoxWithSearch jComboBoxWithSearch = this.datenbankDialog.getSuchenTextfeld();
        jComboBoxWithSearch.init(searchableDataSource);
        jComboBoxWithSearch.setEnterKeyListener(string -> this.suchService.sucheobjekt());
        this.datenbankDialog.getjMenuPrediction().addActionListener(actionEvent -> {
            try {
                if (this.sternbildFinder == null) {
                    this.sternbildFinder = new SternbildFinder();
                }
                if (this.predictionController == null) {
                    ExoplanetPredictionControllerFactory exoplanetPredictionControllerFactory = new ExoplanetPredictionControllerFactory();
                    this.predictionController = exoplanetPredictionControllerFactory.create(this.injector, this.sternbildFinder, this);
                }
                this.predictionController.showDialog();
            }
            catch (IOException iOException) {
                this.logger.error(iOException);
            }
        });
        this.datenbankDialog.getJmenueOnlineUpdate().addActionListener(actionEvent -> Executors.newSingleThreadExecutor().submit(() -> this.nasaOnlineImporter.updateDatabaseImmediately()));
        this.datenbankDialog.getJmenueOnlineUpdateKandidaten().addActionListener(actionEvent -> Executors.newSingleThreadExecutor().submit(() -> {
            try {
                this.importDialogController.showDialog();
                File file = new File("temp");
                String string = this.i18n.getString("db_gui135");
                this.importDialogController.setImportType(string);
                this.importDialogController.createAndRunImportThread(file, string);
            }
            catch (IOException | SQLException exception) {
                this.logger.error(exception);
                JOptionPane.showMessageDialog(this.datenbankDialog, this.i18n.getString("db_m463"), this.i18n.getString("db_m462_titel"), 0);
            }
        }));
        new DatenbankDialogHelpMenueControler(this.datenbankDialog, this.injector).addActionListeners();
    }

    private ActionListener createActionListenerForFilterButton() {
        return actionEvent -> this.showFilteroptionDialog();
    }

    private void showFilteroptionDialog() {
        if (this.filteroptionen == null) {
            this.filteroptionen = this.dialogFactory.createFilter(this.parameter, this);
        }
        this.filteroptionen.setVisible(true);
    }

    private void leseObjektnamenFuerKategorieUndFuelleListe() {
        try {
            List<String> list = this.backgroundServiceFactory.createObjectNamesFinder().createNamesList(this.isShowCatalogsSelected(), this.getSelectedCategoryValue(), this.getSelectedCategory(), this.datenbankDialog.getKategorieCombobox().getSelectedIndex(), this.filterkonfiguration);
            this.datenbankDialog.getObjekteCombobox().removeAllItems();
            for (String string : list) {
                this.datenbankDialog.getObjekteCombobox().addItem(string);
            }
        }
        catch (RuntimeException | SQLException exception) {
            this.datenbankDialog.showMessageOnMessageBarByKey("db_f31", exception, IconPoolDefault.STOP);
            this.logger.error(exception);
        }
    }

    private void showNameListDialog(NamenlisteOption namenlisteOption) {
        NamenslisteThread namenslisteThread = this.dialogFactory.createNameList(this.datenbankDialog, this.parameter, namenlisteOption);
        namenslisteThread.start();
    }

    public void showDialog() {
        this.datenbankDialog.setVisible(true);
    }

    public void closeDialog() {
        this.datenbankDialog.dispose();
    }

    @Override
    public void updateEnde() {
        this.filterService.speichereFiltereinstellungen(this.filterkonfiguration);
        this.start.exitApp();
    }

    @Override
    public FilterkonfigurationDto getFilterbedingungen() {
        return this.filterkonfiguration;
    }

    @Override
    public void setFilterbedingungen(FilterkonfigurationDto filterkonfigurationDto) {
        this.filterkonfiguration = filterkonfigurationDto;
    }

    @Override
    public void springeZuObjekt(String string) throws SQLException {
        String string2 = this.injector.getInstance(IKategorienRepository.class).getKategorieFuerObjekt(string);
        this.datenbankDialog.setSemaphorLooked(true);
        List<String> list = this.daoHighService.getKategorien();
        int n = list.indexOf(string2);
        this.datenbankDialog.getKategorieCombobox().setSelectedIndex(n);
        this.datenbankDialog.setSemaphorLooked(false);
        this.datenbankDialog.zeigeInfos(string);
    }

    public DatenbankDialog getDatenbankDialog() {
        return this.datenbankDialog;
    }
}

