/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import com.google.inject.Injector;
import de.planetensuche.datenbank.DatenbankDialog;
import de.planetensuche.datenbank.EingabeValidator;
import de.planetensuche.datenbank.InternetSuche;
import de.planetensuche.datenbank.InternetSucheErgebnisDialog;
import de.planetensuche.datenbank.dbmodel.api.IObjektsucheDAO;
import de.planetensuche.datenbank.dbmodel.notizen.api.INotizenService;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DatenbankDialogControlerSuche {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final ISprachcontainer sprache = SprachcontainerFabrik.getSprachcontainer();
    private final DatenbankDialog datenbankDialog;
    private final AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor;
    private boolean internetOffline;
    private final Injector injector;

    public DatenbankDialogControlerSuche(DatenbankDialog datenbankDialog, Injector injector) {
        this.datenbankDialog = datenbankDialog;
        this.asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
        this.injector = injector;
    }

    public void sucheobjekt() {
        this.datenbankDialog.setCursor(new Cursor(3));
        if (!this.datenbankDialog.isSemaphorLooked()) {
            this.datenbankDialog.setSemaphorLooked(true);
            try {
                String string = this.datenbankDialog.getSuchenTextfeld().getText();
                if (string.length() > 1) {
                    EingabeValidator eingabeValidator = new EingabeValidator();
                    boolean bl = eingabeValidator.containsSQL(string);
                    if (!bl) {
                        bl = eingabeValidator.isErlaubteZeichenkette(string);
                        if (!bl) {
                            JOptionPane.showMessageDialog(this.datenbankDialog, this.sprache.getString("db_f27"), this.sprache.getString("db_f27_titel"), 0);
                        } else {
                            this.asyncLoadingScreenCallbackExecutor.execute(this.datenbankDialog, () -> {
                                String string = this.datenbankDialog.getSuchoptionenComboBox().getSelectedItem().toString();
                                List<String> list = this.searchForUserInput(string);
                                this.zeigeGefundeneSuchobjekte(string, list);
                            });
                        }
                    } else {
                        this.datenbankDialog.showMessageOnMessageBar(this.sprache.getString("db_f28"), IconPoolDefault.STOP);
                    }
                } else {
                    this.datenbankDialog.showMessageOnMessageBar(this.sprache.getString("db_f29"), IconPoolDefault.STOP);
                }
            }
            catch (Exception exception) {
                this.datenbankDialog.showMessageOnMessageBar(this.sprache.getString("db_f30") + " " + exception.getLocalizedMessage(), IconPoolDefault.STOP);
                this.logger.error(exception);
            }
            this.datenbankDialog.setSemaphorLooked(false);
        } else {
            this.datenbankDialog.showMessageOnMessageBar(this.sprache.getString("db_f21"), IconPoolDefault.STOP);
        }
        this.datenbankDialog.setCursor(new Cursor(0));
    }

    private void zeigeGefundeneSuchobjekte(String string, List<String> list) {
        SwingUtilities.invokeLater(() -> {
            this.datenbankDialog.getObjekteCombobox().removeAllItems();
            if (!list.isEmpty()) {
                if (string.equals(this.sprache.getString("db_m144"))) {
                    InternetSucheErgebnisDialog internetSucheErgebnisDialog = new InternetSucheErgebnisDialog(list);
                    internetSucheErgebnisDialog.setVisible(true);
                } else {
                    for (String string2 : list) {
                        this.datenbankDialog.getObjekteCombobox().addItem(string2);
                    }
                    this.datenbankDialog.showMessageOnMessageBar(this.sprache.getString("db_m147") + " " + list.size() + " " + this.sprache.getString("db_m148"), IconPoolDefault.INFO);
                }
            } else if (list.isEmpty() && string.equals(this.sprache.getString("db_m144")) && this.internetOffline) {
                this.datenbankDialog.showMessageOnMessageBar(this.sprache.getString("db_m450"), IconPoolDefault.INFO);
            } else {
                this.datenbankDialog.showMessageOnMessageBar(this.sprache.getString("db_m149"), IconPoolDefault.INFO);
            }
        });
    }

    private List<String> searchForUserInput(String string) {
        this.internetOffline = false;
        List<Object> list = new ArrayList(20);
        IObjektsucheDAO iObjektsucheDAO = this.injector.getInstance(IObjektsucheDAO.class);
        if (string.equals(this.sprache.getString("db_m142"))) {
            list = iObjektsucheDAO.sucheStringInDatenbank(this.datenbankDialog.getSuchenTextfeld().getText(), this.datenbankDialog.getExakteSucheChooser().isSelected());
        } else if (string.equals(this.sprache.getString("db_m143"))) {
            INotizenService iNotizenService = this.injector.getInstance(INotizenService.class);
            list = iNotizenService.findObjekteMitNotiz(this.datenbankDialog.getSuchenTextfeld().getText());
        } else if (string.equals(this.sprache.getString("db_m144"))) {
            int n;
            String string2 = this.datenbankDialog.getSuchenTextfeld().getText().replaceAll(" ", "+");
            String[] stringArray = new String[]{"https://simbad.u-strasbg.fr/simbad/sim-id?protocol=html&Ident=" + string2 + "&NbIdent=1&Radius=2&Radius.unit=arcmin&submit=submit+id", "https://seds.org/~spider/ngc/ngc.cgi?" + string2, "https://archive.stsci.edu/xcorr.php?target=" + string2 + "&max_records=10&action=Search&resolver=SIMBAD&missions[]=EUVE&missions[]=WFPC1&missions[]=WFPC2&missions[]=WFPC2_ASN&missions[]=FOC&missions[]=ACS-IMAGE&missions[]=UIT&missions[]=STIS-IMAGE&missions[]=GALEX&missions[]=XMM-OM&missions[]=NICMOS-IMAGE&missions[]=FUSE&missions[]=IMAPS&missions[]=BEFS&missions[]=TUES&missions[]=IUE&missions[]=COPERNICUS&missions[]=HUT&missions[]=WUPPE&missions[]=GHRS&missions[]=STIS-SPECTRUM&missions[]=ACS-SPECTRUM&missions[]=FOS&missions[]=HPOL&missions[]=NICMOS-SPECTRUM&missions[]=FGS&missions[]=HSP", "http://www.stellar-database.com/Scripts/search_star.exe?Name=" + string2, "https://nedwww.ipac.caltech.edu/cgi-bin/nph-objsearch?objname=" + string2 + "&extend=no&out_csys=Equatorial&out_equinox=J2000.0&obj_sort=RA+or+Longitude&of=pre_text&zv_breaker=30000.0&list_limit=5&img_stamp=YES"};
            String[] stringArray2 = new String[]{"https://simbad.u-strasbg.fr/simbad/", "https://seds.org", "https://archive.stsci.edu/", "http://www.stellar-database.com/", "https://nedwww.ipac.caltech.edu/"};
            ArrayList<InternetSuche> arrayList = new ArrayList<InternetSuche>(stringArray.length);
            for (n = 0; n < stringArray.length; ++n) {
                InternetSuche internetSuche = new InternetSuche(n, stringArray[n]);
                arrayList.add(internetSuche);
                internetSuche.start();
            }
            for (n = 0; n < arrayList.size(); ++n) {
                long l = System.currentTimeMillis();
                while (((InternetSuche)arrayList.get(n)).isAlive()) {
                    long l2 = System.currentTimeMillis() - l;
                    if (l2 <= 30000L) continue;
                    this.logger.warn("Suche auf " + stringArray2[n] + " wegen Zeitueberschreitung (>30s) abgebrochen.");
                    break;
                }
                if (((InternetSuche)arrayList.get(n)).istTrefferUndSeiteHeruntergeladen()) {
                    list.add(n + ";;;" + stringArray2[n] + ";;;" + stringArray[n]);
                    continue;
                }
                if (this.internetOffline) continue;
                this.internetOffline = ((InternetSuche)arrayList.get(n)).istKeineInternetverbindung();
            }
        }
        return list;
    }
}

