/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import com.google.inject.Injector;
import de.planetensuche.datenbank.DatenbankDialog;
import de.planetensuche.datenbank.DialogFactory;
import de.planetensuche.datenbank.guis.menuhilfe.HilfeDialog;
import de.planetensuche.datenbank.guis.menuhilfe.InfoDialog;
import de.planetensuche.datenbank.guis.menuhilfe.LexikonDialog;
import de.planetensuche.datenbank.guis.menuhilfe.NebelGalaxieSternhaufenKlassifikationDialog;
import de.planetensuche.datenbank.guis.menuhilfe.SpektraltypenUebersichtDialog;
import de.planetensuche.datenbank.guis.menuhilfe.VeraenderlicheSterneDialog;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;

public class DatenbankDialogHelpMenueControler {
    private final DatenbankDialog datenbankDialog;
    private final DialogFactory dialogFactory;
    private final AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor;

    public DatenbankDialogHelpMenueControler(DatenbankDialog datenbankDialog, Injector injector) {
        this.datenbankDialog = datenbankDialog;
        this.dialogFactory = new DialogFactory(injector);
        this.asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
    }

    public void addActionListeners() {
        this.datenbankDialog.getJmenueHilfe().addActionListener(actionEvent -> {
            HilfeDialog hilfeDialog = new HilfeDialog("");
            hilfeDialog.setVisible(true);
        });
        this.datenbankDialog.getJmenueLexikon().addActionListener(actionEvent -> {
            LexikonDialog lexikonDialog = new LexikonDialog();
            lexikonDialog.setVisible(true);
        });
        this.datenbankDialog.getJmenueInfo().addActionListener(actionEvent -> this.asyncLoadingScreenCallbackExecutor.execute(this.datenbankDialog, () -> {
            InfoDialog infoDialog = this.dialogFactory.createInfo();
            infoDialog.setVisible(true);
        }));
        this.datenbankDialog.getJmenueNebelklassen().addActionListener(actionEvent -> {
            NebelGalaxieSternhaufenKlassifikationDialog nebelGalaxieSternhaufenKlassifikationDialog = new NebelGalaxieSternhaufenKlassifikationDialog();
            nebelGalaxieSternhaufenKlassifikationDialog.showDialog();
        });
        this.datenbankDialog.getJmenueSpektraltypen().addActionListener(actionEvent -> {
            SpektraltypenUebersichtDialog spektraltypenUebersichtDialog = new SpektraltypenUebersichtDialog();
            spektraltypenUebersichtDialog.showDialog();
        });
        this.datenbankDialog.getjMenuVeraenderlicheSterne().addActionListener(actionEvent -> {
            VeraenderlicheSterneDialog veraenderlicheSterneDialog = new VeraenderlicheSterneDialog();
            veraenderlicheSterneDialog.showDialog();
        });
    }
}

