/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datenbank.api.IDatenbankDialog;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sternkarte.api.ISternkarte;
import de.planetensuche.sternkarte.api.SternkartenFabrik;
import de.planetensuche.sternkarte.api.SternkartenObjektPruefer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public final class DatenbankDialogKontextmenu {
    private final ISprachcontainer sprachcontainer;
    private final IDatenbankDialog datenbankDialog;
    private final ILogging logging;
    private final SternkartenFabrik sternkartenFabrik;
    private final SternkartenObjektPruefer sternkartenObjektPruefer;

    public DatenbankDialogKontextmenu(ISprachcontainer iSprachcontainer, KoordinatenFormat koordinatenFormat, IDatenbankDialog iDatenbankDialog) {
        this.sprachcontainer = iSprachcontainer;
        this.datenbankDialog = iDatenbankDialog;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.sternkartenObjektPruefer = new SternkartenObjektPruefer();
        this.sternkartenFabrik = new SternkartenFabrik(koordinatenFormat);
    }

    public JPopupMenu erzeugeKontextmenu(IPlanetensucheObjekt iPlanetensucheObjekt, String string) throws SQLException {
        JMenuItem jMenuItem;
        Iterator<JMenuItem> iterator;
        Object object;
        Object object2;
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string2 = iPlanetensucheObjekt.getUmkreistObjekt();
        if (!string2.isEmpty()) {
            object2 = this.erzeugePopupMenuItemSpringeZuElternobjekt(string2);
            jPopupMenu.add((JMenuItem)object2);
        }
        if (!(object2 = iPlanetensucheObjekt.getWirdUmkreistVonNamen()).isEmpty()) {
            object = this.erzeugePopupMenuItemSpringeZuKindobjekt((Set<String>)object2);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                jMenuItem = iterator.next();
                jPopupMenu.add(jMenuItem);
            }
        }
        if (!string.isEmpty()) {
            object = this.erzeugePopupMenuItemGotoDoppelsternkomponente(string);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                jMenuItem = iterator.next();
                jPopupMenu.add(jMenuItem);
            }
        }
        if (this.sternkartenObjektPruefer.isObjektInSternkarteAnzeigbar(iPlanetensucheObjekt)) {
            object = this.erzeugePopupMenuItemGotoStarMap(iPlanetensucheObjekt);
            jPopupMenu.add((JMenuItem)object);
        }
        return jPopupMenu;
    }

    private JMenuItem erzeugeMenuItemFuerAlleKindobjekte(final List<String> list) {
        JMenuItem jMenuItem = new JMenuItem(this.sprachcontainer.getString("db_m445") + " ...");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[list.size()];
                int n = 0;
                for (String string : list) {
                    objectArray[n] = string;
                    ++n;
                }
                Object object = JOptionPane.showInputDialog(null, DatenbankDialogKontextmenu.this.sprachcontainer.getString("db_m19"), DatenbankDialogKontextmenu.this.sprachcontainer.getString("db_m20"), 3, null, objectArray, objectArray[0]);
                if (object != null) {
                    String string;
                    string = object.toString();
                    try {
                        DatenbankDialogKontextmenu.this.datenbankDialog.springeZuObjekt(string);
                    }
                    catch (SQLException sQLException) {
                        DatenbankDialogKontextmenu.this.logging.error(sQLException);
                    }
                }
            }
        });
        return jMenuItem;
    }

    private JMenuItem erzeugeMenuItemFurEinKindobjekt(String string) {
        JMenuItem jMenuItem = new JMenuItem(this.sprachcontainer.getString("db_m445") + " " + string);
        jMenuItem.addActionListener(actionEvent -> {
            try {
                this.datenbankDialog.springeZuObjekt(string);
            }
            catch (SQLException sQLException) {
                this.logging.error(sQLException);
            }
        });
        return jMenuItem;
    }

    private List<JMenuItem> erzeugePopupMenuItemGotoDoppelsternkomponente(String string) {
        String[] stringArray = string.split(",");
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>(stringArray.length);
        for (String string2 : stringArray) {
            JMenuItem jMenuItem = new JMenuItem(this.sprachcontainer.getString("db_m448") + " " + string2.trim());
            jMenuItem.addActionListener(actionEvent -> {
                try {
                    this.datenbankDialog.springeZuObjekt(string2.trim());
                }
                catch (SQLException sQLException) {
                    this.logging.error(sQLException);
                }
            });
            arrayList.add(jMenuItem);
        }
        return arrayList;
    }

    private JMenuItem erzeugePopupMenuItemGotoStarMap(IPlanetensucheObjekt iPlanetensucheObjekt) {
        JMenuItem jMenuItem = new JMenuItem(this.sprachcontainer.getString("db_m446"));
        jMenuItem.addActionListener(actionEvent -> {
            try {
                String string = iPlanetensucheObjekt.getObjektNamen().get(0);
                ISternkarte iSternkarte = this.sternkartenFabrik.getInstance(string);
                iSternkarte.show();
            }
            catch (SQLException sQLException) {
                this.logging.error(sQLException);
            }
        });
        return jMenuItem;
    }

    private JMenuItem erzeugePopupMenuItemSpringeZuElternobjekt(String string) {
        JMenuItem jMenuItem = new JMenuItem(this.sprachcontainer.getString("db_m444") + " " + string);
        jMenuItem.addActionListener(actionEvent -> {
            try {
                this.datenbankDialog.springeZuObjekt(string);
            }
            catch (SQLException sQLException) {
                this.logging.error(sQLException);
            }
        });
        return jMenuItem;
    }

    private List<JMenuItem> erzeugePopupMenuItemSpringeZuKindobjekt(Set<String> set) {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>(set.size());
        ArrayList<String> arrayList2 = new ArrayList<String>(set);
        Collections.sort(arrayList2);
        if (arrayList2.size() < 10) {
            for (String string : arrayList2) {
                JMenuItem jMenuItem = this.erzeugeMenuItemFurEinKindobjekt(string);
                arrayList.add(jMenuItem);
            }
        } else {
            JMenuItem jMenuItem = this.erzeugeMenuItemFuerAlleKindobjekte(arrayList2);
            arrayList.add(jMenuItem);
        }
        return arrayList;
    }
}

