/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datamodel.formeln.DensityCalculator;
import de.planetensuche.datamodel.formeln.EarthSimilarityIndexExoplanetCalculator;
import de.planetensuche.datamodel.formeln.EarthSimilarityIndexSolSystemCalculator;
import de.planetensuche.datamodel.formeln.EscapeVelocityCalculator;
import de.planetensuche.datamodel.helfer.HabitateZoneRechner;
import de.planetensuche.datamodel.impl.ILeuchtkraftklassenService;
import de.planetensuche.datamodel.impl.KoordinatenKonverter;
import de.planetensuche.datamodel.impl.PsObjektService;
import de.planetensuche.datenbank.ConstellationForObjectService;
import de.planetensuche.datenbank.DatenbankZeigeObjektEntdecker;
import de.planetensuche.datenbank.DatenbankZeigeObjektMasseDurchmesser;
import de.planetensuche.datenbank.PlanetTypeDetectorService;
import de.planetensuche.datenbank.dbmodel.api.IBerechnungDurchschnittDAO;
import de.planetensuche.datenbank.dbmodel.notizen.api.INotizenService;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IHabitableZoneRepository;
import de.planetensuche.datenbankkern.api.repos.IObjekttypenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Cursor;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.JTextArea;
import org.apache.commons.lang3.tuple.Pair;

public final class DatenbankZeigeObjekt {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final ISprachcontainer i18n;
    private final KoordinatenFormat koordinatenFormat;
    private final IBerechnungDurchschnittDAO berechnungDurchschnittDAO;
    private final INotizenService notizenService;
    private final IObjekttypenRepository objekttypenRepository;
    private final IPlanetensucheObjektRepository planetensucheRepo;
    private final IHabitableZoneRepository hzRepo;
    private final ILeuchtkraftklassenService leuchtkraftklassenService;
    private final ConstellationForObjectService constellationService;
    private final EarthSimilarityIndexExoplanetCalculator esiExoplanetCalculator;
    private final EarthSimilarityIndexSolSystemCalculator esiSolCalculator;
    private final EscapeVelocityCalculator escapeVelocityCalculator;
    private final HabitateZoneRechner hzCalculator;
    private final PlanetTypeDetectorService planetTypeDetectionService;
    private final DatenbankZeigeObjektMasseDurchmesser zeigeMasseDurchmesserInfos;
    private final DatenbankZeigeObjektEntdecker zeigeEntdeckerInfos;

    protected DatenbankZeigeObjekt(ISprachcontainer iSprachcontainer, KoordinatenFormat koordinatenFormat, SternbildSprache sternbildSprache, IBerechnungDurchschnittDAO iBerechnungDurchschnittDAO, INotizenService iNotizenService, IObjekttypenRepository iObjekttypenRepository, ILeuchtkraftklassenService iLeuchtkraftklassenService, IDatenbankService iDatenbankService, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IHabitableZoneRepository iHabitableZoneRepository, PlanetTypeDetectorService planetTypeDetectorService, ISternbilderRepository iSternbilderRepository) {
        this.i18n = iSprachcontainer;
        this.koordinatenFormat = koordinatenFormat;
        this.berechnungDurchschnittDAO = iBerechnungDurchschnittDAO;
        this.notizenService = iNotizenService;
        this.objekttypenRepository = iObjekttypenRepository;
        this.planetensucheRepo = iPlanetensucheObjektRepository;
        this.hzRepo = iHabitableZoneRepository;
        this.leuchtkraftklassenService = iLeuchtkraftklassenService;
        this.constellationService = new ConstellationForObjectService(sternbildSprache, iPlanetensucheObjektRepository, iSternbilderRepository);
        this.esiExoplanetCalculator = new EarthSimilarityIndexExoplanetCalculator();
        this.esiSolCalculator = new EarthSimilarityIndexSolSystemCalculator();
        this.escapeVelocityCalculator = new EscapeVelocityCalculator();
        this.hzCalculator = new HabitateZoneRechner();
        this.planetTypeDetectionService = planetTypeDetectorService;
        this.zeigeMasseDurchmesserInfos = new DatenbankZeigeObjektMasseDurchmesser();
        this.zeigeEntdeckerInfos = new DatenbankZeigeObjektEntdecker(iSprachcontainer);
    }

    public void zeigeObjekt(String string, String string2, IPlanetensucheObjekt iPlanetensucheObjekt, String string3, JTextArea jTextArea) throws SQLException, IOException {
        double d;
        Object object;
        jTextArea.setText("");
        jTextArea.append(this.i18n.getString("db_m70") + ": " + this.i18n.getUebersetzungFuerAktuelleSprache(string2) + "\n");
        String string4 = this.i18n.getUebersetzungFuerAktuelleSprache(iPlanetensucheObjekt.getObjekttyp());
        String string5 = this.i18n.getString("db_m71");
        if (ObjektKategorie.STERNE.equals((Object)iPlanetensucheObjekt.getCategory()) || ObjektKategorie.BR_ZWERGE.equals((Object)iPlanetensucheObjekt.getCategory())) {
            if (iPlanetensucheObjekt.isSpektralklasseUnbekannt() && iPlanetensucheObjekt.isLeuchtkraftklasseUnbekannt()) {
                jTextArea.append(string5 + ": " + string4 + "\n\n");
            } else if (iPlanetensucheObjekt.isSpektralklasseUnbekannt()) {
                jTextArea.append(string5 + ": " + string4 + " (" + iPlanetensucheObjekt.getLeuchtkraftklasse() + ")\n\n");
            } else if (iPlanetensucheObjekt.isLeuchtkraftklasseUnbekannt()) {
                if (ObjektKategorie.STERNE.getKategorienName().equals(string2)) {
                    object = iPlanetensucheObjekt.getSpektralklasse() + iPlanetensucheObjekt.getSpektralklasse2();
                    String string6 = this.leuchtkraftklassenService.predictLk((String)object, iPlanetensucheObjekt.getAbsoluteHelligkeit());
                    if (string6 != null && !string6.isEmpty()) {
                        jTextArea.append(string5 + ": " + string4 + " (" + iPlanetensucheObjekt.getSpektralklasse() + iPlanetensucheObjekt.getSpektralklasse2() + " - " + this.i18n.getString("db_m455") + ": " + string6 + ")\n\n");
                    } else {
                        jTextArea.append(string5 + ": " + string4 + " (" + iPlanetensucheObjekt.getSpektralklasse() + iPlanetensucheObjekt.getSpektralklasse2() + ")\n\n");
                    }
                } else {
                    jTextArea.append(string5 + ": " + string4 + " (" + iPlanetensucheObjekt.getSpektralklasse() + iPlanetensucheObjekt.getSpektralklasse2() + ")\n\n");
                }
            } else {
                jTextArea.append(string5 + ": " + string4 + " (" + iPlanetensucheObjekt.getSpektralklasse() + iPlanetensucheObjekt.getSpektralklasse2() + " " + iPlanetensucheObjekt.getLeuchtkraftklasse() + ")\n\n");
            }
        } else if (ObjektKategorie.STERNHAUFEN.getKategorienName().equals(string2)) {
            jTextArea.append(string5 + ": " + string4 + "(" + this.i18n.getUebersetzungFuerAktuelleSprache(iPlanetensucheObjekt.getSternhaufenform()) + ")\n");
        } else if (ObjektKategorie.GALAXIE_NEBEL.getKategorienName().equals(string2)) {
            if ("Galaxie".equals(iPlanetensucheObjekt.getObjekttyp())) {
                jTextArea.append(string5 + ": " + string4 + "\n");
                jTextArea.append(this.i18n.getString("db_m72") + ": " + this.i18n.getUebersetzungFuerAktuelleSprache(iPlanetensucheObjekt.getGalaxienart()) + " (" + this.i18n.getUebersetzungFuerAktuelleSprache(iPlanetensucheObjekt.getGalaxienform()) + ")\n");
            } else {
                jTextArea.append(string5 + ": " + string4 + "(" + this.i18n.getUebersetzungFuerAktuelleSprache(iPlanetensucheObjekt.getNebelform()) + ")\n");
            }
        } else if (ObjektKategorie.ASTEROIDEN.getKategorienName().equals(string2)) {
            jTextArea.append(string5 + ": " + string4 + " " + this.i18n.getString("db_m73") + " " + iPlanetensucheObjekt.getSpektralklasse() + "-" + this.i18n.getString("db_m74") + "\n\n");
        } else if (ObjektKategorie.PLANETEN.getKategorienName().equals(string2)) {
            jTextArea.append(string5 + ": " + string4 + "\n");
            if (!iPlanetensucheObjekt.isDurchmesserUnbekannt()) {
                object = this.planetTypeDetectionService.getType(iPlanetensucheObjekt.getDurchmesser() * 11.194418312950768);
                jTextArea.append(this.i18n.getString("db_gui179") + ": " + (String)object + "\n\n");
            }
        } else {
            jTextArea.append(string5 + ": " + string4 + "\n\n");
        }
        jTextArea.append("\n");
        this.addConstellationInfo(iPlanetensucheObjekt, string2, jTextArea, string);
        this.addDistanceAndParentObject(iPlanetensucheObjekt, string2, jTextArea, string);
        jTextArea.append("\n");
        this.zeigeMasseDurchmesserInfos.addDurchmesser(iPlanetensucheObjekt, string2, jTextArea);
        this.zeigeMasseDurchmesserInfos.addMasse(iPlanetensucheObjekt, string2, jTextArea);
        if (!iPlanetensucheObjekt.isUmlaufszeitUnbekannt()) {
            object = this.i18n.getString("db_m104") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getUmlaufszeit()) + " " + this.i18n.getString("db_m105");
            if (iPlanetensucheObjekt.getUmlaufszeit() > 365.0) {
                object = (String)object + " (" + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getUmlaufszeit() / 365.25) + " " + this.i18n.getString("db_m498") + ")";
            }
            jTextArea.append((String)object + "\n");
        }
        this.berechneDichteUndGravitationsbeschleunigung(iPlanetensucheObjekt, jTextArea);
        if (!iPlanetensucheObjekt.isScheinbareHelligkeitUnbekannt()) {
            if (string2.equals(ObjektKategorie.MONDE.getKategorienName())) {
                jTextArea.append(this.i18n.getString("db_m107") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getScheinbareHelligkeit()) + " mag\n");
            } else {
                jTextArea.append(this.i18n.getString("db_m108") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getScheinbareHelligkeit()) + " mag\n");
            }
        }
        if ((iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.STERNHAUFEN) || iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.GALAXIE_NEBEL)) && (d = this.berechnungDurchschnittDAO.berechneDurchschnittScheinbareHelligkeit(iPlanetensucheObjekt.getWirdUmkreistVonIDs())) > -100.0) {
            jTextArea.append(this.i18n.getString("db_m411") + ": " + this.i18n.toLocalisedDouble(d) + " mag\n");
        }
        if (!iPlanetensucheObjekt.isFlaechenhelligkeitUnbekannt()) {
            jTextArea.append(this.i18n.getString("db_m109") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getFlaechenhelligkeit()) + " mag\n");
        }
        if (!iPlanetensucheObjekt.isAbsoluteHelligkeitUnbekannt()) {
            jTextArea.append(this.i18n.getString("db_m110") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getAbsoluteHelligkeit()) + " mag\n");
        }
        if (!iPlanetensucheObjekt.isExzentritaetUnbekannt()) {
            jTextArea.append(this.i18n.getString("db_m111") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getExzentritaet()) + "\n");
        }
        if (!iPlanetensucheObjekt.isTemperaturUnbekannt()) {
            if (string2.equals(ObjektKategorie.STERNE.getKategorienName()) || string2.equals(ObjektKategorie.BR_ZWERGE.getKategorienName())) {
                jTextArea.append(this.i18n.getString("db_m112") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getTemperatur()) + " " + this.i18n.getString("db_m114") + "\n");
            } else {
                double d2 = iPlanetensucheObjekt.getTemperatur();
                double d3 = d2 - 273.15;
                jTextArea.append(this.i18n.getString("db_m113") + ": " + this.i18n.toLocalisedDouble(d2) + " " + this.i18n.getString("db_m114") + " (" + this.i18n.toLocalisedDouble(d3) + " \u00b0C)\n");
            }
        }
        if (!iPlanetensucheObjekt.isAlbedoUnbekannt()) {
            jTextArea.append(this.i18n.getString("db_m115") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getAlbedo()) + "\n");
        }
        this.addGeschwindigkeit(iPlanetensucheObjekt, jTextArea);
        this.addBV(iPlanetensucheObjekt, jTextArea);
        this.addMetallizitaet(iPlanetensucheObjekt, jTextArea);
        if (!iPlanetensucheObjekt.isSternentstehungUnbekannt()) {
            jTextArea.append(this.i18n.getString("db_m122") + ": " + this.i18n.toLocalisedInt(iPlanetensucheObjekt.getSternentstehung()) + "\n");
        }
        if (!iPlanetensucheObjekt.isRotverschiebungUnbekannt()) {
            jTextArea.append(this.i18n.getString("db_m123") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getRotverschiebung()) + "\n");
        }
        this.addObjektalter(iPlanetensucheObjekt, jTextArea);
        this.addGaiaData(iPlanetensucheObjekt, jTextArea);
        if (string2.equals(ObjektKategorie.PLANETEN.getKategorienName())) {
            this.addEscapeVelocity(iPlanetensucheObjekt, jTextArea);
            this.addHabitableZoneInfo(iPlanetensucheObjekt, jTextArea);
            this.addEarthSimilarityIndex(iPlanetensucheObjekt, jTextArea);
        }
        this.zeigeEntdeckerInfos.addEntdeckerInfo(iPlanetensucheObjekt, jTextArea, string2);
        jTextArea.append("\n");
        this.addNamenUndKatalogbezeichnungen(iPlanetensucheObjekt, jTextArea);
        String[] stringArray = null;
        if (iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.STERNE) && !string3.isEmpty()) {
            jTextArea.append("\n" + this.i18n.getString("db_m130") + ":\n");
            jTextArea.append(string3);
            jTextArea.append("\n");
            stringArray = string3.split(",");
        }
        int n = iPlanetensucheObjekt.getWirdUmkreistVonNamen().size();
        if (!iPlanetensucheObjekt.getUmkreistObjekt().isEmpty()) {
            ++n;
        }
        if (stringArray != null) {
            n += stringArray.length;
        }
        Object[] objectArray = new Object[n];
        if (n == 0) {
            jTextArea.setCursor(new Cursor(0));
        } else {
            jTextArea.setCursor(new Cursor(12));
        }
        int n2 = 0;
        if (stringArray != null) {
            for (String string7 : stringArray) {
                objectArray[n2] = string7.trim();
                ++n2;
            }
        }
        if (!iPlanetensucheObjekt.getUmkreistObjekt().isEmpty()) {
            objectArray[objectArray.length - 1] = iPlanetensucheObjekt.getUmkreistObjekt();
        }
        this.addWirdUmkreistVon(iPlanetensucheObjekt, string2, objectArray, n2, jTextArea);
        this.addNotizen(iPlanetensucheObjekt, jTextArea);
        jTextArea.append("\n\n");
        jTextArea.append(this.i18n.getString("db_m138") + ": " + iPlanetensucheObjekt.getAutor() + "\n");
        jTextArea.append(this.i18n.getString("db_m139", iPlanetensucheObjekt.getStamp()) + "\n");
        jTextArea.setCaretPosition(0);
    }

    private void addDistanceAndParentObject(IPlanetensucheObjekt iPlanetensucheObjekt, String string, JTextArea jTextArea, String string2) {
        if (!iPlanetensucheObjekt.isEntfernungUnbekannt()) {
            if (ObjektKategorie.PLANETEN.getKategorienName().equals(string)) {
                if ("".equals(iPlanetensucheObjekt.getUmkreistObjekt())) {
                    jTextArea.append(this.i18n.getString("db_m82") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung()) + " " + this.i18n.getString("db_m83") + "\n");
                } else {
                    jTextArea.append(string2 + " " + this.i18n.getString("db_m84") + " " + iPlanetensucheObjekt.getUmkreistObjekt() + "\n" + this.i18n.getString("db_m85") + " " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung()) + " " + this.i18n.getString("db_m83") + " (" + this.i18n.getString("db_m86") + ").\n");
                }
                this.appendExzentritaet(iPlanetensucheObjekt, jTextArea);
            } else if (string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName())) {
                if ("".equals(iPlanetensucheObjekt.getUmkreistObjekt())) {
                    jTextArea.append(this.i18n.getString("db_m89") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung()) + " ly\n");
                } else {
                    jTextArea.append(string2 + " " + this.i18n.getString("db_m90") + " " + iPlanetensucheObjekt.getUmkreistObjekt() + "\n" + this.i18n.getString("db_m85") + " " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung()) + " " + this.i18n.getString("db_m83") + " (" + this.i18n.getString("db_m86") + ").\n");
                    this.appendExzentritaet(iPlanetensucheObjekt, jTextArea);
                }
            } else if (string.equals(ObjektKategorie.MONDE.getKategorienName())) {
                if ("".equals(iPlanetensucheObjekt.getUmkreistObjekt())) {
                    jTextArea.append(this.i18n.getString("db_m91") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung()) + " km\n");
                } else {
                    jTextArea.append(string2 + " " + this.i18n.getString("db_m92") + " " + iPlanetensucheObjekt.getUmkreistObjekt() + "\n" + this.i18n.getString("db_m85") + " " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung()) + " km.\n");
                }
                if (!iPlanetensucheObjekt.isExzentritaetUnbekannt()) {
                    double d = iPlanetensucheObjekt.getEntfernung() * iPlanetensucheObjekt.getExzentritaet();
                    jTextArea.append("\n" + this.i18n.getString("db_m93") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung() + d) + " km\n");
                    jTextArea.append(this.i18n.getString("db_m94") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung() - d) + " km\n");
                }
            } else if (string.equals(ObjektKategorie.ASTEROIDEN.getKategorienName()) || string.equals(ObjektKategorie.KOMETEN.getKategorienName())) {
                jTextArea.append(string2 + " " + this.i18n.getString("db_m95").replaceAll("<html>", "").replaceAll("</html>", "").replaceAll("<br>", "\n") + " " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung()) + " " + this.i18n.getString("db_m83") + " (" + this.i18n.getString("db_m86") + ").\n");
                this.appendExzentritaet(iPlanetensucheObjekt, jTextArea);
            } else {
                jTextArea.append(this.i18n.getString("db_m96") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung()) + " ly\n");
            }
        }
    }

    private void addConstellationInfo(IPlanetensucheObjekt iPlanetensucheObjekt, String string, JTextArea jTextArea, String string2) throws SQLException, IOException {
        String string3 = this.constellationService.getSternbildbezeichnung(iPlanetensucheObjekt);
        KoordinatenKonverter koordinatenKonverter = new KoordinatenKonverter(this.i18n);
        koordinatenKonverter.setRa(iPlanetensucheObjekt.getRA());
        koordinatenKonverter.setDecl(iPlanetensucheObjekt.getDECL());
        String string4 = koordinatenKonverter.toString(this.koordinatenFormat, true);
        String string5 = koordinatenKonverter.toString(this.koordinatenFormat, false);
        String string6 = this.i18n.getString("db_m78");
        String string7 = this.i18n.getString("db_m80");
        String string8 = this.i18n.getString("db_m76");
        if (ObjektKategorie.STERNE.getKategorienName().equals(string) || ObjektKategorie.GALAXIE_NEBEL.getKategorienName().equals(string) || ObjektKategorie.STERNHAUFEN.getKategorienName().equals(string) || ObjektKategorie.GALAXIENHAUFEN.getKategorienName().equals(string) || ObjektKategorie.SONSTIGES.getKategorienName().equals(string)) {
            Object object = "";
            if (!"".equals(iPlanetensucheObjekt.getUmkreistObjekt())) {
                String string9 = this.objekttypenRepository.getObjekttypFuerObjekt(iPlanetensucheObjekt.getUmkreistObjekt());
                object = "\n(" + this.i18n.getString("db_m75") + " " + string9 + " '" + iPlanetensucheObjekt.getUmkreistObjekt() + "')";
            }
            if (!iPlanetensucheObjekt.isKoordinatenUnbekannt()) {
                if ("unbekannt".equals(string3) || "unknown".equals(string3)) {
                    jTextArea.append(string2 + " " + string8 + " " + string4 + "\n" + string6 + " " + string5 + (String)object + ".\n\n");
                } else {
                    jTextArea.append(string2 + " " + string7 + " " + string3 + (String)object + ",\n" + this.i18n.getString("db_m81") + " " + string4 + "\n" + string6 + " " + string5 + ".\n\n");
                }
            } else {
                jTextArea.append(string2 + " " + string7 + " " + string3 + (String)object + ".\n\n");
            }
        } else if (ObjektKategorie.BR_ZWERGE.getKategorienName().equals(string)) {
            if (!iPlanetensucheObjekt.isKoordinatenUnbekannt()) {
                if ("unbekannt".equals(string3) || "unknown".equals(string3)) {
                    jTextArea.append(string2 + " " + string8 + " " + string4 + "\n" + string6 + " " + string5 + ".\n\n");
                } else {
                    jTextArea.append(string2 + " " + string7 + " " + string3 + ",\n" + this.i18n.getString("db_m81") + " " + string4 + "\n" + string6 + " " + string5 + ".\n\n");
                }
            } else {
                jTextArea.append(string2 + " " + string7 + " " + string3 + ".\n\n");
            }
            jTextArea.append("\n\n");
        }
    }

    private void addGeschwindigkeit(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) throws IOException, SQLException {
        double d;
        if (iPlanetensucheObjekt.getKategorie().equals(ObjektKategorie.MONDE.getKategorienName()) && iPlanetensucheObjekt.isGeschwindigkeitUnbekannt()) {
            PsObjektService psObjektService = new PsObjektService(false);
            psObjektService.starteBerechnung(iPlanetensucheObjekt);
        }
        if (!iPlanetensucheObjekt.isGeschwindigkeitUnbekannt()) {
            if (iPlanetensucheObjekt.getKategorie().equals(ObjektKategorie.STERNE.getKategorienName()) || iPlanetensucheObjekt.getKategorie().equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName())) {
                jTextArea.append(this.i18n.getString("db_m116") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getGeschwindigkeit()) + " km/s\n");
            } else {
                jTextArea.append(this.i18n.getString("db_m117") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getGeschwindigkeit()) + " km/s\n");
            }
        }
        if ((iPlanetensucheObjekt.getKategorie().equals(ObjektKategorie.STERNHAUFEN.getKategorienName()) || iPlanetensucheObjekt.getKategorie().equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName())) && (d = this.berechnungDurchschnittDAO.berechneDurchschnittRadialgeschwindigkeit(iPlanetensucheObjekt.getWirdUmkreistVonIDs())) != -100.0) {
            jTextArea.append(this.i18n.getString("db_m118") + ": " + this.i18n.toLocalisedDouble(d) + " km/s\n");
        }
    }

    private void addMetallizitaet(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        double d;
        if (!iPlanetensucheObjekt.isMetallizitaetUnbekannt()) {
            jTextArea.append(this.i18n.getString("db_m120") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getMetallizitaet()) + " Fe/H\n");
        }
        if ((iPlanetensucheObjekt.getKategorie().equals(ObjektKategorie.STERNHAUFEN.getKategorienName()) || iPlanetensucheObjekt.getKategorie().equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName())) && (d = this.berechnungDurchschnittDAO.berechneDurchschnittMetal(iPlanetensucheObjekt.getWirdUmkreistVonIDs())) != -100.0) {
            jTextArea.append(this.i18n.getString("db_m121") + ": " + this.i18n.toLocalisedDouble(d) + " Fe/H\n");
        }
    }

    private void addBV(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        double d;
        if (!iPlanetensucheObjekt.isBVUnbekannt()) {
            jTextArea.append("B-V: " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getBV()) + "\n");
        }
        if ((iPlanetensucheObjekt.getKategorie().equals(ObjektKategorie.STERNHAUFEN.getKategorienName()) || iPlanetensucheObjekt.getKategorie().equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName())) && (d = this.berechnungDurchschnittDAO.berechneDurchschnittBV(iPlanetensucheObjekt.getWirdUmkreistVonIDs())) != -100.0) {
            jTextArea.append(this.i18n.getString("db_m119") + ": " + this.i18n.toLocalisedDouble(d) + "\n");
        }
    }

    private void addObjektalter(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        double d;
        if (!iPlanetensucheObjekt.isAlterInMrdJahreUnbekannt()) {
            jTextArea.append(this.i18n.getString("db_m124") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getAlterInMrdJahre()) + " " + this.i18n.getString("db_m125") + "\n");
        }
        if ((iPlanetensucheObjekt.getKategorie().equals(ObjektKategorie.STERNHAUFEN.getKategorienName()) || iPlanetensucheObjekt.getKategorie().equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName())) && (d = this.berechnungDurchschnittDAO.berechneDurchschnittsAlter(iPlanetensucheObjekt.getWirdUmkreistVonIDs())) > 0.0) {
            jTextArea.append(this.i18n.getString("db_m410") + ": " + this.i18n.toLocalisedDouble(d) + " " + this.i18n.getString("db_m125") + "\n");
        }
    }

    private void berechneDichteUndGravitationsbeschleunigung(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        if (!iPlanetensucheObjekt.isDurchmesserUnbekannt() && !iPlanetensucheObjekt.isMasseUnbekannt()) {
            double d = this.getMasseInKg(iPlanetensucheObjekt.getKategorie(), iPlanetensucheObjekt.getMasse());
            double d2 = this.getDurchmesserInMeter(iPlanetensucheObjekt.getKategorie(), iPlanetensucheObjekt.getDurchmesser());
            if (d > 0.0 && d2 > 0.0) {
                double d3;
                Optional<Double> optional = DensityCalculator.calcDensityInGcmCubic(iPlanetensucheObjekt);
                if (optional.isPresent()) {
                    d3 = (double)Math.round(optional.get() * 10000.0) / 10000.0;
                    jTextArea.append(this.i18n.getString("db_m106") + ": " + this.i18n.toLocalisedDouble(d3) + " g/cm\u00b3\n");
                }
                if ((d3 = this.getGravitationsbeschleunigung(d, d2)) > 0.0) {
                    jTextArea.append(this.i18n.getString("db_m440") + ": " + this.i18n.toLocalisedDouble(d3) + " m/s\u00b2\n");
                }
            }
        }
    }

    private void addNamenUndKatalogbezeichnungen(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        jTextArea.append("\n" + this.i18n.getString("db_m129") + ":\n");
        List<String> list = iPlanetensucheObjekt.getObjektNamen();
        for (String string : list) {
            jTextArea.append(string + "\n");
        }
        jTextArea.append("\n");
    }

    private void addNotizen(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) throws IOException {
        if (iPlanetensucheObjekt.getNotiz().isEmpty()) {
            return;
        }
        String string = this.notizenService.getByDatenid(iPlanetensucheObjekt.getDatenid());
        if (string != null && !string.isEmpty()) {
            jTextArea.append("\n\n" + this.i18n.getString("db_m137") + ":\n");
            jTextArea.append(string.trim().replaceAll("<br>", "\n") + "\n");
        } else {
            this.logger.debug("keine Notiz f\u00fcr '" + iPlanetensucheObjekt.getObjektNamen().get(0) + "' gefunden");
        }
    }

    private void appendExzentritaet(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        if (!iPlanetensucheObjekt.isExzentritaetUnbekannt()) {
            double d = iPlanetensucheObjekt.getEntfernung() * iPlanetensucheObjekt.getExzentritaet();
            jTextArea.append("\n" + this.i18n.getString("db_m87") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung() + d) + " " + this.i18n.getString("db_m83") + "\n");
            jTextArea.append(this.i18n.getString("db_m88") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getEntfernung() - d) + " " + this.i18n.getString("db_m83") + "\n");
        }
    }

    private void addWirdUmkreistVon(IPlanetensucheObjekt iPlanetensucheObjekt, String string, Object[] objectArray, int n, JTextArea jTextArea) {
        if (!iPlanetensucheObjekt.getWirdUmkreistVonNamen().isEmpty()) {
            if (string.equals(ObjektKategorie.STERNHAUFEN.getKategorienName()) || string.equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName()) || string.equals(ObjektKategorie.GALAXIENHAUFEN.getKategorienName())) {
                jTextArea.append("\n\n" + this.i18n.getString("db_m414") + " " + iPlanetensucheObjekt.getObjektNamen().get(0) + ": " + iPlanetensucheObjekt.getWirdUmkreistVonIDs().size());
            } else {
                jTextArea.append("\n\n" + this.i18n.getString("db_m415") + " " + iPlanetensucheObjekt.getObjektNamen().get(0) + ": " + iPlanetensucheObjekt.getWirdUmkreistVonIDs().size());
            }
            if (string.equals(ObjektKategorie.STERNE.getKategorienName())) {
                jTextArea.append("\n\n" + this.i18n.getString("db_m131") + ":\n");
            } else if (string.equals(ObjektKategorie.PLANETEN.getKategorienName())) {
                jTextArea.append("\n\n" + this.i18n.getString("db_m132") + ":\n");
            } else if (string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName())) {
                jTextArea.append("\n\n" + this.i18n.getString("db_m133") + ":\n");
            } else if (string.equals(ObjektKategorie.GALAXIENHAUFEN.getKategorienName())) {
                jTextArea.append("\n\n" + this.i18n.getString("db_m134") + ":\n");
            } else if (string.equals(ObjektKategorie.STERNHAUFEN.getKategorienName())) {
                jTextArea.append("\n\n" + this.i18n.getString("db_m135") + ":\n");
            } else {
                jTextArea.append("\n\n" + this.i18n.getString("db_m136") + ":\n");
            }
            List<String> list = PsObjektService.getWirdUmkreistVonNamen(jTextArea.getWidth(), new ArrayList<String>(iPlanetensucheObjekt.getWirdUmkreistVonNamen()));
            for (String object : list) {
                jTextArea.append(object + "\n");
            }
            int n2 = n;
            for (String string2 : iPlanetensucheObjekt.getWirdUmkreistVonNamen()) {
                objectArray[n2] = string2;
                ++n2;
            }
        }
    }

    private void addEarthSimilarityIndex(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        if (iPlanetensucheObjekt.getUmkreistDatenId() != null && !iPlanetensucheObjekt.isDurchmesserUnbekannt()) {
            try {
                Optional<Object> optional = Optional.empty();
                IPlanetensucheObjekt iPlanetensucheObjekt2 = this.planetensucheRepo.read(iPlanetensucheObjekt.getUmkreistDatenId());
                if (iPlanetensucheObjekt.getObjektNamen().contains("Erde")) {
                    optional = Optional.of(1.0);
                } else if (iPlanetensucheObjekt2.getObjektNamen().contains("Sonne")) {
                    if (!iPlanetensucheObjekt.isMasseUnbekannt() && !iPlanetensucheObjekt.isTemperaturUnbekannt()) {
                        optional = this.esiSolCalculator.calcESI(iPlanetensucheObjekt.getDurchmesser(), iPlanetensucheObjekt.getMasse(), iPlanetensucheObjekt.getTemperatur());
                    }
                } else {
                    optional = this.esiExoplanetCalculator.calcESI(iPlanetensucheObjekt2, iPlanetensucheObjekt);
                }
                if (optional.isPresent()) {
                    jTextArea.append(this.i18n.getString("db_m494") + ": " + this.i18n.toLocalisedDouble((Double)optional.get()) + "\n");
                }
            }
            catch (IllegalArgumentException | SQLException exception) {
                this.logger.error("fail to read parent object '" + iPlanetensucheObjekt.getUmkreistObjekt() + "' for planet " + iPlanetensucheObjekt.getObjektNamen().get(0), exception);
            }
        }
    }

    private void addHabitableZoneInfo(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        Optional<Pair<Double, Double>> optional;
        if (!(iPlanetensucheObjekt.getUmkreistDatenId() == null || iPlanetensucheObjekt.isEntfernungUnbekannt() && iPlanetensucheObjekt.isUmlaufszeitUnbekannt() || !(optional = this.hzRepo.getInnerAndOuterHZ(iPlanetensucheObjekt.getUmkreistDatenId())).isPresent())) {
            try {
                boolean bl = this.hzCalculator.isPlanetInHz(optional.get().getLeft(), optional.get().getRight(), iPlanetensucheObjekt.getEntfernung(), iPlanetensucheObjekt.getUmlaufszeit());
                if (bl) {
                    jTextArea.append(this.i18n.getString("db_m495", this.i18n.toLocalisedDouble(optional.get().getLeft()), this.i18n.toLocalisedDouble(optional.get().getRight())) + "\n");
                } else {
                    jTextArea.append(this.i18n.getString("db_m496", this.i18n.toLocalisedDouble(optional.get().getLeft()), this.i18n.toLocalisedDouble(optional.get().getRight())) + "\n");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.warn("problem with HZ of star '" + iPlanetensucheObjekt.getUmkreistObjekt() + "'", illegalArgumentException);
            }
        }
    }

    protected double getDurchmesserInMeter(String string, double d) {
        if (string.equals(ObjektKategorie.STERNE.getKategorienName())) {
            return d * 696392.0 * 2.0 * 1000.0;
        }
        if (string.equals(ObjektKategorie.PLANETEN.getKategorienName()) || string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName())) {
            return d * 142984.0 * 1000.0;
        }
        if (string.equals(ObjektKategorie.ASTEROIDEN.getKategorienName()) || string.equals(ObjektKategorie.MONDE.getKategorienName())) {
            return d * 1000.0;
        }
        return 0.0;
    }

    protected double getMasseInKg(String string, double d) {
        if (string.equals(ObjektKategorie.STERNE.getKategorienName())) {
            return d * 1.991E30;
        }
        if (string.equals(ObjektKategorie.PLANETEN.getKategorienName()) || string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName())) {
            return d * 1.898E27;
        }
        if (string.equals(ObjektKategorie.ASTEROIDEN.getKategorienName()) || string.equals(ObjektKategorie.MONDE.getKategorienName())) {
            return d;
        }
        return 0.0;
    }

    protected double getGravitationsbeschleunigung(double d, double d2) {
        double d3 = d2 / 2.0;
        double d4 = d * 6.6742E-11 / Math.pow(d3, 2.0);
        return Math.rint(d4 * 1000.0) / 1000.0;
    }

    private void addEscapeVelocity(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        Optional<Double> optional = this.escapeVelocityCalculator.calculateSecondCosmicVelocity(iPlanetensucheObjekt.getMasse(), iPlanetensucheObjekt.getDurchmesser());
        if (optional.isPresent()) {
            jTextArea.append(this.i18n.getString("db_m497", optional.get()) + "\n");
        }
    }

    private void addGaiaData(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        if (ObjektKategorie.STERNE.getKategorienName().equals(iPlanetensucheObjekt.getKategorie())) {
            if (!iPlanetensucheObjekt.isGaiaNonSingleUnbekannt()) {
                jTextArea.append(this.i18n.getString("db_m501", iPlanetensucheObjekt.getGaiaNonSingle().toReadableString()) + "\n");
            }
            if (!iPlanetensucheObjekt.isGaiaRuweUnbekannt()) {
                jTextArea.append(this.i18n.getString("db_m502", iPlanetensucheObjekt.getGaiaRuwe()) + "\n");
            }
            if (!iPlanetensucheObjekt.isGaiaAstroExNoiseSigUnbekannt()) {
                jTextArea.append(this.i18n.getString("db_m503", iPlanetensucheObjekt.getGaiaAstroExNoiseSig()) + "\n");
            }
            if (!iPlanetensucheObjekt.isGaiaRvErrorUnbekannt()) {
                jTextArea.append(this.i18n.getString("db_m504", iPlanetensucheObjekt.getGaiaRvError()) + "\n");
            }
        }
    }
}

