/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.util.Map;
import javax.swing.JTextArea;

public class DatenbankZeigeObjektEntdecker {
    private final ISprachcontainer i18n;

    public DatenbankZeigeObjektEntdecker(ISprachcontainer iSprachcontainer) {
        this.i18n = iSprachcontainer;
    }

    public void addEntdeckerInfo(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea, String string) {
        this.addEntdeckungsmethode(iPlanetensucheObjekt, jTextArea);
        this.addEntdeckungsdatum(iPlanetensucheObjekt, jTextArea);
        if (ObjektKategorie.PLANETEN.getKategorienName().equals(string) || ObjektKategorie.BR_ZWERGE.getKategorienName().equals(string)) {
            jTextArea.append(this.i18n.getString("db_m451") + ": " + this.i18n.getString("" + iPlanetensucheObjekt.isEntdeckungBestaetigt()) + "\n");
        }
        this.zeigeEntdecker(iPlanetensucheObjekt, jTextArea);
    }

    private void addEntdeckungsdatum(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        if (!iPlanetensucheObjekt.isEntdeckungsdatumUnbekannt()) {
            String string = this.i18n.toLocalisedDate(iPlanetensucheObjekt.getEntdeckungsdatum());
            jTextArea.append(this.i18n.getString("db_m127") + ": " + string + "\n");
        }
    }

    private void addEntdeckungsmethode(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        if (!iPlanetensucheObjekt.getEntdeckungsmethode().isEmpty()) {
            jTextArea.append(this.i18n.getString("db_m126") + ": " + this.i18n.getUebersetzungFuerAktuelleSprache(iPlanetensucheObjekt.getEntdeckungsmethode()) + "\n");
        }
    }

    private void zeigeEntdecker(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        if (!iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().isEmpty()) {
            jTextArea.append(this.i18n.getString("db_m128") + ":\n");
            for (Map.Entry<String, String> entry : iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen().entrySet()) {
                String string = entry.getValue();
                String string2 = entry.getKey();
                if (string == null || string.isEmpty()) {
                    jTextArea.append(string2 + ", ");
                    continue;
                }
                jTextArea.append(string + " " + string2 + ", ");
            }
            jTextArea.setText(jTextArea.getText().substring(0, jTextArea.getText().length() - 2));
            jTextArea.append("\n");
        }
    }
}

