/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import javax.swing.JTextArea;

public final class DatenbankZeigeObjektMasseDurchmesser {
    private final ISprachcontainer i18n = SprachcontainerFabrik.getSprachcontainer();

    public void addMasse(IPlanetensucheObjekt iPlanetensucheObjekt, String string, JTextArea jTextArea) {
        if (iPlanetensucheObjekt.isMasseUnbekannt()) {
            return;
        }
        if (string.equals(ObjektKategorie.STERNE.getKategorienName()) || string.equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName()) || string.equals(ObjektKategorie.GALAXIENHAUFEN.getKategorienName()) || string.equals(ObjektKategorie.STERNHAUFEN.getKategorienName()) || string.equals(ObjektKategorie.SONSTIGES.getKategorienName())) {
            jTextArea.append(this.i18n.getString("db_m103") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getMasse()) + " " + this.i18n.getString("db_m101") + "\n");
        } else if (string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName())) {
            jTextArea.append(this.i18n.getString("db_m103") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getMasse()) + " " + this.i18n.getString("db_m102") + "\n");
        } else if (string.equals(ObjektKategorie.PLANETEN.getKategorienName())) {
            this.addMassePlaneten(iPlanetensucheObjekt, jTextArea);
        } else {
            jTextArea.append(this.i18n.getString("db_m103") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getMasse()) + " Kg\n");
        }
    }

    private void addMassePlaneten(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        String string = this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getMasse());
        if (this.isPlanetInSolarSystem(iPlanetensucheObjekt)) {
            String string2 = this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getMasse() * 1.898E27);
            jTextArea.append(this.i18n.getString("db_m103") + ": " + string2 + " Kg (" + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getMasse()) + " " + this.i18n.getString("db_m102") + ")\n");
        } else if (iPlanetensucheObjekt.getMasse() < 0.03) {
            String string3 = this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getMasse() * 317.87746903247404);
            jTextArea.append(this.i18n.getString("db_m103") + ": " + string + " " + this.i18n.getString("db_m102") + " (" + string3 + " " + this.i18n.getString("db_m457") + ")\n");
        } else if (iPlanetensucheObjekt.getMasse() <= 0.25) {
            String string4 = this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getMasse() * 18.539490383676657);
            jTextArea.append(this.i18n.getString("db_m103") + ": " + string + " " + this.i18n.getString("db_m102") + " (" + string4 + " " + this.i18n.getString("db_m458") + ")\n");
        } else {
            jTextArea.append(this.i18n.getString("db_m103") + ": " + string + " " + this.i18n.getString("db_m102") + "\n");
        }
    }

    private boolean isPlanetInSolarSystem(IPlanetensucheObjekt iPlanetensucheObjekt) {
        return "Sonne".equals(iPlanetensucheObjekt.getUmkreistObjekt()) || "Sun".equals(iPlanetensucheObjekt.getUmkreistObjekt());
    }

    public void addDurchmesser(IPlanetensucheObjekt iPlanetensucheObjekt, String string, JTextArea jTextArea) {
        if (!iPlanetensucheObjekt.isDurchmesserUnbekannt()) {
            if (string.equals(ObjektKategorie.GALAXIE_NEBEL.getKategorienName()) || string.equals(ObjektKategorie.GALAXIENHAUFEN.getKategorienName()) || string.equals(ObjektKategorie.STERNHAUFEN.getKategorienName()) || string.equals(ObjektKategorie.SONSTIGES.getKategorienName())) {
                jTextArea.append(this.i18n.getString("db_m97") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getDurchmesser()) + "'\n");
            } else if (string.equals(ObjektKategorie.STERNE.getKategorienName())) {
                jTextArea.append(this.i18n.getString("db_m97") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getDurchmesser()) + " " + this.i18n.getString("db_m98") + "\n");
            } else if (string.equals(ObjektKategorie.BR_ZWERGE.getKategorienName())) {
                jTextArea.append(this.i18n.getString("db_m97") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getDurchmesser()) + " " + this.i18n.getString("db_m99") + "\n");
            } else if (string.equals(ObjektKategorie.PLANETEN.getKategorienName())) {
                this.addDurchmesserPlaneten(iPlanetensucheObjekt, jTextArea);
            } else {
                jTextArea.append(this.i18n.getString("db_m97") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getDurchmesser()) + " km\n");
            }
        }
        if (!iPlanetensucheObjekt.isGalaxiendurchmesserInLyUnbekannt()) {
            jTextArea.append(this.i18n.getString("db_m100") + ": " + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getGalaxienDurchmesserInLy()) + " ly\n");
        }
    }

    private void addDurchmesserPlaneten(IPlanetensucheObjekt iPlanetensucheObjekt, JTextArea jTextArea) {
        String string = this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getDurchmesser());
        if (this.isPlanetInSolarSystem(iPlanetensucheObjekt)) {
            String string2 = this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getDurchmesser() * 142984.0);
            jTextArea.append(this.i18n.getString("db_m97") + ": " + string2 + " Km (" + this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getDurchmesser()) + " " + this.i18n.getString("db_m99") + ")\n");
        } else if (iPlanetensucheObjekt.getDurchmesser() < 0.15) {
            String string3 = this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getDurchmesser() * 11.194418312950768);
            jTextArea.append(this.i18n.getString("db_m97") + ": " + string + " " + this.i18n.getString("db_m99") + " (" + string3 + " " + this.i18n.getString("db_m459") + ")\n");
        } else if (iPlanetensucheObjekt.getDurchmesser() <= 1.0) {
            String string4 = this.i18n.toLocalisedDouble(iPlanetensucheObjekt.getDurchmesser() * 2.8831368115005653);
            jTextArea.append(this.i18n.getString("db_m97") + ": " + string + " " + this.i18n.getString("db_m99") + " (" + string4 + " " + this.i18n.getString("db_m460") + ")\n");
        } else {
            jTextArea.append(this.i18n.getString("db_m97") + ": " + string + " " + this.i18n.getString("db_m99") + "\n");
        }
    }
}

