/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import com.google.inject.Injector;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.impl.ILeuchtkraftklassenService;
import de.planetensuche.datenbank.DatenbankDialog;
import de.planetensuche.datenbank.DatenbankDialogControler;
import de.planetensuche.datenbank.PlanetTypeDetectorService;
import de.planetensuche.datenbank.SternradiusUndMasseBerechnenService;
import de.planetensuche.datenbank.api.IDatenbankDialog;
import de.planetensuche.datenbank.api.IStart;
import de.planetensuche.datenbank.dbmodel.api.FilterkonfigurationDto;
import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dbmodel.api.IKoordinatenDAO;
import de.planetensuche.datenbank.dbmodel.api.IObjektnamenFilterDAO;
import de.planetensuche.datenbank.dbmodel.api.ISQLScript;
import de.planetensuche.datenbank.dbmodel.api.ITimestampDAO;
import de.planetensuche.datenbank.dbmodel.basis.NearbyStarsRepository;
import de.planetensuche.datenbank.dbmodel.notizen.api.INotizenService;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.InjectionDtoFactory;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.exportierer.guis.ExportDialog;
import de.planetensuche.datenbank.guis.datenbank.FilteroptionenDialog;
import de.planetensuche.datenbank.guis.datenbank.KoordsqueryDialog;
import de.planetensuche.datenbank.guis.datenbank.LeuchtkraftklassenErmittelnDialog;
import de.planetensuche.datenbank.guis.datenbank.PlanetentypErmittelnDialog;
import de.planetensuche.datenbank.guis.datenbank.SternRadiusMasseErmittelnDialog;
import de.planetensuche.datenbank.guis.doublestar.DoubleStarCheckDialogController;
import de.planetensuche.datenbank.guis.formulare.EingabeentdeckerDialog;
import de.planetensuche.datenbank.guis.formulare.EingabemethodenDialog;
import de.planetensuche.datenbank.guis.formulare.objektbearbeiten.EingabePlanetensucheObjektDialogControler;
import de.planetensuche.datenbank.guis.menuextras.ExoplanetenEntdeckungsdatumControllerAndDialog;
import de.planetensuche.datenbank.guis.menuextras.ListeNaherSterneDialog;
import de.planetensuche.datenbank.guis.menuextras.NamenlisteOption;
import de.planetensuche.datenbank.guis.menuextras.NamenslisteThread;
import de.planetensuche.datenbank.guis.menuextras.RekordeDialog;
import de.planetensuche.datenbank.guis.menuhilfe.InfoDialog;
import de.planetensuche.datenbank.importierer.ImportDialogController;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbank.menuekataloge.KatalogeControler;
import de.planetensuche.datenbank.phtmatches.PhtMatchesDialogControler;
import de.planetensuche.datenbank.phtmatches.service.IPhtTransitMatchFinder;
import de.planetensuche.datenbank.reparatur.ReparaturDialog;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.kategorien.IPlanetenRepository;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.api.repos.IGaiaStarsRepository;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IObjekttypenRepository;
import de.planetensuche.datenbankkern.api.repos.IPhtTransitMatchesRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.impl.Datenbankverbinder;
import de.planetensuche.datenbankkern.impl.cache.IdCacheDAO;
import de.planetensuche.konfigurator.api.KonfigurationDTO;

public class DialogFactory {
    private final Injector injector;

    public DialogFactory(Injector injector) {
        this.injector = injector;
    }

    public RekordeDialog createRekorde(DatenbankDialog datenbankDialog) {
        return new RekordeDialog(datenbankDialog, this.injector.getInstance(IObjektnamenRepository.class), this.injector.getInstance(IKategorienRepository.class), this.injector.getInstance(IDatenbankverbinder.class), this.injector.getInstance(IdCacheDAO.class));
    }

    public FilteroptionenDialog createFilter(ParameterDto parameterDto, IDatenbankDialog iDatenbankDialog) {
        return new FilteroptionenDialog(parameterDto, iDatenbankDialog, this.injector.getInstance(ITimestampDAO.class), this.injector.getInstance(IKategorienRepository.class));
    }

    public ListeNaherSterneDialog createNaheSterne() {
        return new ListeNaherSterneDialog(this.injector.getInstance(NearbyStarsRepository.class));
    }

    public EingabemethodenDialog createEntdeckungsMethoden(ParameterDto parameterDto) {
        return new EingabemethodenDialog(parameterDto, this.injector.getInstance(IEntdeckungsmethodenRepository.class), this.injector.getInstance(IObjektnamenRepository.class));
    }

    public EingabeentdeckerDialog createEntdecker(ParameterDto parameterDto) {
        return new EingabeentdeckerDialog(parameterDto, this.injector.getInstance(IEntdeckerRepository.class), this.injector.getInstance(IObjektnamenRepository.class));
    }

    public EingabePlanetensucheObjektDialogControler createMainEditDialog(ParameterDto parameterDto, FilterkonfigurationDto filterkonfigurationDto, InjectionDto injectionDto, KonfigurationDTO konfigurationDTO) {
        EingabePlanetensucheObjektDialogControler eingabePlanetensucheObjektDialogControler = new EingabePlanetensucheObjektDialogControler(parameterDto, filterkonfigurationDto, this.injector.getInstance(IObjektnamenFilterDAO.class), injectionDto, konfigurationDTO);
        return eingabePlanetensucheObjektDialogControler;
    }

    public InfoDialog createInfo() {
        return new InfoDialog(this.injector.getInstance(IDAOhighService.class), this.injector.getInstance(IObjektnamenRepository.class), this.injector.getInstance(IKategorienRepository.class), this.injector.getInstance(INotizenService.class));
    }

    public ReparaturDialog createReparaturDialog(boolean bl, ParameterDto parameterDto, DatenbankDialogControler datenbankDialogControler) {
        return new ReparaturDialog(bl, parameterDto, datenbankDialogControler, this.injector.getInstance(IDAOhighService.class), this.injector.getInstance(ISQLScript.class));
    }

    public ExportDialog createExportDialog(ParameterDto parameterDto, InjectionDto injectionDto, KonfigurationDTO konfigurationDTO) {
        return new ExportDialog(parameterDto, injectionDto, konfigurationDTO);
    }

    public ExoplanetenEntdeckungsdatumControllerAndDialog createExoDate() {
        return new ExoplanetenEntdeckungsdatumControllerAndDialog(this.injector.getInstance(IPlanetenRepository.class));
    }

    public KoordsqueryDialog createKoordsQuery(ParameterDto parameterDto, KoordinatenFormat koordinatenFormat) {
        return new KoordsqueryDialog(parameterDto, koordinatenFormat, this.injector.getInstance(IKoordinatenDAO.class));
    }

    public PlanetentypErmittelnDialog createPlanetTyp() {
        return new PlanetentypErmittelnDialog(this.injector.getInstance(PlanetTypeDetectorService.class));
    }

    public SternRadiusMasseErmittelnDialog createStarRadiusMass() {
        SternradiusUndMasseBerechnenService sternradiusUndMasseBerechnenService = this.injector.getInstance(SternradiusUndMasseBerechnenService.class);
        SternRadiusMasseErmittelnDialog sternRadiusMasseErmittelnDialog = new SternRadiusMasseErmittelnDialog(sternradiusUndMasseBerechnenService);
        return sternRadiusMasseErmittelnDialog;
    }

    public LeuchtkraftklassenErmittelnDialog createLk() {
        ILeuchtkraftklassenService iLeuchtkraftklassenService = this.injector.getInstance(ILeuchtkraftklassenService.class);
        LeuchtkraftklassenErmittelnDialog leuchtkraftklassenErmittelnDialog = new LeuchtkraftklassenErmittelnDialog(iLeuchtkraftklassenService);
        return leuchtkraftklassenErmittelnDialog;
    }

    public DoubleStarCheckDialogController createDoubleStarCheck(Katalogerkenner katalogerkenner, KonfigurationDTO konfigurationDTO, DatenbankDialog datenbankDialog) {
        DoubleStarCheckDialogController doubleStarCheckDialogController = new DoubleStarCheckDialogController(this.injector.getInstance(IObjekttypenRepository.class), katalogerkenner, this.injector.getInstance(IObjektnamenRepository.class), konfigurationDTO, datenbankDialog, this.injector.getInstance(IDatenbankverbinder.class), this.injector.getInstance(IIdCacheDAO.class));
        return doubleStarCheckDialogController;
    }

    public PhtMatchesDialogControler createPhtMatches(Katalogerkenner katalogerkenner, DatenbankDialog datenbankDialog) {
        return new PhtMatchesDialogControler(this.injector.getInstance(IPhtTransitMatchFinder.class), this.injector.getInstance(IPhtTransitMatchesRepository.class), this.injector.getInstance(IPlanetenRepository.class), this.injector.getInstance(IObjektnamenRepository.class), katalogerkenner, this.injector.getInstance(IPlanetensucheObjektRepository.class), this.injector.getInstance(PlanetTypeDetectorService.class), datenbankDialog);
    }

    public NamenslisteThread createNameList(DatenbankDialog datenbankDialog, ParameterDto parameterDto, NamenlisteOption namenlisteOption) {
        return new NamenslisteThread(datenbankDialog, parameterDto, namenlisteOption, this.injector.getInstance(IObjektnamenRepository.class));
    }

    public ImportDialogController createImportDialog(ParameterDto parameterDto, IStart iStart, KonfigurationDTO konfigurationDTO) {
        InjectionDto injectionDto = InjectionDtoFactory.createInjectionDto(this.injector);
        return new ImportDialogController(parameterDto, iStart, injectionDto, injectionDto.getKatalogerkenner(), konfigurationDTO, this.injector.getInstance(Datenbankverbinder.class), this.injector.getInstance(IGaiaStarsRepository.class));
    }

    public KatalogeControler createCatalogGui(ParameterDto parameterDto, InjectionDto injectionDto) {
        return new KatalogeControler(parameterDto, this.injector, injectionDto.getKatalogerkenner());
    }
}

