/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import de.planetensuche.datenbank.importierer.validator.DoubleStarConstants;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class DoubleStarDetectorService {
    private final IObjektnamenRepository objektnamenRepository;
    private final Katalogerkenner katalogerkenner;

    public DoubleStarDetectorService(IObjektnamenRepository iObjektnamenRepository, Katalogerkenner katalogerkenner) throws IOException {
        this.objektnamenRepository = iObjektnamenRepository;
        this.katalogerkenner = katalogerkenner;
    }

    protected String getDoppelSternKomponenten(List<String> list) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(10);
        Object object = list.iterator();
        while (object.hasNext()) {
            String string = object.next();
            if (this.katalogerkenner.isMehrfachsternKatalog(string) || this.katalogerkenner.isDurchmusterungsKatalog(string) || string.startsWith("L ") || string.startsWith("HD ") || this.katalogerkenner.isGlieseKatalog(string) || this.katalogerkenner.isGlieseJahreissKatalog(string)) {
                var5_5 = string;
                for (String string2 : DoubleStarConstants.LETTERS_OF_STAR_COMPONENTS) {
                    if (!var5_5.endsWith(string2)) continue;
                    var5_5 = var5_5.substring(0, var5_5.length() - string2.length()).trim();
                    break;
                }
                for (String string2 : DoubleStarConstants.LETTERS_OF_STAR_COMPONENTS) {
                    Integer n = this.objektnamenRepository.getIDFuerNamen(var5_5 + string2, true);
                    if (n != null) {
                        stringBuilder.append(var5_5).append(string2).append(", ");
                        continue;
                    }
                    if (this.objektnamenRepository.getIDFuerNamen(var5_5 + " " + string2, true) == null) continue;
                    stringBuilder.append(var5_5).append(" ").append(string2).append(", ");
                }
                if (stringBuilder.length() > 2) {
                    stringBuilder.setLength(stringBuilder.length() - 2);
                }
                if (stringBuilder.toString().split(",").length > 1) {
                    break;
                }
            } else if (string.startsWith("CSI") && string.charAt(string.length() - 2) == ' ') {
                var5_5 = string.substring(0, string.length() - 1).trim();
                for (int i = 1; i < 8; ++i) {
                    if (this.objektnamenRepository.getIDFuerNamen(var5_5 + " " + i, true) == null) continue;
                    stringBuilder.append(var5_5).append(" ").append(i).append(", ");
                }
                stringBuilder.setLength(stringBuilder.length() - 2);
                if (stringBuilder.toString().split(",").length > 1) break;
            }
            stringBuilder = new StringBuilder(0);
        }
        if (((String)(object = stringBuilder.toString())).split(",").length > 1) {
            return object;
        }
        return "";
    }
}

