/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public final class Druckjob {
    private final ISprachcontainer sprache;
    private final ILogging logging;
    private final Font fontGross = new Font("Times", 0, 20);
    private final Font fontNormal = new Font("Times", 0, 12);
    private final Font fontKlein = new Font("Times", 0, 10);
    private final Toolkit tk = Toolkit.getDefaultToolkit();
    private final KonfigurationDTO konfig;

    public Druckjob(KonfigurationDTO konfigurationDTO) {
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.konfig = konfigurationDTO;
    }

    public void druckeText(JTextArea jTextArea, String string) {
        try {
            PrintJob printJob;
            String[] stringArray = jTextArea.getText().split("\n");
            int n = 0;
            int n2 = 1;
            int n3 = stringArray.length / 33;
            ++n3;
            if (stringArray.length % 33 == 0) {
                --n3;
            }
            if ((printJob = this.tk.getPrintJob(new JFrame(), string, null)) == null) {
                return;
            }
            while (n < stringArray.length) {
                Graphics graphics = printJob.getGraphics();
                Dimension dimension = printJob.getPageDimension();
                int n4 = (int)(dimension.getWidth() / 10.0);
                int n5 = (int)(dimension.getHeight() / 10.0);
                graphics.setFont(this.fontGross);
                graphics.drawString(this.sprache.getString("db_m9"), n4, n5);
                graphics.drawString(this.sprache.getString("db_m10") + " '" + string + "'", n4, (int)((double)n5 * 1.3));
                graphics.drawLine(n4, (int)((double)n5 * 1.5), n4 * 9, (int)((double)n5 * 1.5));
                graphics.setFont(this.fontNormal);
                graphics.translate(n4, n5 * 2);
                JTextArea jTextArea2 = new JTextArea();
                jTextArea2.setBounds(jTextArea.getBounds());
                jTextArea2.setVisible(true);
                if (n + 33 >= stringArray.length) {
                    for (var13_14 = n; var13_14 < stringArray.length; ++var13_14) {
                        jTextArea2.append(stringArray[var13_14] + "\n");
                    }
                } else {
                    for (var13_14 = n; var13_14 < n + 33; ++var13_14) {
                        jTextArea2.append(stringArray[var13_14] + "\n");
                    }
                }
                jTextArea2.print(graphics);
                n += 33;
                graphics.setFont(this.fontKlein);
                graphics.drawString(this.sprache.getString("db_m12") + ": Gerd G\u00fchne, https://www." + this.konfig.getHomepageHostname(), 0, n5 * 7);
                graphics.drawString("- " + this.sprache.getString("db_m13") + " " + n2 + " " + this.sprache.getString("db_m14") + " " + n3 + " -", (int)(dimension.getWidth() / 3.0), (int)((double)n5 * 7.3));
                ++n2;
            }
            printJob.end();
        }
        catch (Exception exception) {
            this.logging.error(exception);
            JOptionPane.showMessageDialog(null, this.sprache.getString("db_f12") + "\n" + exception.toString(), this.sprache.getString("db_f4_titel"), 0);
        }
    }

    public void druckeBild(String string, String string2) {
        try {
            PrintJob printJob = this.tk.getPrintJob(new JFrame(), string, null);
            if (printJob == null) {
                return;
            }
            Graphics graphics = printJob.getGraphics();
            Dimension dimension = printJob.getPageDimension();
            int n = (int)(dimension.getWidth() / 10.0);
            int n2 = (int)(dimension.getHeight() / 10.0);
            graphics.setFont(this.fontGross);
            graphics.drawString(this.sprache.getString("db_m9"), n, n2);
            graphics.drawString(this.sprache.getString("db_m10") + " '" + string2 + "'", n, (int)((double)n2 * 1.3));
            graphics.drawLine(n, (int)((double)n2 * 1.5), n * 9, (int)((double)n2 * 1.5));
            Image image = Toolkit.getDefaultToolkit().getImage("pics" + File.separator + string);
            image = image.getScaledInstance(n * 8, n2 * 7, 1);
            JLabel jLabel = new JLabel();
            jLabel.setBounds(0, 0, n * 6, n2 * 6);
            jLabel.setVisible(true);
            jLabel.setIcon(new ImageIcon(image));
            graphics.translate(n, (int)((double)n2 * 2.25));
            jLabel.paint(graphics);
            graphics.setFont(this.fontKlein);
            graphics.drawString(this.sprache.getString("db_m11"), 0, (int)((double)n2 * 6.8));
            graphics.drawString(this.sprache.getString("db_m12") + ": Gerd G\u00fchne, https://www." + this.konfig.getHomepageHostname(), 0, (int)((double)n2 * 7.0));
            printJob.end();
        }
        catch (Exception exception) {
            this.logging.error(exception);
            JOptionPane.showMessageDialog(null, this.sprache.getString("db_f11") + "\n" + exception.toString(), this.sprache.getString("db_f4_titel"), 0);
        }
    }
}

