/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public final class EntferneObjekte {
    private final ISprachcontainer sprache;
    private final ILogging logging;
    private final File xmlDateiAlt;
    private final File xmlDateiNeu;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;

    public EntferneObjekte(ParameterDto parameterDto, File file, File file2, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IObjektnamenRepository iObjektnamenRepository) {
        this.xmlDateiAlt = file;
        this.xmlDateiNeu = file2;
        this.sprache = parameterDto.getSprache();
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.objektnamenRepository = iObjektnamenRepository;
    }

    public boolean start() throws SQLException {
        Serializable serializable;
        ArrayList<List> arrayList = new ArrayList<List>();
        List<List<String>> list = this.parseXML(this.xmlDateiAlt);
        List<List<String>> list2 = this.parseXML(this.xmlDateiNeu);
        if (list == null || list2 == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            try {
                Object object;
                List list3 = list.get(i);
                serializable = new ArrayList();
                for (String string : list3) {
                    boolean bl = false;
                    object = list2.iterator();
                    while (object.hasNext()) {
                        List<String> list4 = object.next();
                        if (!list4.contains(string)) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    serializable.add(string);
                }
                if (!serializable.isEmpty()) {
                    Object object2 = null;
                    int n = 0;
                    Iterator iterator = serializable.iterator();
                    while (iterator.hasNext() && ((object2 = this.objektnamenRepository.getIDFuerNamen((String)(object = (String)iterator.next()), true)) == null || (n = this.objektnamenRepository.getNamenByDatenId((Integer)object2, ObjektnamenSortierung.KEINE_SORTIERUNG).size()) <= 0)) {
                    }
                    if (serializable.size() < n) {
                        iterator = serializable.iterator();
                        while (iterator.hasNext()) {
                            object = (String)iterator.next();
                            System.out.println(this.sprache.getString("db_m244") + (String)object + "' ...");
                            this.logging.info(this.sprache.getString("db_m244") + (String)object + "' ...");
                            if (this.objektnamenRepository.removeNamen((String)object)) continue;
                            this.logging.warn("Objektname '" + (String)object + "' konnte nicht geloescht werden!");
                        }
                    } else if (serializable.size() == n) {
                        System.out.println(this.sprache.getString("db_m245") + (String)serializable.get(0) + "' ...");
                        this.logging.info(this.sprache.getString("db_m245") + (String)serializable.get(0) + "' ...");
                        try {
                            this.planetensucheObjektRepository.delete((Integer)object2);
                        }
                        catch (Exception exception) {
                            arrayList.add(list3);
                        }
                    } else {
                        this.logging.info(this.sprache.getString("db_f95") + " (" + serializable.size() + ">" + n + ")!");
                    }
                }
            }
            catch (SQLException sQLException) {
                this.logging.error(sQLException);
            }
            System.out.println(this.sprache.getString("db_m246_1") + " " + i * 100 / list.size() + " " + this.sprache.getString("db_m246_2"));
        }
        for (List list3 : arrayList) {
            serializable = this.objektnamenRepository.getIDFuerNamen((String)list3.get(0), true);
            this.planetensucheObjektRepository.delete((Integer)serializable);
        }
        return true;
    }

    private List<List<String>> parseXML(File file) {
        try {
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
            SAXBuilder sAXBuilder = new SAXBuilder();
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                Document document = sAXBuilder.build(fileInputStream);
                Element element = document.getRootElement();
                List<Element> list = element.getChildren();
                for (Element element2 : list) {
                    try {
                        List<Element> list2 = element2.getChildren();
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        for (Element element3 : list2) {
                            String string;
                            if ("name".equals(element3.getName())) {
                                arrayList2.add(element3.getValue());
                                continue;
                            }
                            if (!"autor".equals(element3.getName()) || "Gerd Guehne".equals(string = element3.getValue()) || "Jean Schneider".equals(string) || "Michael Johne".equals(string)) continue;
                            arrayList2.clear();
                            break;
                        }
                        if (arrayList2.size() <= 0) continue;
                        arrayList.add(arrayList2);
                    }
                    catch (Exception exception) {
                        this.logging.error("getName(): " + element2.getName(), exception);
                    }
                }
            }
            return arrayList;
        }
        catch (IOException | JDOMException exception) {
            this.logging.error("parseXML(" + file.getName() + ")", exception);
            return null;
        }
    }
}

