/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;

public final class InternetSuche
extends Thread {
    private boolean trefferUndSeiteHeruntergeladen = true;
    private boolean keineInternetverbindung;
    private final String webseite;
    private final File dateiname;
    private final ILogging logging;

    public InternetSuche(int n, String string) {
        this.webseite = string;
        this.dateiname = new File("temp" + File.separator + n + ".html");
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
    }

    public boolean istTrefferUndSeiteHeruntergeladen() {
        return this.trefferUndSeiteHeruntergeladen;
    }

    public boolean istKeineInternetverbindung() {
        return this.keineInternetverbindung;
    }

    @Override
    public void run() {
        String[] stringArray = new String[]{"Identifier not found in the database", "NGC Error", ",,,", "No star name matching", "There is no object with this name in NED", "The object name that you submitted is not currently recognized by the NED name interpreter."};
        try {
            URL uRL = new URL(this.webseite);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));){
                Charset charset = Charset.forName("UTF-8");
                try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.dateiname, false), charset));){
                    String string;
                    block13: while ((string = bufferedReader.readLine()) != null) {
                        bufferedWriter.write(string);
                        bufferedWriter.newLine();
                        for (String string2 : stringArray) {
                            if (!string.contains(string2)) continue;
                            this.trefferUndSeiteHeruntergeladen = false;
                            continue block13;
                        }
                    }
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.logging.info(unknownHostException);
            this.trefferUndSeiteHeruntergeladen = false;
            this.keineInternetverbindung = true;
        }
        catch (IOException iOException) {
            this.logging.error("Fehler in internet_suche(" + String.valueOf(this.dateiname) + "," + this.webseite + ")", iOException);
            this.trefferUndSeiteHeruntergeladen = false;
        }
    }
}

