/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datamodel.impl.Sternbild;
import de.planetensuche.datenbank.DatenbankDialog;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JOptionPane;

public class Lesenthread
extends Thread {
    private final DatenbankDialog gui;
    private final IDatenbankService dao;
    private final ISprachcontainer sprache;
    private final ILogging logging;
    private final String objektName;
    private final SternbildSprache sternbildSprache;
    private final boolean zeigeStatusfenster;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final ISternbilderRepository sternbilderRepository;

    public Lesenthread(String string, DatenbankDialog datenbankDialog, ParameterDto parameterDto, boolean bl, InjectionDto injectionDto) {
        if (string == null) {
            throw new IllegalArgumentException("objektname ist null");
        }
        this.objektName = string;
        this.gui = datenbankDialog;
        this.sprache = parameterDto.getSprache();
        this.sternbildSprache = parameterDto.getSternbildSprache();
        this.zeigeStatusfenster = bl;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.dao = injectionDto.getDatenbankService();
        this.planetensucheObjektRepository = injectionDto.getPlanetensucheObjektRepository();
        this.objektnamenRepository = injectionDto.getObjektnamenRepository();
        this.sternbilderRepository = injectionDto.getSternbilderRepository();
    }

    @Override
    public void run() {
        if (this.zeigeStatusfenster) {
            AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
            asyncLoadingScreenCallbackExecutor.execute(this.gui, () -> this.ladeUndZeigeObjekt());
        } else {
            this.ladeUndZeigeObjekt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ladeUndZeigeObjekt() {
        try {
            this.gui.setSemaphorLooked(true);
            this.gui.getTextarea().setText("");
            if (!this.dao.getSternbildsprache().equals((Object)this.sternbildSprache)) {
                this.dao.setSternbildsprache(this.sternbildSprache);
            }
            boolean bl = false;
            Integer n = this.objektnamenRepository.getIDFuerNamen(this.objektName, true);
            if (n == null) {
                Integer n2 = this.sternbilderRepository.getIdVonNamen(this.objektName);
                if (n2 == null) {
                    this.zeigeFehlermeldung();
                    return;
                }
                bl = true;
            }
            if (bl) {
                this.ladeUndZeigeSternbild();
            } else {
                this.ladeUndZeigePlanetensucheObjekt(n);
            }
        }
        catch (IOException | SQLException exception) {
            this.loggeUndZeigeFehlermeldung(exception);
        }
        finally {
            this.gui.setSemaphorLooked(false);
        }
    }

    private void ladeUndZeigeSternbild() throws SQLException {
        this.logging.debug("Name des Sternbilds=" + this.objektName);
        Sternbild sternbild = new Sternbild();
        if (!this.dao.getAllDataSternbild(sternbild, this.objektName)) {
            this.zeigeFehlermeldung();
        } else {
            this.gui.zeigeSternbild(sternbild);
        }
    }

    private void ladeUndZeigePlanetensucheObjekt(Integer n) throws IOException, SQLException {
        IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n);
        if (iPlanetensucheObjekt.getKategorie().isEmpty()) {
            this.logging.warn("Laden des Objektes '" + this.objektName + "' fehlgeschlagen!");
            this.logging.warn(iPlanetensucheObjekt.toString());
            JOptionPane.showMessageDialog(this.gui, this.sprache.getString("db_f20"), this.sprache.getString("db_f4_titel"), 0);
        } else {
            this.gui.zeigeObjekt(this.objektName, iPlanetensucheObjekt.getKategorie(), iPlanetensucheObjekt);
        }
    }

    private void loggeUndZeigeFehlermeldung(Exception exception) {
        this.logging.error("Error Objekt: '" + this.objektName + "'", exception);
        JOptionPane.showMessageDialog(this.gui, this.sprache.getString("db_f20") + ": " + exception.toString(), this.sprache.getString("db_f4_titel"), 0);
    }

    private void zeigeFehlermeldung() {
        JOptionPane.showMessageDialog(null, this.sprache.getString("db_f18") + " '" + this.objektName + "' " + this.sprache.getString("db_f19"), this.sprache.getString("db_f16"), 2);
    }
}

