/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import com.google.inject.Injector;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dbmodel.api.FilterkonfigurationDto;
import de.planetensuche.datenbank.dbmodel.api.IObjektnamenFilterDAO;
import de.planetensuche.datenbank.dbmodel.menuextras.IKatalogDAO;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.List;

public class ObjectNamesFinderService {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final Injector injector;

    public ObjectNamesFinderService(Injector injector) {
        this.injector = injector;
    }

    public List<String> createNamesList(boolean bl, String string, ObjektKategorie objektKategorie, int n, FilterkonfigurationDto filterkonfigurationDto) throws SQLException {
        List<String> list;
        IDatenbankService iDatenbankService = this.injector.getInstance(IDatenbankService.class);
        if (bl) {
            IKatalogDAO iKatalogDAO = this.injector.getInstance(IKatalogDAO.class);
            this.logger.debug("objekte suchen fuer katalog: " + string);
            list = iKatalogDAO.getNamenFuerKatalog(string);
            list.remove("unbekannt");
            list.remove("unknown");
        } else if (ObjektKategorie.STERNBILDER.equals((Object)objektKategorie)) {
            list = iDatenbankService.getSternbilderNamen(iDatenbankService.getSternbildsprache());
        } else if (ObjektKategorie.STERNE.equals((Object)objektKategorie) && !filterkonfigurationDto.isFilterAktiv()) {
            list = this.injector.getInstance(IObjektnamenRepository.class).findCommonNames(ObjektKategorie.STERNE);
        } else {
            IObjektnamenFilterDAO iObjektnamenFilterDAO = this.injector.getInstance(IObjektnamenFilterDAO.class);
            list = iObjektnamenFilterDAO.getNamenFuerKategorie(n, true, filterkonfigurationDto);
        }
        return list;
    }
}

