/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import com.google.inject.Injector;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.impl.PlanetensucheObjektPruefer;
import de.planetensuche.datenbank.doublestar.queries.SesameResponseDto;
import de.planetensuche.datenbank.doublestar.queries.SesameService;
import de.planetensuche.datenbank.gaia.main.GaiaDataRelease;
import de.planetensuche.datenbank.gaia.main.GaiaStellarDataDto;
import de.planetensuche.datenbank.gaia.main.GaiaStellarDataService;
import de.planetensuche.datenbank.kataloge.TycCatalogFormatter;
import de.planetensuche.datenbank.tic.VizierTicCatalogDto;
import de.planetensuche.datenbank.tic.VizierTicCatalogQueryService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.exceptions.PlanetensucheSQLException;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenKlassifiziererService;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class StarDataOnlineUpdater {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final VizierTicCatalogQueryService vizierTicService = new VizierTicCatalogQueryService();
    private final GaiaStellarDataService gaiaService = new GaiaStellarDataService();
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCacheDAO;
    private final IPlanetensucheObjektRepository psRepo;
    private final ObjektnamenKlassifiziererService objectNameClassifierService;
    private final PlanetensucheObjektPrueferDAO psObjectCheckerRepo;
    private final TycCatalogFormatter tycFormatter;
    private final SesameService sesameService;

    public StarDataOnlineUpdater(Injector injector) {
        this.datenbankverbinder = injector.getInstance(IDatenbankverbinder.class);
        this.idCacheDAO = injector.getInstance(IIdCacheDAO.class);
        this.psRepo = injector.getInstance(IPlanetensucheObjektRepository.class);
        this.objectNameClassifierService = injector.getInstance(ObjektnamenKlassifiziererService.class);
        this.psObjectCheckerRepo = injector.getInstance(PlanetensucheObjektPrueferDAO.class);
        this.tycFormatter = new TycCatalogFormatter();
        this.sesameService = new SesameService();
    }

    public void downloadAndSave(int n) {
        try {
            int n2 = 0;
            List<Integer> list = this.findStarIdsForUpdate();
            for (Integer n3 : list) {
                if (n2 >= n) {
                    this.logger.info("stop online update");
                    return;
                }
                IPlanetensucheObjekt iPlanetensucheObjekt = this.psRepo.read(n3);
                Optional<VizierTicCatalogDto> optional = this.downloadData(iPlanetensucheObjekt.getObjektNamen());
                if (!optional.isPresent()) continue;
                try {
                    VizierTicCatalogDto vizierTicCatalogDto = optional.get();
                    this.setDataOnPsObject(vizierTicCatalogDto, iPlanetensucheObjekt);
                    iPlanetensucheObjekt.setStamp(Timestamp.from(Instant.now()));
                    PlanetensucheObjektPruefer planetensucheObjektPruefer = new PlanetensucheObjektPruefer(this.psObjectCheckerRepo, iPlanetensucheObjekt);
                    this.psRepo.update(planetensucheObjektPruefer, true, this.objectNameClassifierService);
                    String string = iPlanetensucheObjekt.getObjektNamen().get(0) + " successfully updated";
                    this.logger.info(string);
                    System.out.println(string);
                    ++n2;
                }
                catch (PlanetensucheSQLException planetensucheSQLException) {
                    this.logger.error(iPlanetensucheObjekt.getObjektNamen().toString(), planetensucheSQLException);
                }
            }
        }
        catch (Exception exception) {
            this.logger.error(exception);
        }
    }

    private Optional<VizierTicCatalogDto> downloadData(List<String> list) throws IOException {
        List<String> list2 = this.resolveSesameNamesIfOriginalIsUnuseable(list);
        if (Check.isEmpty(list2)) {
            this.logger.info("no Sesame entry found for object " + String.valueOf(list));
            return Optional.empty();
        }
        Optional<Long> optional = this.getTicId(list2);
        if (optional.isPresent()) {
            Optional<VizierTicCatalogDto> optional2 = this.vizierTicService.findByTicId(optional.get());
            if (optional2.isEmpty()) {
                this.logger.info("no data found in tic catalog for object " + list2.get(0));
            }
            return optional2;
        }
        Optional<Long> optional3 = this.getKicId(list2);
        if (optional3.isPresent()) {
            Optional<VizierTicCatalogDto> optional4 = this.vizierTicService.findByKicId(optional3.get());
            if (optional4.isEmpty()) {
                this.logger.info("no data found in tic catalog for object " + list2.get(0));
            }
            return optional4;
        }
        Optional<Long> optional5 = this.getGaiaDr2Id(list2);
        if (optional5.isPresent()) {
            Optional<VizierTicCatalogDto> optional6 = this.vizierTicService.findByGaiaDr2Id(optional5.get());
            if (optional6.isEmpty()) {
                this.logger.info("no data found in tic catalog for object " + list2.get(0));
            }
            return optional6;
        }
        Optional<Long> optional7 = this.getGaiaDr3Id(list2);
        if (optional7.isPresent()) {
            Optional<GaiaStellarDataDto> optional8 = this.gaiaService.queryGaia(GaiaDataRelease.DR3, optional7.get());
            if (optional8.isEmpty()) {
                this.logger.info("no data found in Gaia catalog for object " + list2.get(0));
            }
            return this.convertToTic(optional8);
        }
        this.logger.info("no tic or kic or gaia id found for object " + String.valueOf(list2));
        return Optional.empty();
    }

    private List<String> resolveSesameNamesIfOriginalIsUnuseable(List<String> list) throws UnknownHostException {
        boolean bl = false;
        for (String object : list) {
            if (!object.startsWith("TIC ") && !object.startsWith("Gaia DR2 ") && !object.startsWith("Gaia DR3 ") && !object.startsWith("KIC ")) continue;
            bl = true;
            break;
        }
        ArrayList<String> arrayList = null;
        if (!bl) {
            for (String string : list) {
                Optional<SesameResponseDto> optional = this.sesameService.querySesame(string);
                if (!optional.isPresent() || !Check.isFilled(optional.get().getNames())) continue;
                arrayList = new ArrayList<String>(optional.get().getNames());
                break;
            }
        } else {
            arrayList = list;
        }
        return arrayList;
    }

    private void setDataOnPsObject(VizierTicCatalogDto vizierTicCatalogDto, IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (vizierTicCatalogDto.getDistanceInPc() != null && vizierTicCatalogDto.getDistanceInPc() > 0.0) {
            double d = 3.2616 * vizierTicCatalogDto.getDistanceInPc();
            this.logger.info("updated distance from " + iPlanetensucheObjekt.getEntfernung() + " ly to " + d + " ly for object " + iPlanetensucheObjekt.getObjektNamen().get(0));
            boolean bl = iPlanetensucheObjekt.setEntfernung(d);
            if (!bl) {
                this.logger.warn("something is wrong with distance " + d + " ly on object " + iPlanetensucheObjekt.getObjektNamen().get(0));
            }
        } else if (iPlanetensucheObjekt.getEntfernung() < 3.0) {
            this.logger.info("updated distance from " + iPlanetensucheObjekt.getEntfernung() + " ly to 0 ly (no distance found) for object " + iPlanetensucheObjekt.getObjektNamen().get(0));
            iPlanetensucheObjekt.setEntfernung(0.0);
        }
        if (vizierTicCatalogDto.getTemperatureInKelvin() != null && iPlanetensucheObjekt.isTemperaturUnbekannt()) {
            iPlanetensucheObjekt.setTemperatur(vizierTicCatalogDto.getTemperatureInKelvin());
        }
        if (vizierTicCatalogDto.getRadius() != null && iPlanetensucheObjekt.isDurchmesserUnbekannt()) {
            iPlanetensucheObjekt.setDurchmesser(vizierTicCatalogDto.getRadius());
        }
        if (vizierTicCatalogDto.getMass() != null && iPlanetensucheObjekt.isMasseUnbekannt()) {
            iPlanetensucheObjekt.setMasse(vizierTicCatalogDto.getMass());
        }
        if (vizierTicCatalogDto.getVmag() != null && iPlanetensucheObjekt.isScheinbareHelligkeitUnbekannt()) {
            iPlanetensucheObjekt.setScheinbareHelligkeit(vizierTicCatalogDto.getVmag());
        }
        if (vizierTicCatalogDto.getBmag() != null && vizierTicCatalogDto.getVmag() != null && iPlanetensucheObjekt.isBVUnbekannt()) {
            iPlanetensucheObjekt.setBV(vizierTicCatalogDto.getBmag() - vizierTicCatalogDto.getVmag());
        }
        HashSet<String> hashSet = new HashSet<String>(iPlanetensucheObjekt.getObjektNamen());
        if (Check.isFilled(vizierTicCatalogDto.getTwoMassId()) && this.containsNotThisCatalog("2MASS ", hashSet)) {
            hashSet.add("2MASS " + vizierTicCatalogDto.getTwoMassId());
        }
        if (Check.isFilled(vizierTicCatalogDto.getGaiaDr2Id()) && this.containsNotThisCatalog("Gaia DR2 ", hashSet)) {
            hashSet.add("Gaia DR2 " + vizierTicCatalogDto.getGaiaDr2Id());
        }
        if (Check.isFilled(vizierTicCatalogDto.getHipId()) && this.containsNotThisCatalog("HIP ", hashSet)) {
            hashSet.add("HIP " + vizierTicCatalogDto.getHipId());
        }
        if (Check.isFilled(vizierTicCatalogDto.getKicId()) && this.containsNotThisCatalog("KIC ", hashSet)) {
            hashSet.add("KIC " + vizierTicCatalogDto.getKicId());
        }
        if (Check.isFilled(vizierTicCatalogDto.getTyc2Id()) && this.containsNotThisCatalog("TYC ", hashSet)) {
            hashSet.add("TYC " + this.tycFormatter.formatNumber(vizierTicCatalogDto.getTyc2Id()));
        }
        iPlanetensucheObjekt.setObjektNamen(hashSet);
    }

    private boolean containsNotThisCatalog(String string, Collection<String> collection) {
        for (String string2 : collection) {
            if (!string2.startsWith(string)) continue;
            return false;
        }
        return true;
    }

    private List<Integer> findStarIdsForUpdate() {
        QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
        Integer n = (Integer)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qObjekttypen.id).from((Expression<?>)qObjekttypen)).where(qObjekttypen.typ.eq("Brauner Zwerg ohne Stern"))).fetchOne();
        QDaten qDaten = new QDaten("stars");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(this.idCacheDAO.getObjekttypenidsSterne());
        arrayList.add(n);
        List<Integer> list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qDaten.id).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)arrayList).and(qDaten.entfernung.lt(1.0)).and(qDaten.stamp.lt(Timestamp.from(Instant.now().minusSeconds(172800L)))))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{qDaten.entfernung.asc(), qDaten.id.asc()})).fetch();
        String string = "found " + list.size() + " objects for online update";
        this.logger.info(string);
        System.out.println(string);
        return list;
    }

    private Optional<Long> getGaiaDr2Id(List<String> list) {
        for (String string : list) {
            if (!string.startsWith("Gaia DR2 ")) continue;
            long l = Long.parseLong(string.substring(9));
            return Optional.of(l);
        }
        return Optional.empty();
    }

    private Optional<Long> getGaiaDr3Id(List<String> list) {
        for (String string : list) {
            if (!string.startsWith("Gaia DR3 ")) continue;
            long l = Long.parseLong(string.substring(9));
            return Optional.of(l);
        }
        return Optional.empty();
    }

    private Optional<Long> getTicId(List<String> list) {
        for (String string : list) {
            if (!string.startsWith("TIC ")) continue;
            long l = Long.parseLong(string.substring(4));
            return Optional.of(l);
        }
        return Optional.empty();
    }

    private Optional<Long> getKicId(List<String> list) {
        for (String string : list) {
            if (!string.startsWith("KIC ") || string.endsWith("A") || string.endsWith("B")) continue;
            long l = Long.parseLong(string.substring(4));
            return Optional.of(l);
        }
        return Optional.empty();
    }

    private Optional<VizierTicCatalogDto> convertToTic(Optional<GaiaStellarDataDto> optional) {
        GaiaStellarDataDto gaiaStellarDataDto = optional.get();
        VizierTicCatalogDto vizierTicCatalogDto = new VizierTicCatalogDto();
        if (gaiaStellarDataDto.distanceGspphotInPc() > 0.0) {
            vizierTicCatalogDto.setDistanceInPc(gaiaStellarDataDto.distanceGspphotInPc());
        }
        if (gaiaStellarDataDto.massFlame() > 0.0) {
            vizierTicCatalogDto.setMass(gaiaStellarDataDto.massFlame());
        }
        if (gaiaStellarDataDto.radiusFlame() > 0.0) {
            vizierTicCatalogDto.setRadius(gaiaStellarDataDto.radiusFlame());
        } else if (gaiaStellarDataDto.radiusGspphot() > 0.0) {
            vizierTicCatalogDto.setRadius(gaiaStellarDataDto.radiusGspphot());
        }
        if (gaiaStellarDataDto.teffGspphot() > 0.0) {
            vizierTicCatalogDto.setTemperatureInKelvin(gaiaStellarDataDto.teffGspphot());
        } else if (gaiaStellarDataDto.teffGspspec() > 0.0) {
            vizierTicCatalogDto.setTemperatureInKelvin(gaiaStellarDataDto.teffGspspec());
        }
        return Optional.of(vizierTicCatalogDto);
    }
}

