/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import com.google.inject.Injector;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datenbank.DatenbankDialog;
import de.planetensuche.datenbank.DatenbankDialogControler;
import de.planetensuche.datenbank.EntferneObjekte;
import de.planetensuche.datenbank.StarDataOnlineUpdater;
import de.planetensuche.datenbank.SternbildBildImportierer;
import de.planetensuche.datenbank.api.IStart;
import de.planetensuche.datenbank.dbbereinigung.Mehrfacheintraege;
import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dbmodel.api.ISQLScript;
import de.planetensuche.datenbank.dto.InjectionDto;
import de.planetensuche.datenbank.dto.InjectionDtoFactory;
import de.planetensuche.datenbank.dto.ParameterDto;
import de.planetensuche.datenbank.importierer.csv.CtoiToiCsvImportierer;
import de.planetensuche.datenbank.importierer.gaia.GaiaDataOnlineImportService;
import de.planetensuche.datenbank.importierer.xml.ImportthreadXML;
import de.planetensuche.datenbank.kataloge.Katalogerkenner;
import de.planetensuche.datenbank.phtebs.PhtEbCandidateAnalyzer;
import de.planetensuche.datenbank.reorganisieren.Aufraeumthread;
import de.planetensuche.datenbank.reparatur.Repairthread;
import de.planetensuche.datenbank.webseite.CandidateExoplanetsWebsiteGenerator;
import de.planetensuche.datenbank.webseite.ConfirmedExoplanetsWebsiteGenerator;
import de.planetensuche.datenbank.webseite.ExoplanetenJagdtWebseitengenerator;
import de.planetensuche.datenbank.xmlschema.XmlSchemaService;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.Datenbanksteuerer;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.IZwischentabellenRepository;
import de.planetensuche.datenbankkern.impl.Datenbankmigrator;
import de.planetensuche.datenbankkern.impl.repos.KategorienRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.guidesigner.IPlanetensucheModul;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import javax.swing.JOptionPane;

public final class Start
implements IStart,
IPlanetensucheModul {
    private final ILogging logger;
    private final ISprachcontainer i18n;
    private final AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor;
    private ParameterDto parameter;
    private DatenbankDialogControler datenbankDialogControler;
    private SternbildSprache sternbildSprache;
    private KoordinatenFormat koordinatenFormat;
    private static boolean sqlExport;
    private static boolean backupWiderHerstellen;
    private static boolean neuesXmlSchemaErstellen;
    private static boolean eintraegeAnalysieren;
    private static boolean eintraegeLoeschen;
    private static boolean importiereBilder;
    private static boolean importCtoi;
    private static boolean exportCtoi;
    private static boolean exportConfirmed;
    private static boolean exportWebsite;
    private static boolean gaiaDataDownload;
    private static int gaiaDataDownloadLimit;
    private static boolean phtEbAnalysis;
    private static int phtEbAnalysisLimit;
    private static boolean starUpdate;
    private static int starUpdateLimit;
    private static String importFile;
    private static String importSqlFile;
    private final KonfigurationDTO konfigurationDTO;

    public Start(KonfigurationDTO konfigurationDTO) {
        this.konfigurationDTO = konfigurationDTO;
        this.logger = LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG);
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
    }

    public KoordinatenFormat getKoordinatenFormat() {
        return this.koordinatenFormat;
    }

    @Override
    public void exitApp() {
        boolean bl;
        boolean bl2 = bl = importFile != null || importiereBilder || importSqlFile != null || importCtoi || gaiaDataDownload || phtEbAnalysis || starUpdate;
        if (bl || exportCtoi || eintraegeAnalysieren || neuesXmlSchemaErstellen || backupWiderHerstellen) {
            DatenbankDialog datenbankDialog = null;
            if (this.datenbankDialogControler != null) {
                datenbankDialog = this.datenbankDialogControler.getDatenbankDialog();
            }
            this.asyncLoadingScreenCallbackExecutor.execute(datenbankDialog, () -> {
                try {
                    Datenbanksteuerer.schliessen();
                }
                catch (SQLException sQLException) {
                    this.logger.error(sQLException);
                }
                this.logger.info("Database shutdown war erfolgreich");
                System.exit(0);
            });
        }
    }

    @Override
    public SternbildSprache getSternbildSprache() {
        return this.sternbildSprache;
    }

    public ISprachcontainer getSprachklasse() {
        return this.i18n;
    }

    @Override
    public void setSternbildSprache(SternbildSprache sternbildSprache) {
        this.sternbildSprache = sternbildSprache;
        BeanFactory.getInstance().setSternbildsprache(this.sternbildSprache);
    }

    public void error(Exception exception, String string, String string2, boolean bl) {
        if (exception != null && !string2.isEmpty()) {
            this.logger.warn(string2);
        } else if (exception == null && !string2.isEmpty()) {
            this.logger.info(string2);
        }
        if (exception != null && string.isEmpty()) {
            this.logger.error(exception);
        } else if (exception != null && !string.isEmpty()) {
            this.logger.error(string, exception);
        } else if (exception == null && !string.isEmpty()) {
            this.logger.info(string);
        }
        if (bl) {
            JOptionPane.showMessageDialog(null, string, string2, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] stringArray) throws IOException {
        Object object;
        if ("-sqlexport".equals(stringArray[0])) {
            sqlExport = true;
        } else if ("-doppelte".equals(stringArray[0])) {
            eintraegeAnalysieren = true;
            if (stringArray.length > 1) {
                eintraegeLoeschen = Boolean.parseBoolean(stringArray[1]);
            }
        } else if ("-backup".equals(stringArray[0])) {
            backupWiderHerstellen = true;
        } else if ("-import".equals(stringArray[0]) && stringArray.length == 2) {
            object = new File(stringArray[1]);
            if (!((File)object).exists()) {
                throw new IllegalArgumentException("Die Datei " + ((File)object).getAbsolutePath() + " existiert nicht!");
            }
            importFile = ((File)object).getAbsolutePath();
        } else if ("-s".equals(stringArray[0])) {
            neuesXmlSchemaErstellen = true;
        } else if ("-importpics".equals(stringArray[0])) {
            importiereBilder = true;
        } else if ("-sql".equals(stringArray[0])) {
            object = new File(stringArray[1]);
            if (!((File)object).exists()) {
                System.out.println("Die Datei '" + stringArray[1] + "' existiert nicht!");
                System.out.println("File '" + stringArray[1] + "' not exists!");
                throw new IllegalArgumentException();
            }
            importSqlFile = ((File)object).getAbsolutePath();
        } else if ("-webseite".equals(stringArray[0])) {
            exportWebsite = true;
        } else if ("-import_ctoi".equals(stringArray[0])) {
            importCtoi = true;
        } else if ("-webseite_ctoi".equals(stringArray[0])) {
            exportCtoi = true;
        } else if ("-webseite_confirmed".equals(stringArray[0])) {
            exportConfirmed = true;
        } else if ("-gaia_download".equals(stringArray[0])) {
            gaiaDataDownload = true;
            gaiaDataDownloadLimit = stringArray.length == 2 ? Integer.parseInt(stringArray[1]) : 10;
        } else if ("-pht_eb_analysis".equals(stringArray[0])) {
            phtEbAnalysis = true;
            phtEbAnalysisLimit = stringArray.length == 2 ? Integer.parseInt(stringArray[1]) : 1;
        } else {
            if (!"-star_update".equals(stringArray[0])) {
                throw new IllegalArgumentException("unbekannter Parameter: " + Arrays.toString(stringArray));
            }
            starUpdate = true;
            starUpdateLimit = stringArray.length == 2 ? Integer.parseInt(stringArray[1]) : 10;
        }
        object = KonfiguratorFabrik.getKonfigurator();
        KonfigurationDTO konfigurationDTO = object.getDefault();
        Start start = new Start(konfigurationDTO);
        start.showDialog();
    }

    @Override
    public void showDialog() {
        if (this.datenbankDialogControler != null) {
            this.datenbankDialogControler.showDialog();
            return;
        }
        this.logger.info("Datenbank gestartet");
        this.logger.info("Einstellungen laden...");
        this.koordinatenFormat = this.konfigurationDTO.getKoordinatenFormat();
        this.sternbildSprache = this.konfigurationDTO.getSternbildSprache();
        this.asyncLoadingScreenCallbackExecutor.execute(null, () -> {
            Injector injector = de.planetensuche.datenbank.dbmodel.BeanFactory.getInjector();
            this.asyncLoadingScreenCallbackExecutor.disableWaitingDialog();
            this.detectStartModeAndShowDialog(injector);
        });
    }

    private void detectStartModeAndShowDialog(Injector injector) {
        Object object;
        this.parameter = new ParameterDto(this.i18n, this.sternbildSprache, injector.getInstance(KategorienRepository.class));
        if (backupWiderHerstellen) {
            object = new Repairthread(null, this, this.parameter, injector.getInstance(IDAOhighService.class), injector.getInstance(ISQLScript.class));
            ((Thread)object).start();
            while (((Thread)object).isAlive()) {
                this.logger.debug("");
            }
        }
        if (sqlExport) {
            this.runDbSqlExport(injector);
            this.exitApp();
        } else if (eintraegeAnalysieren) {
            object = new Mehrfacheintraege(injector.getInstance(IObjektnamenRepository.class));
            ((Mehrfacheintraege)object).pruefeDeepSky();
            ((Mehrfacheintraege)object).pruefeKoordinaten();
            ((Mehrfacheintraege)object).pruefePlaneten();
            this.exitApp();
        } else if (neuesXmlSchemaErstellen) {
            object = injector;
            Datenbankmigrator datenbankmigrator = object.getInstance(Datenbankmigrator.class);
            try {
                this.logger.info("aktuelle DB Schema Version: " + datenbankmigrator.getDatenbankVersion());
            }
            catch (SQLException sQLException) {
                this.logger.error(sQLException);
                this.exitApp();
            }
            XmlSchemaService xmlSchemaService = new XmlSchemaService(object.getInstance(IEntdeckungsmethodenRepository.class), object.getInstance(IKategorienRepository.class), this.konfigurationDTO);
            xmlSchemaService.generiereXMLSchema();
            this.exitApp();
        } else if (importiereBilder) {
            SternbildBildImportierer.importiereDatei(injector.getInstance(IZwischentabellenRepository.class));
            this.exitApp();
        } else if (importCtoi) {
            object = de.planetensuche.datenbank.dbmodel.BeanFactory.getInjector();
            InjectionDto injectionDto = InjectionDtoFactory.createInjectionDto((Injector)object);
            Katalogerkenner katalogerkenner = injectionDto.getKatalogerkenner();
            try {
                CtoiToiCsvImportierer ctoiToiCsvImportierer = new CtoiToiCsvImportierer(this.parameter, injectionDto, katalogerkenner, null, "temp", this.konfigurationDTO, true);
                ctoiToiCsvImportierer.importiereCsvDatei();
            }
            catch (IOException iOException) {
                this.logger.error(iOException);
            }
            this.exitApp();
        } else if (exportCtoi) {
            object = new CandidateExoplanetsWebsiteGenerator();
            ((CandidateExoplanetsWebsiteGenerator)object).generiereKandidatenWebseite();
            this.exitApp();
        } else if (exportConfirmed) {
            object = new ConfirmedExoplanetsWebsiteGenerator();
            ((ConfirmedExoplanetsWebsiteGenerator)object).generiereKandidatenWebseite();
            this.exitApp();
        } else if (exportWebsite) {
            new ExoplanetenJagdtWebseitengenerator().generiereExoplanetenJagdtWebseite();
            this.exitApp();
        } else if (gaiaDataDownload) {
            new GaiaDataOnlineImportService(injector).downloadAndSave(gaiaDataDownloadLimit);
            this.exitApp();
        } else if (phtEbAnalysis) {
            new PhtEbCandidateAnalyzer(injector).analyze(phtEbAnalysisLimit);
            this.exitApp();
        } else if (starUpdate) {
            new StarDataOnlineUpdater(injector).downloadAndSave(starUpdateLimit);
            this.exitApp();
        } else if (importFile != null) {
            try {
                this.importXmlDatei();
            }
            catch (SQLException sQLException) {
                this.logger.error(sQLException);
            }
        } else if (importSqlFile != null) {
            object = injector.getInstance(ISQLScript.class);
            object.loadSQLScript(new File(importSqlFile), null, null);
            Aufraeumthread aufraeumthread = new Aufraeumthread(true, true, injector.getInstance(IDatenbankverbinder.class));
            aufraeumthread.dbAufraeumenStarten();
            this.exitApp();
        } else {
            this.asyncLoadingScreenCallbackExecutor.execute(null, () -> {
                try {
                    this.datenbankDialogControler = new DatenbankDialogControler(backupWiderHerstellen, this, this.parameter, this.konfigurationDTO, this.koordinatenFormat, injector);
                    this.datenbankDialogControler.showDialog();
                }
                catch (IOException iOException) {
                    this.logger.error(iOException);
                }
            });
        }
    }

    private void runDbSqlExport(Injector injector) {
        IDatenbankverbinder iDatenbankverbinder = injector.getInstance(IDatenbankverbinder.class);
        try {
            this.logger.debug("start sql export");
            iDatenbankverbinder.query("SCRIPT 'database" + File.pathSeparator + "db-sql-export.sql'");
            this.logger.debug("sql export erfolgreich beendet");
        }
        catch (IllegalArgumentException | SQLException exception) {
            this.logger.error("create sql backup failed", exception);
        }
    }

    public void importXmlDatei() throws SQLException {
        Object object;
        File file = new File("alt.xml");
        File file2 = new File("neu.xml");
        if (file.exists() && file2.exists() && ((EntferneObjekte)(object = new EntferneObjekte(this.parameter, file, file2, de.planetensuche.datenbank.dbmodel.BeanFactory.getInjector().getInstance(IPlanetensucheObjektRepository.class), de.planetensuche.datenbank.dbmodel.BeanFactory.getInjector().getInstance(IObjektnamenRepository.class)))).start() && file.delete() && file2.delete()) {
            this.logger.info("alt.xml und neu.xml geloescht!");
        }
        if (((File)(object = new File("updateZusatz.xml"))).exists() && !((File)object).delete()) {
            ((File)object).deleteOnExit();
        }
        Injector injector = de.planetensuche.datenbank.dbmodel.BeanFactory.getInjector();
        InjectionDto injectionDto = InjectionDtoFactory.createInjectionDto(injector);
        Datenbankmigrator datenbankmigrator = injector.getInstance(Datenbankmigrator.class);
        this.logger.info("aktuelle DB Schema Version: " + datenbankmigrator.getDatenbankVersion());
        ImportthreadXML importthreadXML = new ImportthreadXML(new File(importFile), null, this.parameter, this, injectionDto, injector.getInstance(IDatenbankverbinder.class));
        this.logger.info("starte Updateprozess mit " + importFile + "...");
        importthreadXML.start();
    }

    @Override
    public void springeZuObjekt(String string) throws SQLException {
        if (this.datenbankDialogControler != null) {
            this.datenbankDialogControler.springeZuObjekt(string);
        }
    }
}

