/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank;

import com.google.common.io.Files;
import de.planetensuche.datenbankkern.api.repos.IZwischentabellenRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.JOptionPane;

public final class SternbildBildImportierer {
    private SternbildBildImportierer() {
    }

    public static void importiereDatei(IZwischentabellenRepository iZwischentabellenRepository) {
        ILogging iLogging = LoggingFactory.getLoggerForClass(SternbildBildImportierer.class);
        try {
            File file = new File("database" + File.separator + "pics-neu.txt");
            if (!file.exists()) {
                file = new File("database" + File.separator + "pics.txt");
            }
            List<String> list = Files.readLines(file, Charset.forName("UTF-8"));
            for (String string : list) {
                String[] stringArray;
                if (string.startsWith("//") || (stringArray = string.split("::")).length != 2) continue;
                stringArray[0] = stringArray[0].trim();
                stringArray[1] = stringArray[1].trim();
                if (stringArray[0].isEmpty() || stringArray[1].isEmpty()) continue;
                iZwischentabellenRepository.addBildFuerSternbild(stringArray[0], stringArray[1]);
                iLogging.info("Bild " + stringArray[1] + " eingefuegt.");
            }
        }
        catch (Exception exception) {
            iLogging.error(exception);
            JOptionPane.showMessageDialog(null, exception.toString());
        }
    }
}

