/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.berechnungen;

import de.planetensuche.datenbank.PlanetTypeDetectorService;
import java.util.Optional;

public class PlanetTypeByRadiusService
implements PlanetTypeDetectorService {
    @Override
    public String getType(double d) {
        double d2 = 0.0892 * d;
        Optional<String> optional = this.findRockyPlanetClassification(d2);
        if (optional.isPresent()) {
            return optional.get();
        }
        Optional<String> optional2 = this.findGasPlanetClassification(d2);
        if (optional2.isPresent()) {
            return optional2.get();
        }
        return this.findRoughlyClassification(d2);
    }

    private Optional<String> findRockyPlanetClassification(double d) {
        if (d <= 0.017481969269363438) {
            return Optional.of("Mesoplanet");
        }
        if (d <= 0.07136) {
            return Optional.of("sub-Earth");
        }
        if (d <= 0.1115 && d >= 0.07136) {
            return Optional.of("Earth sized");
        }
        if (d >= 0.1115 && d <= 0.1784) {
            return Optional.of("super-Earth");
        }
        return Optional.empty();
    }

    private Optional<String> findGasPlanetClassification(double d) {
        if (d <= 0.346096 && d >= 0.1784) {
            return Optional.of("sub-Neptune");
        }
        if (d <= 0.34788 && d >= 0.2676) {
            return Optional.of("Neptune sized");
        }
        if (d >= 0.3568 && d < 0.892) {
            return Optional.of("sub-Jovian");
        }
        if (d >= 0.892 && d < 1.5) {
            return Optional.of("Jovian");
        }
        return Optional.empty();
    }

    private String findRoughlyClassification(double d) {
        if (d > 1.5 && d < 2.23) {
            return "Jovian or non-planet";
        }
        if (d <= 0.15164) {
            return "rocky planet";
        }
        if (d >= 0.346096 && d <= 2.23) {
            return "gas giant";
        }
        if (d > 2.23) {
            return "brown dwarf / tiny star";
        }
        return "unknown";
    }
}

