/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.berechnungen;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.Temperatur;
import de.planetensuche.datenbank.SptypErmittelnService;
import de.planetensuche.datenbank.SternradiusMasseErgebnisDto;
import de.planetensuche.datenbank.berechnungen.SterneComparator;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.impl.cache.IdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QLumin;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp2;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SptypErmittelnDefaultService
implements SptypErmittelnService {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder connector;
    private final IdCacheDAO idCache;

    @Inject
    public SptypErmittelnDefaultService(IDatenbankverbinder iDatenbankverbinder, IdCacheDAO idCacheDAO) {
        this.connector = iDatenbankverbinder;
        this.idCache = idCacheDAO;
    }

    @Override
    public String findSptyp(double d, double d2) {
        if (d <= 0.0) {
            return "";
        }
        if (d2 == -100.0) {
            return this.findSptypByTemperatur(d);
        }
        return this.findByTemperaturAndAbsMag(d, d2);
    }

    private String findByTemperaturAndAbsMag(double d, double d2) {
        QDaten qDaten = QDaten.daten;
        QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
        QSpektraltyp2 qSpektraltyp2 = QSpektraltyp2.spektraltyp2;
        QLumin qLumin = QLumin.lumin;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.connector.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten.masse, qDaten.temperatur, qDaten.ah, qSpektraltyp.typ, qSpektraltyp2.typ, qLumin.typ}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qSpektraltyp)).on((Predicate)qDaten.spektralklasse.eq(qSpektraltyp.id))).leftJoin((EntityPath)qSpektraltyp2)).on((Predicate)qDaten.spektralklasse2.eq(qSpektraltyp2.id))).leftJoin((EntityPath)qLumin)).on((Predicate)qDaten.lumin.eq(qLumin.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.temperatur.between(d - 1000.0, d + 1000.0).and(qDaten.ah.gt(-100.0))).and(qSpektraltyp.typ.ne("unbekannt")))).fetch();
        this.logger.debug(list.size() + " Datens\u00e4tze gefunden f\u00fcr Temperatur " + d + " und absMag " + d2);
        ArrayList<SternradiusMasseErgebnisDto> arrayList = new ArrayList<SternradiusMasseErgebnisDto>();
        for (Tuple tuple : list) {
            double d3 = tuple.get(qDaten.ah);
            double d4 = tuple.get(qDaten.temperatur);
            SternradiusMasseErgebnisDto sternradiusMasseErgebnisDto = new SternradiusMasseErgebnisDto();
            sternradiusMasseErgebnisDto.setAh(d3);
            sternradiusMasseErgebnisDto.setTemperatur(d4);
            String string = tuple.get(qSpektraltyp.typ);
            if (string != null && !"unbekannt".equals(string)) {
                sternradiusMasseErgebnisDto.setSptyp(string + String.valueOf(tuple.get(qSpektraltyp2.typ)));
                String string2 = tuple.get(qLumin.typ);
                if (string2 != null && !"unbekannt".equals(string2)) {
                    sternradiusMasseErgebnisDto.setSptyp(sternradiusMasseErgebnisDto.getSptyp() + string2);
                }
            }
            arrayList.add(sternradiusMasseErgebnisDto);
        }
        Collections.sort(arrayList, new SterneComparator(d, d2));
        return ((SternradiusMasseErgebnisDto)arrayList.get(0)).getSptyp();
    }

    private String findSptypByTemperatur(double d) {
        Temperatur temperatur = new Temperatur();
        return temperatur.getSpektraltypFuerStern(d, false);
    }
}

