/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.berechnungen;

import de.planetensuche.datenbank.SternradiusMasseErgebnisDto;
import java.util.Comparator;

public class SterneComparator
implements Comparator<SternradiusMasseErgebnisDto> {
    private final double temperaturKelvin;
    private final double absMag;

    public SterneComparator(double d, double d2) {
        this.temperaturKelvin = d;
        this.absMag = d2;
    }

    @Override
    public int compare(SternradiusMasseErgebnisDto sternradiusMasseErgebnisDto, SternradiusMasseErgebnisDto sternradiusMasseErgebnisDto2) {
        double d = sternradiusMasseErgebnisDto.getAh();
        double d2 = sternradiusMasseErgebnisDto.getTemperatur();
        double d3 = sternradiusMasseErgebnisDto2.getAh();
        double d4 = sternradiusMasseErgebnisDto2.getTemperatur();
        double d5 = this.temperaturKelvin > d2 ? this.temperaturKelvin - d2 : d2 - this.temperaturKelvin;
        double d6 = SterneComparator.berechnePunkteAh(this.absMag, d);
        double d7 = this.temperaturKelvin > d4 ? this.temperaturKelvin - d4 : d4 - this.temperaturKelvin;
        double d8 = SterneComparator.berechnePunkteAh(this.absMag, d3);
        if (d5 <= d7 && d6 < d8) {
            return -1;
        }
        if (d5 >= d7 && d6 > d8) {
            return 1;
        }
        if (d5 == d7 && d6 == d8) {
            return 0;
        }
        return Double.compare(d5 + d6 * 10.0, d7 + d8 * 10.0);
    }

    private static double berechnePunkteAh(double d, double d2) {
        if (d > d2) {
            return d - d2;
        }
        return -1.0 * (d - d2);
    }
}

