/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.berechnungen;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datenbank.SternradiusMasseErgebnisDto;
import de.planetensuche.datenbank.SternradiusUndMasseBerechnenService;
import de.planetensuche.datenbank.berechnungen.SterneComparator;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.impl.cache.IdCacheDAO;
import de.planetensuche.datenbankkern.impl.repos.ObjektnamenRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QLumin;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp2;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SternradiusUndMasseBerechnenServiceImpl
implements SternradiusUndMasseBerechnenService {
    private final ILogging logger = LoggingFactory.getLoggerForClass(SternradiusUndMasseBerechnenServiceImpl.class);
    private final IDatenbankverbinder connector;
    private final IdCacheDAO idCache;
    private final ObjektnamenRepository objektnamenRepository;

    @Inject
    public SternradiusUndMasseBerechnenServiceImpl(IDatenbankverbinder iDatenbankverbinder, IdCacheDAO idCacheDAO, ObjektnamenRepository objektnamenRepository) {
        this.connector = iDatenbankverbinder;
        this.idCache = idCacheDAO;
        this.objektnamenRepository = objektnamenRepository;
    }

    @Override
    public List<SternradiusMasseErgebnisDto> sucheRadiusUndMasse(double d, double d2, double d3) {
        double d4 = (5.0 * Math.log10(d3) - 5.0 - d) * -1.0;
        double d5 = Math.sqrt(Math.pow(10.0, -0.4 * (d4 - 4.82))) / Math.pow(d2 / 5778.0, 2.0);
        d5 = (double)Math.round(d5 * 100.0) / 100.0;
        QDaten qDaten = QDaten.daten;
        QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
        QSpektraltyp2 qSpektraltyp2 = QSpektraltyp2.spektraltyp2;
        QLumin qLumin = QLumin.lumin;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.connector.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten.masse, qDaten.temperatur, qDaten.ah, qSpektraltyp.typ, qSpektraltyp2.typ, qLumin.typ}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qSpektraltyp)).on((Predicate)qDaten.spektralklasse.eq(qSpektraltyp.id))).leftJoin((EntityPath)qSpektraltyp2)).on((Predicate)qDaten.spektralklasse2.eq(qSpektraltyp2.id))).leftJoin((EntityPath)qLumin)).on((Predicate)qDaten.lumin.eq(qLumin.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne()).and(qDaten.temperatur.between(d2 * 0.8, d2 * 1.2).and(qDaten.ah.between(d4 - 0.5, d4 + 0.5)).and(qDaten.durchmesser.gt(0.0)).and(qDaten.masse.gt(0.0))))).fetch();
        this.logger.debug(list.size() + " Datens\u00e4tze gefunden f\u00fcr Temperatur " + d2 + " und absMag " + d4);
        ArrayList<SternradiusMasseErgebnisDto> arrayList = new ArrayList<SternradiusMasseErgebnisDto>();
        for (Tuple tuple : list) {
            double d6 = tuple.get(qDaten.durchmesser);
            double d7 = tuple.get(qDaten.masse);
            double d8 = tuple.get(qDaten.ah);
            double d9 = tuple.get(qDaten.temperatur);
            SternradiusMasseErgebnisDto sternradiusMasseErgebnisDto = new SternradiusMasseErgebnisDto();
            sternradiusMasseErgebnisDto.setMasse(d7);
            sternradiusMasseErgebnisDto.setRadiusNachbar(d6);
            sternradiusMasseErgebnisDto.setRadiusBolzmann(d5);
            sternradiusMasseErgebnisDto.setAhInput(d4);
            sternradiusMasseErgebnisDto.setAh(d8);
            sternradiusMasseErgebnisDto.setTemperatur(d9);
            int n = tuple.get(qDaten.id);
            List<String> list2 = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.BEKANNTHEIT);
            sternradiusMasseErgebnisDto.setName(list2.get(0));
            String string = tuple.get(qSpektraltyp.typ);
            if (string != null && !"unbekannt".equals(string)) {
                sternradiusMasseErgebnisDto.setSptyp(string + String.valueOf(tuple.get(qSpektraltyp2.typ)));
                String string2 = tuple.get(qLumin.typ);
                if (string2 != null && !"unbekannt".equals(string2)) {
                    sternradiusMasseErgebnisDto.setSptyp(sternradiusMasseErgebnisDto.getSptyp() + string2);
                }
            }
            arrayList.add(sternradiusMasseErgebnisDto);
        }
        Collections.sort(arrayList, new SterneComparator(d2, d4));
        return arrayList;
    }
}

