/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbbereinigung;

import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankfassadeBasis;
import de.planetensuche.datenbankkern.helfer.Konverter;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Tabellenstruktur;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class AktualisiereDatenDAO
extends Tabellenstruktur {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankfassadeBasis dao = BeanFactory.getInstanceBasis();

    public boolean berechneBahngeschwindigkeit() {
        try {
            System.out.println("Berechne Bahngeschwindigkeit aller Planeten...");
            List<Integer> list = this.dao.getListeMitInt("SELECT id FROM objekttypen WHERE kategorieid=(SELECT id FROM kategorie WHERE name='" + ObjektKategorie.PLANETEN.getKategorienName() + "');", "id");
            for (int i = 0; i < list.size(); ++i) {
                String[] stringArray = new String[]{"id", "entfernung", "umlaufszeit"};
                String[][] stringArray2 = Konverter.convertListStringToArray(this.dao.getListeMitStrings("SELECT id, entfernung, umlaufszeit FROM daten WHERE objektid=" + String.valueOf(list.get(i)) + " AND entfernung>0.0 AND umlaufszeit>0.0;", stringArray, ""));
                for (int j = 0; j < stringArray2.length; ++j) {
                    try {
                        int n = Integer.parseInt(stringArray2[j][0]);
                        double d = Double.parseDouble(stringArray2[j][1]);
                        double d2 = Double.parseDouble(stringArray2[j][2]);
                        double d3 = d * 1.496E8;
                        double d4 = d2 * 86400.0;
                        double d5 = Math.PI * 2 * d3 / d4;
                        d5 = (double)Math.round(d5 * 100.0) / 100.0;
                        if (this.dao.executeQuery("UPDATE daten SET geschwindigkeit=" + d5 + ", autor='Gerd Guehne', stamp='" + String.valueOf(new Timestamp(System.currentTimeMillis())) + "' WHERE id=" + n + ";")) continue;
                        this.logging.error("Fehler in berechneBahngeschwindigkeit() beim Aktualisieren der Bahngeschwindigkeit", null);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.logging.error(sQLException);
                    }
                }
            }
            return true;
        }
        catch (SQLException sQLException) {
            this.logging.error("berechneBahngeschwindigkeit()", sQLException);
            return false;
        }
    }

    public boolean berechneDurchmesser() {
        try {
            System.out.println("Berechne Durchmesser aller Sterne neu...");
            String[] stringArray = new String[]{"id", "temperatur", "ah"};
            String[][] stringArray2 = Konverter.convertListStringToArray(this.dao.getListeMitStrings("SELECT d.id, d.temperatur, d.ah FROM daten AS d, lumin AS l WHERE d.objektid IN (SELECT id FROM objekttypen WHERE kategorieid=(SELECT id FROM kategorie WHERE name='" + ObjektKategorie.STERNE.getKategorienName() + "')) AND d.lumin IN (SELECT id FROM lumin WHERE typ='V') AND d.temperatur>0.0 AND d.ah>-100.0 AND d.id!=(SELECT datenid FROM namen WHERE Namen='Sonne');", stringArray, ""));
            for (int i = 0; i < stringArray2.length; ++i) {
                try {
                    int n = Integer.parseInt(stringArray2[i][0]);
                    double d = Double.parseDouble(stringArray2[i][1]);
                    double d2 = Double.parseDouble(stringArray2[i][2]);
                    double d3 = Math.sqrt(Math.pow(10.0, -0.4 * (d2 - 4.82))) / Math.pow(d / 5785.0, 2.0);
                    d3 = (double)Math.round(d3 * 1000.0) / 1000.0;
                    if (this.dao.executeQuery("UPDATE daten SET durchmesser=" + d3 + ", autor='Gerd Guehne', stamp='" + String.valueOf(new Timestamp(System.currentTimeMillis())) + "' WHERE id=" + n + ";")) continue;
                    this.logging.error("Fehler in berechneDurchmesser() beim Aktualisieren des Durchmessers", null);
                    continue;
                }
                catch (SQLException sQLException) {
                    this.logging.error(sQLException);
                }
            }
            return true;
        }
        catch (SQLException sQLException) {
            this.logging.error("berechneDurchmesser()", sQLException);
            return false;
        }
    }
}

