/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbbereinigung;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import de.planetensuche.core.Check;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.EntdeckerTyp;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QEntdecker;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public final class KorrigiereEntdeckerTabelleDAO {
    private final ILogging logging;
    private final IDatenbankverbinder datenbankverbinder;
    private final QEntdecker qEntdecker = QEntdecker.entdecker;
    private final QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;

    public KorrigiereEntdeckerTabelleDAO(IDatenbankverbinder iDatenbankverbinder) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
    }

    public void findeUndLoescheUngenutzteEntdecker(boolean bl) throws SQLException {
        List list = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qEntdecker).where(this.qEntdecker.id.notIn((SubQueryExpression<Integer>)SQLExpressions.selectDistinct(this.qZtentdecker.entdeckerid).from((Expression<?>)this.qZtentdecker)).and(this.qEntdecker.typ.isNull().or(this.qEntdecker.typ.eq(EntdeckerTyp.PERSON.getType()))))).fetch();
        if (Check.isEmpty(list)) {
            return;
        }
        for (Entdecker entdecker : list) {
            this.logging.info("Entdecker " + String.valueOf(entdecker) + " wird nirgends verwendet!");
            if (!bl) continue;
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(this.qEntdecker).where((Predicate)this.qEntdecker.id.eq(entdecker.getId()))).execute();
            this.logging.info("Entdecker " + String.valueOf(entdecker) + " wurde gel\u00f6scht, da unbenutzt!");
        }
    }

    public void findeUndLoescheEntdeckerMitFehlerhafterDatenid(boolean bl) throws SQLException {
        QDaten qDaten = QDaten.daten;
        List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qZtentdecker.id).from((Expression<?>)this.qZtentdecker)).where(this.qZtentdecker.datenid.notIn((SubQueryExpression<Integer>)SQLExpressions.select(qDaten.id).from((Expression<?>)qDaten)).or(this.qZtentdecker.entdeckerid.notIn((SubQueryExpression<Integer>)SQLExpressions.select(this.qEntdecker.id).from((Expression<?>)this.qEntdecker))))).fetch();
        if (Check.isEmpty(list)) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.logging.info("Id " + n + " in Entdecker-Zt-Tabelle verweist auf nicht mehr existierende Objekte!");
            if (!bl) continue;
            ((SQLDeleteClause)this.datenbankverbinder.getNewSqlDeleteClause(this.qZtentdecker).where((Predicate)this.qZtentdecker.id.eq(n))).execute();
        }
    }
}

