/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbbereinigung;

import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.helfer.Konverter;
import de.planetensuche.datenbankkern.impl.tabellenmanipulation.Tabellenstruktur;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class MehrfacheintraegeDAO
extends Tabellenstruktur {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankService dao = BeanFactory.getInstance();
    private final IObjektnamenRepository objektnamenRepository;

    protected MehrfacheintraegeDAO(IObjektnamenRepository iObjektnamenRepository) {
        this.objektnamenRepository = iObjektnamenRepository;
    }

    protected List<String> getMehrfacheintraegeDeepSky() throws SQLException {
        String[] stringArray = new String[]{"entfernung", "sh", "Typ", "id"};
        String[][] stringArray2 = Konverter.convertListStringToArray(this.dao.getListeMitStrings("SELECT d.id,d.entfernung,d.sh,o.Typ FROM daten AS d,objekttypen AS o WHERE o.id=d.objektid AND d.entfernung>0.0 AND d.sh>-100.0;", stringArray, ";"), stringArray.length, ";");
        return this.ersetzeDatenidDurchObjektnamen(stringArray2, stringArray.length, ";");
    }

    protected List<String> getMehrfacheintraegePlaneten() throws SQLException {
        String[] stringArray = new String[]{"entfernung", "masse", "umlaufszeit", "id"};
        String[][] stringArray2 = Konverter.convertListStringToArray(this.dao.getListeMitStrings("SELECT id,entfernung,masse,umlaufszeit FROM daten WHERE entfernung>0.0 AND masse>0.0 AND umlaufszeit>0.0;", stringArray, ";"), stringArray.length, ";");
        return this.ersetzeDatenidDurchObjektnamen(stringArray2, stringArray.length, ";");
    }

    protected List<String> getMehrfacheintraegeKoordinaten() throws SQLException {
        String[] stringArray = new String[]{"ra", "decl", "id"};
        String[][] stringArray2 = Konverter.convertListStringToArray(this.dao.getListeMitStrings("SELECT id,ra,decl FROM daten WHERE ra>0.0 AND DECL!=0.0;", stringArray, ";"), stringArray.length, ";");
        return this.ersetzeDatenidDurchObjektnamen(stringArray2, stringArray.length, ";");
    }

    protected List<String> ersetzeDatenidDurchObjektnamen(String[][] stringArray, int n, String string) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        try {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                StringBuilder stringBuilder = new StringBuilder();
                for (n3 = 0; n3 < n; ++n3) {
                    if (n3 == n - 1) {
                        stringBuilder.append(this.objektnamenRepository.getNamenByDatenId(Integer.parseInt(stringArray[n2][n3]), ObjektnamenSortierung.KEINE_SORTIERUNG).get(0));
                        continue;
                    }
                    stringBuilder.append(stringArray[n2][n3]).append(string);
                }
                arrayList.add(stringBuilder.toString());
            }
            return arrayList;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.logging.error("ersetzeDatenID(" + stringArray.length + "," + n + "," + string + ") bei i=" + n2 + " und k=" + n3, arrayIndexOutOfBoundsException);
            return new ArrayList<String>();
        }
        catch (NumberFormatException numberFormatException) {
            this.logging.error("ersetzeDatenID(" + stringArray.length + "," + n + "," + string + ") wegen '" + stringArray[n2][n3] + "'", numberFormatException);
            return new ArrayList<String>();
        }
    }
}

