/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.basis;

import de.planetensuche.datenbank.dbmodel.api.IBerechnungDurchschnittDAO;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public final class BerechnungDurchschnittDAO
implements IBerechnungDurchschnittDAO {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());

    @Override
    public double berechneDurchschnittScheinbareHelligkeit(Collection<Integer> collection) {
        return this.berechneDurchschnitt(collection, "sh", -100.0);
    }

    @Override
    public double berechneDurchschnittBV(Collection<Integer> collection) {
        return this.berechneDurchschnitt(collection, "bv", -100.0);
    }

    @Override
    public double berechneDurchschnittMetal(Collection<Integer> collection) {
        return this.berechneDurchschnitt(collection, "metallizitaet", -100.0);
    }

    @Override
    public double berechneDurchschnittRadialgeschwindigkeit(Collection<Integer> collection) {
        return this.berechneDurchschnitt(collection, "geschwindigkeit", 0.0);
    }

    @Override
    public double berechneDurchschnittsAlter(Collection<Integer> collection) {
        try {
            if (collection.isEmpty()) {
                return 0.0;
            }
            StringBuilder stringBuilder = new StringBuilder(collection.size() * 2);
            for (Integer list2 : collection) {
                stringBuilder.append(list2).append(", ");
            }
            String string = stringBuilder.substring(0, stringBuilder.length() - 2);
            List<Double> list = BeanFactory.getInstance().getListeMitDouble("SELECT a.alter FROM objektalter AS a, daten AS d WHERE d.id IN (" + (String)string + ") AND d.id=a.datenid;", "alter");
            if (list.isEmpty()) {
                return 0.0;
            }
            double d = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                d += list.get(i).doubleValue();
            }
            return (double)Math.round((d /= (double)list.size()) * 1000.0) / 1000.0;
        }
        catch (SQLException sQLException) {
            this.logging.error("berechneDurchschnittsAlter(" + collection.size() + ")", sQLException);
            return 0.0;
        }
    }

    private double berechneDurchschnitt(Collection<Integer> collection, String string, double d) {
        try {
            if (collection.isEmpty()) {
                return -100.0;
            }
            StringBuilder stringBuilder = new StringBuilder(collection.size() * 2);
            for (Integer list2 : collection) {
                stringBuilder.append(list2).append(", ");
            }
            String string2 = stringBuilder.substring(0, stringBuilder.length() - 2);
            List<Double> list = BeanFactory.getInstance().getListeMitDouble("SELECT " + string + " FROM daten WHERE id IN (" + (String)string2 + ") AND " + string + "!=" + d + ";", string);
            if (list.isEmpty()) {
                return -100.0;
            }
            double d2 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                d2 += list.get(i).doubleValue();
            }
            return (double)Math.round((d2 /= (double)list.size()) * 1000.0) / 1000.0;
        }
        catch (SQLException sQLException) {
            this.logging.error("berechneDurchschnitt(" + collection.size() + "," + string + "," + d + ")", sQLException);
            return -100.0;
        }
    }
}

