/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbank.dbmodel.api.IDAOhighService;
import de.planetensuche.datenbank.dbmodel.api.IReparaturDialog;
import de.planetensuche.datenbank.dbmodel.api.ObjectChangeLogDto;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QNotizen;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.datenbankkern.querydsl5.QZtentdecker;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.swing.JFrame;

public final class DAOhighService
implements IDAOhighService {
    private final ISprachcontainer i18n;
    private final ILogging logger;
    private final IObjektnamenRepository objektnamenRepository;
    private final IKategorienRepository kategorienRepository;
    private final IDatenbankService datenbankService;
    private final IDatenbankverbinder datenbankverbinder;
    private final QDaten qDaten = QDaten.daten;
    private final QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
    private final QKategorie qKategorie = QKategorie.kategorie;
    private final Set<String> objektnamenCache;

    @Inject
    public DAOhighService(IObjektnamenRepository iObjektnamenRepository, IKategorienRepository iKategorienRepository, IDatenbankService iDatenbankService, IDatenbankverbinder iDatenbankverbinder) {
        this.logger = LoggingFactory.getLoggerForClass(DAOhighService.class);
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.objektnamenRepository = iObjektnamenRepository;
        this.kategorienRepository = iKategorienRepository;
        this.datenbankService = iDatenbankService;
        this.datenbankverbinder = iDatenbankverbinder;
        this.objektnamenCache = new HashSet<String>();
    }

    public void sucheFehlerhafteDaten() {
        try {
            if (this.logger.isDebugEnabled()) {
                long l = System.currentTimeMillis();
                this.searchNonUpdatedStars();
                this.logger.debug("suche Sterne die lange nicht aktualisiert wurden dauerte " + (System.currentTimeMillis() - l) + " ms");
                l = System.currentTimeMillis();
                this.searchNonUpdatedExoplanets();
                this.logger.debug("suche exoplaneten die lange nicht aktualisiert wurden dauerte " + (System.currentTimeMillis() - l) + " ms");
                l = System.currentTimeMillis();
                this.findeExoplanetenOhneEntdecker();
                this.logger.debug("suche exoplaneten ohne entdecker dauerte " + (System.currentTimeMillis() - l) + " ms");
                l = System.currentTimeMillis();
                this.findeExoplanetenOhneStern();
                this.logger.debug("suche exoplaneten ohne stern dauerte " + (System.currentTimeMillis() - l) + " ms");
                l = System.currentTimeMillis();
                this.findeExoplanetenOhneEntdeckungsjahr();
                this.logger.debug("suche exoplaneten ohne entdeckungsjahr dauerte " + (System.currentTimeMillis() - l) + " ms");
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
    }

    @Override
    public long countNichtBestaetigteExoplaneten() throws SQLException {
        QNamen qNamen = QNamen.namen1;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qDaten).where(this.qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(this.qObjekttypen.id).from((Expression<?>)this.qObjekttypen)).where(this.qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(ObjektKategorie.PLANETEN.getKategorienName()))))).and(this.qDaten.entdeckungbestaetigt.isFalse()).and(this.qDaten.zugehoerigkeit.ne((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("Sonne")))))).fetchCount();
        return l;
    }

    @Override
    public long countBestaetigteExoplaneten() {
        QNamen qNamen = QNamen.namen1;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qDaten).where(this.qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(this.qObjekttypen.id).from((Expression<?>)this.qObjekttypen)).where(this.qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(ObjektKategorie.PLANETEN.getKategorienName()))))).and(this.qDaten.entdeckungbestaetigt.isTrue()).and(this.qDaten.zugehoerigkeit.ne((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("Sonne")))))).fetchCount();
        return l;
    }

    @Override
    public long countUnserSonnensystem() {
        QNamen qNamen = QNamen.namen1;
        long l = ((SQLQuery)this.datenbankverbinder.getQueryFactory().selectFrom((RelationalPath)this.qDaten).where(this.qDaten.zugehoerigkeit.eq((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("Sonne"))).and(this.qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(this.qObjekttypen.id).from((Expression<?>)this.qObjekttypen)).where(this.qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(ObjektKategorie.PLANETEN.getKategorienName())))))))).fetchCount();
        return l;
    }

    private void findeExoplanetenOhneEntdecker() {
        try {
            this.logger.debug("Suche nach Exoplaneten ohne Entdecker...");
            QZtentdecker qZtentdecker = QZtentdecker.ztentdecker;
            QNamen qNamen = QNamen.namen1;
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(this.qObjekttypen.id).from((Expression<?>)this.qObjekttypen)).where(this.qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(ObjektKategorie.PLANETEN.getKategorienName()))))).and(this.qDaten.id.notIn((SubQueryExpression<Integer>)SQLExpressions.select(qZtentdecker.datenid).from((Expression<?>)qZtentdecker))).and(this.qDaten.zugehoerigkeit.ne((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("Sonne")))).and(this.qDaten.entdeckungbestaetigt.isTrue()))).fetch();
            for (Integer n : list) {
                String string = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.KEINE_SORTIERUNG).get(0);
                this.logger.debug("Keine Entdecker fuer den Exoplaneten '" + string + "' gefunden!");
            }
            this.logger.debug("Suche erfolgreich beendet!");
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
    }

    public boolean findeExoplanetenOhneStern() {
        try {
            this.logger.debug("Suche nach Exoplaneten ohne Stern/Br. Zwerg...");
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(this.qObjekttypen.id).from((Expression<?>)this.qObjekttypen)).where(this.qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(ObjektKategorie.PLANETEN.getKategorienName()))))).and(this.qDaten.zugehoerigkeit.isNull()))).fetch();
            boolean bl = false;
            for (Integer n : list) {
                String string = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.KEINE_SORTIERUNG).get(0);
                this.logger.debug("Keinen Stern oder Braunen Zwerg fuer den Exoplaneten '" + string + "' gefunden!");
                bl = true;
            }
            this.logger.debug("Suche erfolgreich beendet!");
            return bl;
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
            return false;
        }
    }

    private void fillCacheIfNeeded() {
        try {
            if (!this.objektnamenCache.isEmpty()) {
                return;
            }
            long l = System.currentTimeMillis();
            this.updateObjektnamenCache();
            this.logger.debug("update objektnamen cache dauerte " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (RuntimeException | SQLException exception) {
            this.logger.error(exception);
            throw new IllegalStateException(exception);
        }
    }

    @Override
    public int isObjektInDatenbankCache(String string) throws SQLException {
        this.fillCacheIfNeeded();
        if (this.objektnamenCache.contains(string)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int isObjektInDatenbankCache(List<String> list) throws SQLException {
        if (list.isEmpty()) {
            return -1;
        }
        this.fillCacheIfNeeded();
        int n = 0;
        for (String string : list) {
            if (!this.objektnamenCache.contains(string)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public synchronized void updateObjektnamenCache() throws SQLException {
        List<String> list = this.objektnamenRepository.getAllNames(false);
        if (Check.isFilled(list)) {
            this.logger.debug("update cache mit " + list.size() + " objektnamen");
            this.objektnamenCache.clear();
            this.objektnamenCache.addAll(list);
        } else {
            this.objektnamenCache.clear();
        }
    }

    @Override
    public List<String> getKategorien() throws SQLException {
        return this.kategorienRepository.getKategorien();
    }

    @Override
    public long countKategorie(String string) throws SQLException {
        if (ObjektKategorie.STERNBILDER.getKategorienName().equals(string)) {
            return 88L;
        }
        return this.kategorienRepository.getAnzahl(string);
    }

    @Override
    public List<ObjectChangeLogDto> getObjectChangeLog(int n) {
        ArrayList<ObjectChangeLogDto> arrayList = new ArrayList<ObjectChangeLogDto>();
        try {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.stamp}).from((Expression<?>)this.qDaten)).orderBy((OrderSpecifier<?>)this.qDaten.stamp.desc())).limit(n)).fetch();
            for (Tuple tuple : list) {
                int n2 = tuple.get(0, Integer.class);
                String string = this.objektnamenRepository.getNamenByDatenId(n2, ObjektnamenSortierung.KEINE_SORTIERUNG).get(0);
                Timestamp timestamp = tuple.get(1, Timestamp.class);
                ObjectChangeLogDto objectChangeLogDto = new ObjectChangeLogDto();
                objectChangeLogDto.setObjectName(string);
                objectChangeLogDto.setTimestamp(timestamp);
                objectChangeLogDto.setTimestampI18n(this.i18n.toLocalisedDateTime(timestamp));
                arrayList.add(objectChangeLogDto);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error("error in getObjectChangeLog(" + n + "): " + runtimeException.toString(), runtimeException);
        }
        return arrayList;
    }

    @Override
    public String getZufallsObjekt() throws SQLException {
        List<Integer> list = this.getDatenids(true, false);
        if (list.isEmpty()) {
            return "";
        }
        Random random = new Random();
        int n = random.nextInt(list.size());
        if (n > -1 && n < list.size()) {
            this.logger.info("Zufallszahl: " + n + ", datenid: " + String.valueOf(list.get(n)) + ", ids-size: " + list.size());
            String string = this.objektnamenRepository.getNamenByDatenId(list.get(n), ObjektnamenSortierung.KEINE_SORTIERUNG).get(0);
            this.logger.info("Zufallszahl: " + n + ", datenid: " + String.valueOf(list.get(n)) + ", Objektname: " + string);
            return string;
        }
        this.logger.warn("Zufallszahl ungeeignet: " + n);
        return "Merkur";
    }

    @Override
    public List<Integer> getDatenids(boolean bl, boolean bl2) throws SQLException {
        QZt qZt = QZt.zt;
        QNotizen qNotizen = QNotizen.notizen;
        if (bl && bl2) {
            return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qZt.datenid).from((Expression<?>)qZt)).where(qZt.bildid.goe(0).and(qZt.datenid.goe(0)).and(qZt.datenid.in((SubQueryExpression<Integer>)SQLExpressions.select(qNotizen.datenid).from((Expression<?>)qNotizen))))).fetch();
        }
        if (bl) {
            return ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qZt.datenid).from((Expression<?>)qZt)).where(qZt.bildid.goe(0).and(qZt.datenid.goe(0)))).fetch();
        }
        if (bl2) {
            return ((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNotizen.datenid).from((Expression<?>)qNotizen)).fetch();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean createDB(IReparaturDialog iReparaturDialog) {
        try {
            iReparaturDialog.setText(this.i18n.getString("db_m307"));
            this.logger.info("loesche event. vorhandene Tabellen...");
            if (!this.datenbankService.dropAllTables()) {
                return false;
            }
            iReparaturDialog.incrementFortschritt();
            iReparaturDialog.setText(this.i18n.getString("db_m308"));
            this.logger.info("erstelle Tabellen neu...");
            if (!this.datenbankService.createAllTables()) {
                return false;
            }
            iReparaturDialog.incrementFortschritt();
            iReparaturDialog.setText(this.i18n.getString("db_m309"));
            this.logger.info("createDB(): fertig");
            return true;
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
            this.logger.showErrorMessageBox((JFrame)((Object)iReparaturDialog), this.i18n.getString("db_f16") + "\n" + sQLException.toString(), this.i18n.getString("db_f4_titel"));
            return false;
        }
    }

    private void findeExoplanetenOhneEntdeckungsjahr() {
        QNamen qNamen = QNamen.namen1;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)this.qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)this.qDaten.id.eq(qNamen.datenid))).where(this.qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(this.qObjekttypen.id).from((Expression<?>)this.qObjekttypen)).where(this.qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(ObjektKategorie.PLANETEN.getKategorienName()))))).and(this.qDaten.entdeckungsjahr.isNull().or(this.qDaten.entdeckungsjahr.eq(0))).and(this.qDaten.zugehoerigkeit.ne((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("Sonne")))))).fetch();
        for (String string : list) {
            this.logger.debug("Exoplanet '" + string + "' hat kein entdeckungsjahr!");
        }
    }

    private void searchNonUpdatedExoplanets() {
        try {
            QNamen qNamen = QNamen.namen1;
            Timestamp timestamp = Timestamp.from(Instant.now().minusSeconds(157680000L));
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.stamp}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(this.qObjekttypen.id).from((Expression<?>)this.qObjekttypen)).where(this.qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(ObjektKategorie.PLANETEN.getKategorienName()))))).and(this.qDaten.stamp.lt(timestamp)).and(this.qDaten.zugehoerigkeit.ne((Expression)((SQLQuery)SQLExpressions.select(qNamen.datenid).from((Expression<?>)qNamen)).where(qNamen.namen.eq("Sonne")))).and(this.qDaten.entdeckungbestaetigt.isTrue()))).fetch();
            for (Tuple tuple : list) {
                int n = tuple.get(this.qDaten.id);
                String string = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.KEINE_SORTIERUNG).get(0);
                this.logger.debug("Exoplanet '" + string + "' wurde seit dem " + String.valueOf(tuple.get(this.qDaten.stamp)) + " nicht mehr aktualisiert!");
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
    }

    private void searchNonUpdatedStars() {
        try {
            Timestamp timestamp = Timestamp.from(Instant.now().minusSeconds(473040000L));
            List list = ((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{this.qDaten.id, this.qDaten.stamp}).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((SubQueryExpression)((SQLQuery)SQLExpressions.select(this.qObjekttypen.id).from((Expression<?>)this.qObjekttypen)).where(this.qObjekttypen.kategorieid.eq((Expression)((SQLQuery)SQLExpressions.select(this.qKategorie.id).from((Expression<?>)this.qKategorie)).where(this.qKategorie.name.eq(ObjektKategorie.STERNE.getKategorienName()))))).and(this.qDaten.stamp.lt(timestamp)))).fetch();
            for (Tuple tuple : list) {
                int n = tuple.get(this.qDaten.id);
                String string = this.objektnamenRepository.getNamenByDatenId(n, ObjektnamenSortierung.KEINE_SORTIERUNG).get(0);
                this.logger.debug("Stern '" + string + "' wurde seit dem " + String.valueOf(tuple.get(this.qDaten.stamp)) + " nicht mehr aktualisiert!");
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
    }
}

