/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.formeln.EarthSimilarityIndexExoplanetCalculator;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public class ExoplanetsEsiRepository {
    private final ILogging logger;
    private final IDatenbankverbinder datenbankverbinder;
    private final EarthSimilarityIndexExoplanetCalculator esicalculator;
    private final IObjektnamenRepository objectnameRepo;
    private final IIdCacheDAO idCache;

    @Inject
    public ExoplanetsEsiRepository(IDatenbankverbinder iDatenbankverbinder, IObjektnamenRepository iObjektnamenRepository, IIdCacheDAO iIdCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.esicalculator = new EarthSimilarityIndexExoplanetCalculator();
        this.objectnameRepo = iObjektnamenRepository;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.idCache = iIdCacheDAO;
    }

    public List<Pair<String, Double>> findPlNameAndEsiValueOrderedByEsiDesc() {
        ArrayList<Pair<String, Double>> arrayList = new ArrayList<Pair<String, Double>>();
        QDaten qDaten = new QDaten("exoplanets");
        QDaten qDaten2 = new QDaten("stars");
        try {
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten.entfernung, qDaten.umlaufszeit, qDaten2.ah, qDaten2.temperatur, qDaten2.durchmesser}).from((Expression<?>)qDaten)).join((EntityPath)qDaten2)).on((Predicate)qDaten.zugehoerigkeit.eq(qDaten2.id))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.entdeckungbestaetigt.isTrue()).and(qDaten.durchmesser.between(0.07136, 0.1115)).and(qDaten.entfernung.gt(0.0).or(qDaten.umlaufszeit.gt(0.0))).and(qDaten2.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten2.ah.gt(-100.0)).and(qDaten2.temperatur.gt(0.0)).and(qDaten2.durchmesser.gt(0.0)).and(qDaten2.id.ne(this.idCache.getDatenIdSonne())))).fetch();
            for (Tuple tuple : list) {
                Optional<Double> optional = this.esicalculator.calcESI(tuple.get(qDaten.durchmesser), tuple.get(qDaten.entfernung), tuple.get(qDaten.umlaufszeit), tuple.get(qDaten2.ah), tuple.get(qDaten2.temperatur), tuple.get(qDaten2.durchmesser));
                if (!optional.isPresent() || !(optional.get() >= 0.652)) continue;
                List<String> list2 = this.objectnameRepo.getNamenByDatenId(tuple.get(qDaten.id), ObjektnamenSortierung.BEKANNTHEIT);
                arrayList.add(Pair.of(list2.get(0), optional.get()));
            }
            Collections.sort(arrayList, (pair, pair2) -> -1 * Double.compare((Double)pair.getValue(), (Double)pair2.getValue()));
        }
        catch (SQLException sQLException) {
            this.logger.error(sQLException);
        }
        return arrayList;
    }
}

