/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datenbank.dbmodel.api.IKoordinatenDAO;
import de.planetensuche.datenbank.dbmodel.api.KoordinatenDto;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QKategorie;
import de.planetensuche.datenbankkern.querydsl5.QObjekttypen;
import de.planetensuche.datenbankkern.querydsl5.QSternbilder;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.ArrayList;
import java.util.List;

public final class KoordinatenDAO
implements IKoordinatenDAO {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final IObjektnamenRepository objektnamenRepository;
    private final IDatenbankverbinder datenbankverbinder;
    private final IDatenbankService datenbankService;

    @Inject
    public KoordinatenDAO(IObjektnamenRepository iObjektnamenRepository, IDatenbankverbinder iDatenbankverbinder, IDatenbankService iDatenbankService) {
        this.objektnamenRepository = iObjektnamenRepository;
        this.datenbankverbinder = iDatenbankverbinder;
        this.datenbankService = iDatenbankService;
    }

    @Override
    public List<KoordinatenDto> getObjekteBeiKoords(double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<KoordinatenDto> arrayList = new ArrayList<KoordinatenDto>();
        try {
            QDaten qDaten = QDaten.daten;
            QZt qZt = QZt.zt;
            QSternbilder qSternbilder = QSternbilder.sternbilder;
            QObjekttypen qObjekttypen = QObjekttypen.objekttypen;
            QKategorie qKategorie = QKategorie.kategorie;
            OrderSpecifier orderSpecifier = bl2 ? qDaten.decl.asc() : (bl3 ? qDaten.sh.asc() : qDaten.ra.asc());
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.ra, qDaten.decl, qObjekttypen.typ, qDaten.sh, qKategorie.name, qSternbilder.dtbezeichnung, qSternbilder.latbezeichnung, qSternbilder.engbezeichnung}).from((Expression<?>)qDaten)).join((EntityPath)qZt)).on((Predicate)qZt.datenid.eq(qDaten.id))).join((EntityPath)qSternbilder)).on((Predicate)qSternbilder.id.eq(qZt.sternbildid))).join((EntityPath)qObjekttypen)).on((Predicate)qObjekttypen.id.eq(qDaten.objektid))).join((EntityPath)qKategorie)).on((Predicate)qKategorie.id.eq(qObjekttypen.kategorieid))).where(qDaten.ra.goe(d).and(qDaten.ra.loe(d2)).and(qDaten.decl.goe(d3)).and(qDaten.decl.loe(d4)))).orderBy((OrderSpecifier<?>)orderSpecifier)).fetch();
            SternbildSprache sternbildSprache = this.datenbankService.getSternbildsprache();
            for (Tuple tuple : list) {
                KoordinatenDto koordinatenDto = new KoordinatenDto();
                List<String> list2 = this.objektnamenRepository.getNamenByDatenId(tuple.get(qDaten.id), ObjektnamenSortierung.BEKANNTHEIT);
                koordinatenDto.setObjektname(list2.get(0));
                koordinatenDto.setRa(tuple.get(qDaten.ra));
                koordinatenDto.setDecl(tuple.get(qDaten.decl));
                koordinatenDto.setScheinbareHelligkeit(tuple.get(qDaten.sh));
                if (SternbildSprache.DEUTSCH.equals((Object)sternbildSprache)) {
                    koordinatenDto.setSternbildName(tuple.get(qSternbilder.dtbezeichnung));
                } else if (SternbildSprache.LATEINISCH.equals((Object)sternbildSprache)) {
                    koordinatenDto.setSternbildName(tuple.get(qSternbilder.latbezeichnung));
                } else {
                    koordinatenDto.setSternbildName(tuple.get(qSternbilder.engbezeichnung));
                }
                koordinatenDto.setKategorie(tuple.get(qKategorie.name));
                koordinatenDto.setObjektTyp(tuple.get(qObjekttypen.typ));
                arrayList.add(koordinatenDto);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logging.error("Fehler in getObjekteBeiKoords(" + d + "," + d2 + "," + d3 + "," + d4 + "," + bl + "," + bl2 + "," + bl3 + ")", runtimeException);
        }
        return arrayList;
    }
}

