/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datenbank.dbmodel.basis;

import com.google.inject.Inject;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ILeuchtkraftklassenDao;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QLumin;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp2;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.Collection;
import java.util.List;

public final class LeuchtkraftklassenDao
implements ILeuchtkraftklassenDao {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDatenbankverbinder datenbankverbinder;
    private final IIdCacheDAO idCache;

    @Inject
    public LeuchtkraftklassenDao(IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCache = iIdCacheDAO;
    }

    @Override
    public String[][] findAbsHelligkeitSpTypLk() {
        try {
            QDaten qDaten = QDaten.daten;
            QLumin qLumin = QLumin.lumin;
            QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
            QSpektraltyp2 qSpektraltyp2 = QSpektraltyp2.spektraltyp2;
            List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select(new Expression[]{qDaten.ah, qSpektraltyp.typ, qSpektraltyp2.typ, qLumin.typ}).from((Expression<?>)qDaten)).leftJoin((ForeignKey)qDaten.sptypFk, (RelationalPath)qSpektraltyp)).leftJoin((ForeignKey)qDaten.sptyp2Fk, (RelationalPath)qSpektraltyp2)).leftJoin((ForeignKey)qDaten.luminFk, (RelationalPath)qLumin)).where(qLumin.typ.isNotNull().and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.spektralklasse.isNotNull()).and(qDaten.ah.isNotNull()).and(qDaten.ah.gt(-100.0)).and(qSpektraltyp.typ.ne("unbekannt")).and(qLumin.typ.ne("unbekannt")))).fetch();
            String[][] stringArray = new String[list.size()][3];
            int n = 0;
            for (Tuple tuple : list) {
                Double d = tuple.get(qDaten.ah);
                String string = tuple.get(qSpektraltyp.typ);
                Double d2 = tuple.get(qSpektraltyp2.typ);
                String string2 = tuple.get(qLumin.typ);
                if (d != null && d2 != null) {
                    String[] stringArray2 = new String[]{d.toString(), string + d2.toString(), string2};
                    stringArray[n] = stringArray2;
                    ++n;
                    continue;
                }
                this.logging.warn("absMag " + d + " oder sptyp2 " + d2 + " ist null");
            }
            return stringArray;
        }
        catch (Exception exception) {
            this.logging.error("Fehler in findAbsHelligkeitSpTypLk()", exception);
            return null;
        }
    }
}

